/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.context;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.metadata.ValidationValueException;
import org.eclipse.birt.report.model.api.util.ParameterValidationUtil;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.BirtUtility;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ViewerAttributeBean
extends BaseAttributeBean {
    private int maxRows;
    private Map parametersAsString = null;
    private Collection parameterDefList = null;
    private Map displayTexts = null;
    private Map defaultValues;
    private Map moduleOptions = null;
    private boolean isDocumentProcessing = false;

    public ViewerAttributeBean(HttpServletRequest httpServletRequest) {
        try {
            this.init(httpServletRequest);
        }
        catch (Exception exception) {
            this.exception = exception;
        }
    }

    protected void __init(HttpServletRequest httpServletRequest) throws Exception {
        if (ParameterAccessor.isGetImageOperator(httpServletRequest)) {
            return;
        }
        this.category = "BIRT";
        this.masterPageContent = ParameterAccessor.isMasterPageContent(httpServletRequest);
        this.isDesigner = ParameterAccessor.isDesigner(httpServletRequest);
        this.bookmark = ParameterAccessor.getBookmark(httpServletRequest);
        this.reportPage = String.valueOf(ParameterAccessor.getPage(httpServletRequest));
        this.reportDocumentName = ParameterAccessor.getReportDocument(httpServletRequest);
        this.reportDesignName = ParameterAccessor.getReport(httpServletRequest);
        this.format = ParameterAccessor.getFormat(httpServletRequest);
        this.maxRows = ParameterAccessor.getMaxRows(httpServletRequest);
        BirtResources.setLocale(ParameterAccessor.getLocale(httpServletRequest));
        ReportEngineService.getInstance().setMaxRows(this.maxRows);
        this.processReport(httpServletRequest);
        String string = BirtResources.getMessage("birt.viewer.title");
        this.reportTitle = ParameterAccessor.htmlEncode(string);
        this.__initParameters(httpServletRequest);
    }

    protected void __initParameters(HttpServletRequest httpServletRequest) throws Exception {
        this.reportDesignHandle = this.getDesignHandle(httpServletRequest);
        if (this.reportDesignHandle == null) {
            return;
        }
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        inputOptions.setOption("locale", this.locale);
        inputOptions.setOption("rtl", new Boolean(this.rtl));
        this.parameterDefList = this.getReportService().getParameterDefinitions(this.reportDesignHandle, inputOptions, false);
        if (this.isDesigner && !"/frameset".equalsIgnoreCase(httpServletRequest.getServletPath())) {
            this.parseConfigVars(httpServletRequest, this.parameterDefList);
        }
        this.parametersAsString = this.getParsedParametersAsString(this.parameterDefList, httpServletRequest, inputOptions);
        this.missingParameter = this.documentInUrl ? false : ViewerAttributeBean.validateParameters(this.parameterDefList, this.parametersAsString);
        this.defaultValues = this.getDefaultValues(this.reportDesignHandle, this.parameterDefList, httpServletRequest, inputOptions);
        this.displayTexts = this.getDisplayTexts(this.displayTexts, httpServletRequest);
        this.parameters = (HashMap)this.getParsedParameters(this.reportDesignHandle, this.parameterDefList, httpServletRequest, inputOptions);
        this.parametersAsString = this.getParsedParametersAsStringWithDefaultValue(this.parametersAsString, this.parameterDefList, httpServletRequest, inputOptions);
        this.moduleOptions = this.getModuleOptions(httpServletRequest);
    }

    protected void parseConfigVars(HttpServletRequest httpServletRequest, Collection collection) {
        this.configMap = new HashMap();
        String string = ParameterAccessor.getConfigFileName(this.reportDesignName);
        if (string == null) {
            return;
        }
        SessionHandle sessionHandle = DesignEngine.newSession((ULocale)ULocale.US);
        ReportDesignHandle reportDesignHandle = null;
        try {
            reportDesignHandle = sessionHandle.openDesign(string);
            if (reportDesignHandle != null) {
                String string2 = null;
                Iterator iterator = reportDesignHandle.configVariablesIterator();
                while (iterator != null && iterator.hasNext()) {
                    Object object;
                    ConfigVariableHandle configVariableHandle = (ConfigVariableHandle)iterator.next();
                    if (configVariableHandle == null || configVariableHandle.getName() == null) continue;
                    String string3 = configVariableHandle.getName();
                    String string4 = configVariableHandle.getValue();
                    if (string3.toLowerCase().startsWith("__isnull") && string4 != null) {
                        object = this.getParameterName(string4, collection);
                        if (object == null) continue;
                        this.configMap.put(object, null);
                        continue;
                    }
                    string2 = ParameterAccessor.isDisplayText(string3);
                    if (string2 != null) {
                        string3 = this.getParameterName(string2, collection);
                        if (string3 == null) continue;
                        if (this.displayTexts == null) {
                            this.displayTexts = new HashMap();
                        }
                        this.displayTexts.put(string3, string4);
                        continue;
                    }
                    string3 = this.getParameterName(string3, collection);
                    object = BirtUtility.findParameterDefinition(collection, string3);
                    if (string4 == null || object == null) continue;
                    String string5 = configVariableHandle.getName() + "_" + "type";
                    ConfigVariable configVariable = reportDesignHandle.findConfigVariable(string5);
                    String string6 = ParameterDataTypeConverter.ConvertDataType(((ParameterDefinition)object).getDataType());
                    String string7 = null;
                    if (configVariable != null) {
                        string7 = configVariable.getValue();
                    }
                    if (string7 == null || !string7.equalsIgnoreCase(string6)) continue;
                    this.configMap.put(string3, string4);
                }
                reportDesignHandle.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getParameterName(String string, Collection collection) throws ReportServiceException {
        String string2 = null;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
                String string3 = null;
                if (parameterDefinition != null && parameterDefinition.getName() != null) {
                    string3 = parameterDefinition.getName() + "_" + parameterDefinition.getId();
                }
                if (string3 == null || !string3.equalsIgnoreCase(string)) continue;
                string2 = parameterDefinition.getName();
                break;
            }
        }
        return string2;
    }

    protected IViewerReportDesignHandle getDesignHandle(HttpServletRequest httpServletRequest) {
        Object object;
        BirtViewerReportDesignHandle birtViewerReportDesignHandle = null;
        IReportRunnable iReportRunnable = null;
        boolean bl = ParameterAccessor.isValidFilePath(this.reportDocumentName);
        if (bl && (object = ReportEngineService.getInstance().openReportDocument(this.reportDesignName, this.reportDocumentName, this.getModuleOptions(httpServletRequest))) != null) {
            iReportRunnable = object.getReportRunnable();
            if ("/frameset".equalsIgnoreCase(httpServletRequest.getServletPath())) {
                this.parameterMap = object.getParameterValues();
            }
            if (ParameterAccessor.getParameter(httpServletRequest, "__document") != null) {
                this.documentInUrl = true;
            }
            if (!object.isComplete() && ParameterAccessor.isReportParameterExist(httpServletRequest, "__report")) {
                this.isDocumentProcessing = true;
            }
            object.close();
        }
        if (iReportRunnable == null) {
            if (ParameterAccessor.isReportParameterExist(httpServletRequest, "__document") && !ParameterAccessor.isReportParameterExist(httpServletRequest, "__report")) {
                this.exception = bl ? new ViewerException("birt.viewer.generalException.DOCUMENT_FILE_ERROR", new String[]{this.reportDocumentName}) : new ViewerException("birt.viewer.generalException.DOCUMENT_ACCESS_ERROR", new String[]{this.reportDocumentName});
                return birtViewerReportDesignHandle;
            }
            if (!ParameterAccessor.isValidFilePath(this.reportDesignName)) {
                this.exception = new ViewerException("birt.viewer.generalException.REPORT_ACCESS_ERROR", new String[]{this.reportDesignName});
            } else {
                try {
                    object = new File(this.reportDesignName);
                    if (((File)object).exists()) {
                        iReportRunnable = ReportEngineService.getInstance().openReportDesign(this.reportDesignName, this.getModuleOptions(httpServletRequest));
                    } else if (!ParameterAccessor.isWorkingFolderAccessOnly()) {
                        this.reportDesignName = ParameterAccessor.getParameter(httpServletRequest, "__report");
                        InputStream inputStream = null;
                        URL uRL = null;
                        try {
                            String string = this.reportDesignName;
                            if (!string.startsWith("/")) {
                                string = "/" + string;
                            }
                            if ((uRL = httpServletRequest.getSession().getServletContext().getResource(string)) != null) {
                                inputStream = uRL.openStream();
                            }
                            if (inputStream != null) {
                                iReportRunnable = ReportEngineService.getInstance().openReportDesign(uRL.toString(), inputStream, this.getModuleOptions(httpServletRequest));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (iReportRunnable == null) {
                        this.exception = new ViewerException("birt.viewer.generalException.REPORT_FILE_ERROR", new String[]{this.reportDesignName});
                    }
                }
                catch (EngineException engineException) {
                    this.exception = engineException;
                }
            }
        }
        if (iReportRunnable != null) {
            birtViewerReportDesignHandle = new BirtViewerReportDesignHandle("rptRunnableObject", iReportRunnable);
        }
        return birtViewerReportDesignHandle;
    }

    protected void processReport(HttpServletRequest httpServletRequest) throws Exception {
        File file = new File(this.reportDocumentName);
        File file2 = new File(this.reportDesignName);
        if (file2 != null && file2.exists() && file2.isFile() && file != null && file.exists() && file.isFile() && "get".equalsIgnoreCase(httpServletRequest.getMethod()) && (file2.lastModified() > file.lastModified() || ParameterAccessor.isOverwrite(httpServletRequest))) {
            file.delete();
        }
    }

    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }

    protected void __finalize() throws Throwable {
    }

    protected Map getDefaultValues(IViewerReportDesignHandle iViewerReportDesignHandle, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null || (string = parameterDefinition.getName()) == null) continue;
            Object object = this.getReportService().getParameterDefaultValue(iViewerReportDesignHandle, string, inputOptions);
            hashMap.put(string, object);
        }
        return hashMap;
    }

    protected Map getParsedParameters(IViewerReportDesignHandle iViewerReportDesignHandle, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (collection == null || this.parametersAsString == null) {
            return hashMap;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null) continue;
            String string = parameterDefinition.getName();
            String string2 = (String)this.parametersAsString.get(string);
            if (string2 != null) {
                try {
                    String string3 = ParameterAccessor.getFormat(httpServletRequest, string);
                    if (string3 == null || string3.length() <= 0) {
                        string3 = parameterDefinition.getPattern();
                    }
                    String string4 = ParameterDataTypeConverter.ConvertDataType(parameterDefinition.getDataType());
                    Object object = DataUtil.validate(string4, string3, string2, this.locale);
                    hashMap.put(string, object);
                    continue;
                }
                catch (ValidationValueException validationValueException) {
                    if (!"/preview".equalsIgnoreCase(httpServletRequest.getServletPath())) continue;
                    this.exception = validationValueException;
                    break;
                }
            }
            if (this.parametersAsString.containsKey(string)) {
                hashMap.put(string, null);
                continue;
            }
            hashMap.put(string, this.defaultValues.get(string));
        }
        return hashMap;
    }

    protected String getParamValueAsString(HttpServletRequest httpServletRequest, ScalarParameterHandle scalarParameterHandle) {
        String string = scalarParameterHandle.getName();
        String string2 = null;
        if (ParameterAccessor.isReportParameterExist(httpServletRequest, string)) {
            string2 = ParameterAccessor.getReportParameter(httpServletRequest, string, null);
            return string2;
        }
        Object object = null;
        if (this.isDesigner && ("/run".equalsIgnoreCase(httpServletRequest.getServletPath()) || "/parameter".equalsIgnoreCase(httpServletRequest.getServletPath())) && this.configMap != null && this.configMap.containsKey(string)) {
            object = this.configMap.get(string);
        } else if (this.parameterMap != null && this.parameterMap.containsKey(string)) {
            object = this.parameterMap.get(string);
            object = ParameterValidationUtil.getDisplayValue(null, (String)scalarParameterHandle.getPattern(), (Object)object, (Locale)this.locale);
        }
        if (object != null) {
            string2 = object.toString();
        }
        return string2;
    }

    protected Map getParsedParametersAsString(Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (collection == null) {
            return hashMap;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null || (string = parameterDefinition.getName()) == null) continue;
            String string2 = null;
            if (ParameterAccessor.isReportParameterExist(httpServletRequest, string)) {
                string2 = ParameterAccessor.getReportParameter(httpServletRequest, string, null);
                hashMap.put(string, string2);
                continue;
            }
            Object var9_9 = null;
            if (this.isDesigner && !"/frameset".equalsIgnoreCase(httpServletRequest.getServletPath()) && this.configMap != null && this.configMap.containsKey(string)) {
                var9_9 = this.configMap.get(string);
            } else {
                if (this.parameterMap == null || !this.parameterMap.containsKey(string)) continue;
                var9_9 = this.parameterMap.get(string);
            }
            string2 = DataUtil.getDisplayValue(var9_9);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    protected Map getParsedParametersAsStringWithDefaultValue(Map hashMap, Collection collection, HttpServletRequest httpServletRequest, InputOptions inputOptions) throws ReportServiceException {
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            if (parameterDefinition == null || (string = parameterDefinition.getName()) == null || hashMap.containsKey(string)) continue;
            hashMap.put(string, DataUtil.getDisplayValue(this.defaultValues.get(string)));
        }
        return hashMap;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public String getReportTitle() throws ReportServiceException {
        IReportRunnable iReportRunnable;
        String string;
        Object object;
        String string2 = this.reportTitle;
        if (this.reportDesignHandle != null && (object = this.reportDesignHandle.getDesignObject()) instanceof IReportRunnable && (string = (String)(iReportRunnable = (IReportRunnable)object).getProperty("title")) != null && string.trim().length() > 0) {
            string2 = string;
        }
        return string2;
    }

    protected Map getDisplayTexts(Map hashMap, HttpServletRequest httpServletRequest) {
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = DataUtil.getString(enumeration.nextElement());
            String string2 = ParameterAccessor.isDisplayText(string);
            if (string2 == null) continue;
            hashMap.put(string2, ParameterAccessor.getParameter(httpServletRequest, string));
        }
        return hashMap;
    }

    public ParameterDefinition findParameterDefinition(String string) {
        return BirtUtility.findParameterDefinition(this.parameterDefList, string);
    }

    protected Map getModuleOptions(HttpServletRequest httpServletRequest) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("resourceFolder", ParameterAccessor.getResourceFolder(httpServletRequest));
        return hashMap;
    }

    public Map getParametersAsString() {
        return this.parametersAsString;
    }

    public Collection getParameterDefList() {
        return this.parameterDefList;
    }

    public Map getDisplayTexts() {
        return this.displayTexts;
    }

    public Map getModuleOptions() {
        return this.moduleOptions;
    }

    public boolean isDocumentProcessing() {
        return this.isDocumentProcessing;
    }

    public Map getDefaultValues() {
        return this.defaultValues;
    }
}

