/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.ICascadingParameterGroup;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.ReportParameterConverter;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.BirtViewerReportDesignHandle;
import org.eclipse.birt.report.service.ReportEngineService;
import org.eclipse.birt.report.service.api.ExportedColumn;
import org.eclipse.birt.report.service.api.ExportedResultSet;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ParameterSelectionChoice;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.service.api.ToC;
import org.eclipse.birt.report.soapengine.api.Column;
import org.eclipse.birt.report.soapengine.api.ResultSet;

public class BirtViewerReportService
implements IViewerReportService {
    static final /* synthetic */ boolean $assertionsDisabled;

    public BirtViewerReportService(ServletConfig servletConfig) {
        try {
            ReportEngineService.initEngineInstance(servletConfig);
        }
        catch (BirtException birtException) {
            birtException.printStackTrace();
        }
    }

    public String runReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map) throws ReportServiceException {
        return this.runReport(iViewerReportDesignHandle, string, inputOptions, map, null);
    }

    public String runReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map, Map map2) throws ReportServiceException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)httpServletRequest.getAttribute("attributeBean");
        HashMap hashMap = viewerAttributeBean.getParameters();
        if (map != null) {
            hashMap.putAll(map);
        }
        Map map3 = viewerAttributeBean.getDisplayTexts();
        if (map2 != null) {
            map3.putAll(map2);
        }
        IReportRunnable iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
        try {
            ReportEngineService.getInstance().runReport(httpServletRequest, iReportRunnable, string, locale, hashMap, map3);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
        return string;
    }

    public IViewerReportDesignHandle getReportDesignHandle(String string, InputOptions inputOptions) {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        String string2 = iReportDocument.getReportRunnable().getReportName();
        iReportDocument.close();
        BirtViewerReportDesignHandle birtViewerReportDesignHandle = new BirtViewerReportDesignHandle(null, string2);
        return birtViewerReportDesignHandle;
    }

    public ByteArrayOutputStream getPage(String string, String string2, InputOptions inputOptions, List list) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        Boolean bl2 = (Boolean)inputOptions.getOption("svgFlag");
        Long l = Long.valueOf(string2);
        Boolean bl3 = (Boolean)inputOptions.getOption("rtl");
        try {
            ByteArrayOutputStream byteArrayOutputStream = ReportEngineService.getInstance().renderReport(httpServletRequest, iReportDocument, l, bl, bl2, list, locale, bl3);
            iReportDocument.close();
            return byteArrayOutputStream;
        }
        catch (RemoteException remoteException) {
            iReportDocument.close();
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
    }

    public ByteArrayOutputStream getPageByBookmark(String string, String string2, InputOptions inputOptions, List list) throws ReportServiceException {
        long l = this.getPageNumberByBookmark(string, string2, inputOptions);
        return this.getPage(string, l + "", inputOptions, list);
    }

    public ByteArrayOutputStream getPageByObjectId(String string, String string2, InputOptions inputOptions, List list) throws ReportServiceException {
        return null;
    }

    public void renderReportlet(String string, String string2, InputOptions inputOptions, List list, OutputStream outputStream) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean bl2 = bl == null ? false : bl;
        Boolean bl3 = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean bl4 = bl3 == null ? false : bl3;
        Boolean bl5 = (Boolean)inputOptions.getOption("rtl");
        try {
            ReportEngineService.getInstance().renderReportlet(outputStream, httpServletRequest, iReportDocument, string2, bl2, bl4, null, locale, bl5);
            iReportDocument.close();
        }
        catch (RemoteException remoteException) {
            iReportDocument.close();
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
    }

    public void renderReport(String string, String string2, InputOptions inputOptions, OutputStream outputStream) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        boolean bl2 = bl == null ? true : bl;
        Boolean bl3 = (Boolean)inputOptions.getOption("svgFlag");
        boolean bl4 = bl3 == null ? false : bl3;
        Boolean bl5 = (Boolean)inputOptions.getOption("rtl");
        Long l = null;
        if (string2 != null && string2.trim().length() >= 0) {
            l = Long.valueOf(string2);
        }
        long l2 = 1L;
        if (l != null) {
            l2 = l;
        }
        try {
            ReportEngineService.getInstance().renderReport(outputStream, httpServletRequest, iReportDocument, l2, bl2, bl4, null, locale, bl5);
            iReportDocument.close();
        }
        catch (RemoteException remoteException) {
            iReportDocument.close();
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
    }

    public void extractResultSet(String string, String string2, Collection collection, Set set, InputOptions inputOptions, OutputStream outputStream) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        Locale locale = (Locale)inputOptions.getOption("locale");
        try {
            ReportEngineService.getInstance().extractData(iReportDocument, string2, collection, locale, outputStream);
            iReportDocument.close();
        }
        catch (RemoteException remoteException) {
            iReportDocument.close();
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
    }

    public List getResultSetsMetadata(String string, InputOptions inputOptions) throws ReportServiceException {
        ResultSet[] resultSetArray;
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        if (iReportDocument == null) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.EXTRACT_DATA_NO_DOCUMENT"));
        }
        try {
            resultSetArray = ReportEngineService.getInstance().getResultSets(iReportDocument);
            iReportDocument.close();
        }
        catch (RemoteException remoteException) {
            iReportDocument.close();
            remoteException.printStackTrace();
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
        if (resultSetArray == null || resultSetArray.length < 0) {
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.EXTRACT_DATA_NO_RESULT_SET"));
        }
        return this.transformResultSetArray(resultSetArray);
    }

    public List getResultSetsMetadata(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        return null;
    }

    public void getImage(String string, String string2, OutputStream outputStream, InputOptions inputOptions) throws ReportServiceException {
        try {
            ReportEngineService.getInstance().renderImage(string2, outputStream);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
    }

    public ToC getTOC(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        TOCNode tOCNode = null;
        if (iReportDocument != null) {
            Locale locale = null;
            if (inputOptions != null) {
                locale = (Locale)inputOptions.getOption("locale");
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ITOCTree iTOCTree = iReportDocument.getTOCTree("viewer", ULocale.forLocale((Locale)locale));
            tOCNode = string2 != null ? iTOCTree.findTOC(string2) : iTOCTree.findTOC(null);
        }
        if (tOCNode == null) {
            if (iReportDocument != null) {
                iReportDocument.close();
            }
            throw new ReportServiceException(BirtResources.getMessage("birt.viewer.reportServiceException.INVALID_TOC"));
        }
        if (iReportDocument != null) {
            iReportDocument.close();
        }
        return BirtViewerReportService.transformTOCNode(tOCNode);
    }

    public String findTocByName(String string, String string2, InputOptions inputOptions) {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        String string3 = null;
        if (iReportDocument != null) {
            Locale locale = null;
            if (inputOptions != null) {
                locale = (Locale)inputOptions.getOption("locale");
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ITOCTree iTOCTree = iReportDocument.getTOCTree("viewer", ULocale.forLocale((Locale)locale));
            if (!$assertionsDisabled && iTOCTree == null) {
                throw new AssertionError();
            }
            List list = iTOCTree.findTOCByValue((Object)string2);
            if (list != null && list.size() > 0) {
                return ((TOCNode)list.get(0)).getBookmark();
            }
            iReportDocument.close();
        }
        return string3;
    }

    public long getPageCount(String string, InputOptions inputOptions, OutputOptions outputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        long l = iReportDocument.getPageCount();
        iReportDocument.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getParameterDefinitions(IViewerReportDesignHandle iViewerReportDesignHandle, InputOptions inputOptions, boolean bl) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
            if (iGetParameterDefinitionTask != null) {
                Collection collection = iGetParameterDefinitionTask.getParameterDefns(true);
                Collection collection2 = BirtViewerReportService.convertEngineParameters(collection, bl);
                return collection2;
            }
        }
        finally {
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
        }
        return null;
    }

    public Map getParameterValues(String string, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        Map map = iReportDocument.getParameterValues();
        iReportDocument.close();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSelectionListForCascadingGroup(IViewerReportDesignHandle iViewerReportDesignHandle, String string, Object[] objectArray, InputOptions inputOptions) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
            if (iGetParameterDefinitionTask != null) {
                ViewerAttributeBean viewerAttributeBean = this.getViewerAttrBean(inputOptions);
                if (viewerAttributeBean != null) {
                    iGetParameterDefinitionTask.setParameterValues((Map)viewerAttributeBean.getParameters());
                }
                iGetParameterDefinitionTask.evaluateQuery(string);
                Collection collection = iGetParameterDefinitionTask.getSelectionListForCascadingGroup(string, objectArray);
                Collection collection2 = BirtViewerReportService.convertEngineParameterSelectionChoice(collection);
                return collection2;
            }
        }
        finally {
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getParameterSelectionList(IViewerReportDesignHandle iViewerReportDesignHandle, InputOptions inputOptions, String string) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        try {
            iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
            if (iGetParameterDefinitionTask != null) {
                ViewerAttributeBean viewerAttributeBean = this.getViewerAttrBean(inputOptions);
                if (viewerAttributeBean != null) {
                    iGetParameterDefinitionTask.setParameterValues((Map)viewerAttributeBean.getParameters());
                }
                Collection collection = iGetParameterDefinitionTask.getSelectionList(string);
                Collection collection2 = BirtViewerReportService.convertEngineParameterSelectionChoice(collection);
                return collection2;
            }
        }
        finally {
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
        }
        return null;
    }

    private IGetParameterDefinitionTask getParameterDefinitionTask(IViewerReportDesignHandle iViewerReportDesignHandle, InputOptions inputOptions) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask;
        if (iViewerReportDesignHandle.getContentType() == "rptRunnableObject") {
            IReportRunnable iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
            iGetParameterDefinitionTask = ReportEngineService.getInstance().createGetParameterDefinitionTask(iReportRunnable);
        } else {
            try {
                iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle.getFileName(), inputOptions);
            }
            catch (EngineException engineException) {
                throw new ReportServiceException(engineException.getLocalizedMessage());
            }
        }
        return iGetParameterDefinitionTask;
    }

    public long getPageNumberByBookmark(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        long l = iReportDocument.getPageNumber(string2);
        iReportDocument.close();
        return l;
    }

    public long getPageNumberByObjectId(String string, String string2, InputOptions inputOptions) throws ReportServiceException {
        IReportDocument iReportDocument = ReportEngineService.getInstance().openReportDocument(this.getReportDesignName(inputOptions), string, this.getModuleOptions(inputOptions));
        long l = iReportDocument.getPageNumber(string2);
        iReportDocument.close();
        return l;
    }

    public void runAndRenderReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map, OutputStream outputStream, List list) throws ReportServiceException {
        this.runAndRenderReport(iViewerReportDesignHandle, string, inputOptions, map, outputStream, list, null);
    }

    public void runAndRenderReport(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions, Map map, OutputStream outputStream, List list, Map map2) throws ReportServiceException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        Locale locale = (Locale)inputOptions.getOption("locale");
        Boolean bl = (Boolean)inputOptions.getOption("isMasterPageContent");
        Boolean bl2 = (Boolean)inputOptions.getOption("svgFlag");
        String string2 = (String)inputOptions.getOption("format");
        Boolean bl3 = (Boolean)inputOptions.getOption("rtl");
        try {
            IReportRunnable iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
            ReportEngineService.getInstance().runAndRenderReport(httpServletRequest, iReportRunnable, outputStream, string2, locale, bl3, map, (boolean)bl, bl2, map2);
        }
        catch (RemoteException remoteException) {
            throw new ReportServiceException(remoteException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getParameterDefaultValue(IViewerReportDesignHandle iViewerReportDesignHandle, String string, InputOptions inputOptions) throws ReportServiceException {
        IGetParameterDefinitionTask iGetParameterDefinitionTask = null;
        Object object = null;
        try {
            iGetParameterDefinitionTask = this.getParameterDefinitionTask(iViewerReportDesignHandle, inputOptions);
            if (iGetParameterDefinitionTask != null) {
                object = iGetParameterDefinitionTask.getDefaultValue(string);
            }
        }
        finally {
            if (iGetParameterDefinitionTask != null) {
                iGetParameterDefinitionTask.close();
            }
        }
        return object;
    }

    public void setContext(Object object, InputOptions inputOptions) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)inputOptions.getOption("request");
        ServletContext servletContext = (ServletContext)object;
        ReportEngineService.getInstance().setEngineContext(servletContext, httpServletRequest);
    }

    public Map getParsedParameters(IViewerReportDesignHandle iViewerReportDesignHandle, InputOptions inputOptions, Map map) throws ReportServiceException {
        Locale locale = (Locale)inputOptions.getOption("locale");
        Collection collection = this.getParameterDefinitions(iViewerReportDesignHandle, inputOptions, false);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Boolean bl = (Boolean)inputOptions.getOption("isDesigner");
        boolean bl2 = bl != null ? bl : false;
        IReportRunnable iReportRunnable = this.getReportRunnable(iViewerReportDesignHandle, this.getModuleOptions(inputOptions));
        HashMap hashMap2 = iReportRunnable.getTestConfig();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string;
            ParameterDefinition parameterDefinition = (ParameterDefinition)iterator.next();
            String string2 = null;
            Object object = null;
            String string3 = parameterDefinition.getName();
            String string4 = parameterDefinition.getPattern();
            ReportParameterConverter reportParameterConverter = new ReportParameterConverter(string4, locale);
            Set set = null;
            if (map != null) {
                set = map.keySet();
            }
            if (map == null || string3 == null) continue;
            boolean bl3 = false;
            Object object2 = set.iterator();
            while (object2.hasNext()) {
                string = (String)object2.next();
                if (!string3.equals(string)) continue;
                if (map.get(string) != null) {
                    string2 = map.get(string).toString();
                }
                object = reportParameterConverter.parse(string2, parameterDefinition.getDataType());
                hashMap.put(string3, object);
                bl3 = true;
                break;
            }
            if (!bl3 && hashMap2.containsKey(string3) && bl2) {
                object2 = (String)hashMap2.get(string3);
                string = new ReportParameterConverter(string4, Locale.US);
                object = string.parse((String)object2, parameterDefinition.getDataType());
                continue;
            }
            if (bl3) continue;
            object = this.getParameterDefaultValue(iViewerReportDesignHandle, parameterDefinition.getName(), inputOptions);
        }
        return hashMap;
    }

    public IReportRunnable getReportRunnable(IViewerReportDesignHandle iViewerReportDesignHandle, Map map) throws ReportServiceException {
        IReportRunnable iReportRunnable;
        if (iViewerReportDesignHandle.getContentType() == "rptRunnableObject") {
            iReportRunnable = (IReportRunnable)iViewerReportDesignHandle.getDesignObject();
        } else {
            try {
                iReportRunnable = ReportEngineService.getInstance().openReportDesign(iViewerReportDesignHandle.getFileName(), map);
            }
            catch (EngineException engineException) {
                throw new ReportServiceException(engineException.getLocalizedMessage());
            }
        }
        return iReportRunnable;
    }

    private static ToC transformTOCNode(TOCNode tOCNode) {
        ToC toC = new ToC(tOCNode.getNodeID(), tOCNode.getDisplayString(), tOCNode.getBookmark());
        toC.setChildren(BirtViewerReportService.getToCChildren(tOCNode));
        return toC;
    }

    private static List getToCChildren(TOCNode tOCNode) {
        if (tOCNode.getChildren() == null) {
            return null;
        }
        List list = tOCNode.getChildren();
        ArrayList<ToC> arrayList = new ArrayList<ToC>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TOCNode tOCNode2 = (TOCNode)iterator.next();
            ToC toC = new ToC(tOCNode2.getNodeID(), tOCNode2.getDisplayString(), tOCNode2.getBookmark());
            toC.setChildren(BirtViewerReportService.getToCChildren(tOCNode2));
            arrayList.add(toC);
        }
        return arrayList;
    }

    private IGetParameterDefinitionTask getParameterDefinitionTask(String string, InputOptions inputOptions) throws EngineException {
        IReportRunnable iReportRunnable = ReportEngineService.getInstance().openReportDesign(string, this.getModuleOptions(inputOptions));
        IGetParameterDefinitionTask iGetParameterDefinitionTask = ReportEngineService.getInstance().createGetParameterDefinitionTask(iReportRunnable);
        return iGetParameterDefinitionTask;
    }

    private List transformResultSetArray(ResultSet[] resultSetArray) {
        ArrayList<ExportedResultSet> arrayList = new ArrayList<ExportedResultSet>();
        for (int i = 0; i < resultSetArray.length; ++i) {
            ResultSet resultSet = resultSetArray[i];
            String string = resultSet.getQueryName();
            Column[] columnArray = resultSet.getColumn();
            ArrayList<ExportedColumn> arrayList2 = new ArrayList<ExportedColumn>();
            for (int j = 0; j < columnArray.length; ++j) {
                Column column = columnArray[j];
                ExportedColumn exportedColumn = new ExportedColumn(column.getName(), column.getLabel(), column.getVisibility());
                arrayList2.add(exportedColumn);
            }
            ExportedResultSet exportedResultSet = new ExportedResultSet(string, arrayList2);
            arrayList.add(exportedResultSet);
        }
        return arrayList;
    }

    private String getReportDesignName(InputOptions inputOptions) {
        HttpServletRequest httpServletRequest;
        String string = null;
        if (inputOptions != null && (httpServletRequest = (HttpServletRequest)inputOptions.getOption("request")) != null) {
            ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)httpServletRequest.getAttribute("attributeBean");
            if (!$assertionsDisabled && viewerAttributeBean == null) {
                throw new AssertionError();
            }
            string = viewerAttributeBean.getReportDesignName();
            if (string != null && (string.endsWith("\\") || string.endsWith("/"))) {
                string = null;
            }
        }
        return string;
    }

    private static Collection convertEngineParameters(Collection collection, boolean bl) {
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ParameterGroupDefinition parameterGroupDefinition;
            IScalarParameterDefn iScalarParameterDefn;
            Object e = iterator.next();
            if (e instanceof IScalarParameterDefn) {
                iScalarParameterDefn = (IScalarParameterDefn)e;
                parameterGroupDefinition = null;
                ParameterDefinition parameterDefinition = BirtViewerReportService.convertScalarParameter(iScalarParameterDefn, parameterGroupDefinition);
                arrayList.add(parameterDefinition);
                continue;
            }
            if (!(e instanceof IParameterGroupDefn)) continue;
            iScalarParameterDefn = (IParameterGroupDefn)e;
            parameterGroupDefinition = BirtViewerReportService.convertParameterGroup((IParameterGroupDefn)iScalarParameterDefn);
            arrayList.add(parameterGroupDefinition);
        }
        if (bl) {
            return arrayList;
        }
        return BirtViewerReportService.flattenGroups(arrayList);
    }

    private static List flattenGroups(List list) {
        if (list == null || list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ParameterGroupDefinition) {
                ParameterGroupDefinition parameterGroupDefinition = (ParameterGroupDefinition)e;
                arrayList.addAll(parameterGroupDefinition.getParameters());
                continue;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    private static List convertParametersInGroup(Collection collection, ParameterGroupDefinition parameterGroupDefinition) {
        if (collection == null) {
            return null;
        }
        ArrayList<ParameterDefinition> arrayList = new ArrayList<ParameterDefinition>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IScalarParameterDefn iScalarParameterDefn = (IScalarParameterDefn)iterator.next();
            ParameterDefinition parameterDefinition = BirtViewerReportService.convertScalarParameter(iScalarParameterDefn, parameterGroupDefinition);
            arrayList.add(parameterDefinition);
        }
        return arrayList;
    }

    private static ParameterGroupDefinition convertParameterGroup(IParameterGroupDefn iParameterGroupDefn) {
        boolean bl = iParameterGroupDefn instanceof ICascadingParameterGroup;
        String string = iParameterGroupDefn.getName();
        String string2 = iParameterGroupDefn.getDisplayName();
        String string3 = iParameterGroupDefn.getHelpText();
        String string4 = iParameterGroupDefn.getPromptText();
        ParameterGroupDefinition parameterGroupDefinition = new ParameterGroupDefinition(string, string2, string4, null, bl, string3);
        List list = BirtViewerReportService.convertParametersInGroup(iParameterGroupDefn.getContents(), parameterGroupDefinition);
        parameterGroupDefinition.setParameters(list);
        return parameterGroupDefinition;
    }

    private static ParameterDefinition convertScalarParameter(IScalarParameterDefn iScalarParameterDefn, ParameterGroupDefinition parameterGroupDefinition) {
        ReportElementHandle reportElementHandle = iScalarParameterDefn.getHandle();
        ScalarParameterHandle scalarParameterHandle = null;
        if (reportElementHandle instanceof ScalarParameterHandle) {
            scalarParameterHandle = (ScalarParameterHandle)reportElementHandle;
        }
        long l = scalarParameterHandle != null ? scalarParameterHandle.getID() : 0L;
        String string = iScalarParameterDefn.getName();
        String string2 = scalarParameterHandle == null ? "" : scalarParameterHandle.getPattern();
        String string3 = iScalarParameterDefn.getDisplayFormat();
        String string4 = iScalarParameterDefn.getDisplayName();
        String string5 = iScalarParameterDefn.getHelpText();
        String string6 = iScalarParameterDefn.getPromptText();
        int n = iScalarParameterDefn.getDataType();
        int n2 = iScalarParameterDefn.getControlType();
        boolean bl = iScalarParameterDefn.isHidden();
        boolean bl2 = iScalarParameterDefn.allowNull();
        boolean bl3 = iScalarParameterDefn.allowBlank();
        boolean bl4 = scalarParameterHandle == null ? false : scalarParameterHandle.isMustMatch();
        boolean bl5 = iScalarParameterDefn.isValueConcealed();
        ParameterDefinition parameterDefinition = new ParameterDefinition(l, string, string2, string3, string4, string5, string6, n, n2, bl, bl2, bl3, bl4, bl5, parameterGroupDefinition, null);
        return parameterDefinition;
    }

    private static Collection convertEngineParameterSelectionChoice(Collection collection) {
        if (collection == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ParameterSelectionChoice> arrayList = new ArrayList<ParameterSelectionChoice>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IParameterSelectionChoice iParameterSelectionChoice = (IParameterSelectionChoice)iterator.next();
            ParameterSelectionChoice parameterSelectionChoice = new ParameterSelectionChoice(iParameterSelectionChoice.getLabel(), iParameterSelectionChoice.getValue());
            arrayList.add(parameterSelectionChoice);
        }
        return arrayList;
    }

    private Map getModuleOptions(InputOptions inputOptions) {
        ViewerAttributeBean viewerAttributeBean = this.getViewerAttrBean(inputOptions);
        if (viewerAttributeBean != null) {
            return viewerAttributeBean.getModuleOptions();
        }
        return null;
    }

    private ViewerAttributeBean getViewerAttrBean(InputOptions inputOptions) {
        HttpServletRequest httpServletRequest;
        if (inputOptions != null && (httpServletRequest = (HttpServletRequest)inputOptions.getOption("request")) != null) {
            return (ViewerAttributeBean)httpServletRequest.getAttribute("attributeBean");
        }
        return null;
    }

    static {
        $assertionsDisabled = !BirtViewerReportService.class.desiredAssertionStatus();
    }
}

