/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.render.DeferredCache;

public final class WrappedInstruction
implements Comparable {
    private final DeferredCache dc;
    private final int iInstruction;
    private ArrayList alEvents = null;
    private PrimitiveRenderEvent pre = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WrappedInstruction(DeferredCache dc, ArrayList alEvents, int iInstruction) {
        this.dc = dc;
        this.alEvents = alEvents;
        this.iInstruction = iInstruction;
    }

    public WrappedInstruction(DeferredCache dc, PrimitiveRenderEvent pre, int iInstruction) {
        this.dc = dc;
        this.pre = pre;
        this.iInstruction = iInstruction;
    }

    public int compareTo(Object o) {
        Bounds bo = null;
        if (this.isModel()) {
            if (o instanceof PrimitiveRenderEvent) {
                try {
                    bo = ((PrimitiveRenderEvent)o).getBounds();
                }
                catch (ChartException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return -1;
                }
            } else if (o instanceof WrappedInstruction) {
                bo = ((WrappedInstruction)o).getBounds();
            }
        } else {
            try {
                bo = this.pre.getBounds();
            }
            catch (ChartException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return 1;
            }
        }
        return this.dc.isTransposed() ? PrimitiveRenderEvent.compareTransposed(this.getBounds(), bo) : PrimitiveRenderEvent.compareRegular(this.getBounds(), bo);
    }

    public final PrimitiveRenderEvent getEvent() {
        return this.pre;
    }

    public final int getInstruction() {
        return this.iInstruction;
    }

    public String toString() {
        return Messages.getString("wrapped.instruction.to.string", new Object[]{super.toString(), new Boolean(this.isModel()), this.getBounds()}, ULocale.getDefault());
    }

    public final Bounds getBounds() {
        if (!this.isModel()) {
            try {
                return this.pre.getBounds();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            Bounds bo = null;
            for (int i = 0; i < this.alEvents.size(); ++i) {
                try {
                    if (i == 0) {
                        bo = ((PrimitiveRenderEvent)this.alEvents.get(i)).getBounds();
                        continue;
                    }
                    ((BoundsImpl)bo).max(((PrimitiveRenderEvent)this.alEvents.get(i)).getBounds());
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return bo;
        }
        return null;
    }

    public boolean isModel() {
        return this.pre == null;
    }

    public ArrayList getModel() {
        return this.alEvents;
    }

    static {
        $assertionsDisabled = !WrappedInstruction.class.desiredAssertionStatus();
    }
}

