/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.impl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ModelFactory;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.component.ChartPreferences;
import org.eclipse.birt.chart.model.util.ModelResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class SerializerImpl
implements Serializer {
    public static final String CHART_START_MARKER = "<!-- Chart Starts Here. -->";
    public static final String CHART_END_MARKER = "<!-- Chart Ends Here. -->";
    private static Serializer sz = null;

    private SerializerImpl() {
    }

    public static final synchronized Serializer instance() {
        if (sz == null) {
            sz = new SerializerImpl();
        }
        return sz;
    }

    public void write(Chart cModel, OutputStream os) throws IOException {
        cModel.clearSections(3);
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = rsChart.createResource(URI.createFileURI((String)"test.chart"));
        rChart.getContents().add((Object)cModel);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rChart.save(os, options);
    }

    public void write(Chart cModel, URI uri) throws IOException {
        cModel.clearSections(3);
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = null;
        rChart = rsChart.createResource(uri);
        rChart.getContents().add((Object)cModel);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rChart.save(options);
    }

    public ByteArrayOutputStream asXml(Chart cModel, boolean bStripHeaders) throws IOException {
        cModel.clearSections(3);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = rsChart.createResource(URI.createFileURI((String)"test.chart"));
        rChart.getContents().add((Object)cModel);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        if (bStripHeaders) {
            options.put("DECLARE_XML", Boolean.FALSE);
        }
        rChart.save((OutputStream)baos, options);
        return baos;
    }

    public void savePreferences(ChartPreferences preferences, OutputStream os) throws IOException {
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = rsChart.createResource(URI.createFileURI((String)"test.chart"));
        rChart.getContents().add((Object)preferences);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rChart.save(os, options);
    }

    public Chart read(InputStream is) throws IOException {
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = rsChart.createResource(URI.createFileURI((String)"test.chart"));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rChart.load(is, options);
        return (Chart)rChart.getContents().get(0);
    }

    private StringBuffer getChartStringFromStream(InputStream is) {
        StringBuffer sbChart = new StringBuffer("");
        try {
            String sTmp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            boolean bChartStarted = false;
            while ((sTmp = reader.readLine()) != null) {
                if (sTmp.startsWith("<?")) {
                    sbChart.append(sTmp);
                    sbChart.append("\n");
                }
                if (sTmp.equals(CHART_START_MARKER)) {
                    bChartStarted = true;
                    continue;
                }
                if (!bChartStarted) continue;
                if (!sTmp.equals(CHART_END_MARKER)) {
                    sbChart.append(sTmp);
                    sbChart.append("\n");
                    continue;
                }
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sbChart.length() > 0) {
            sbChart.deleteCharAt(sbChart.length() - 1);
        }
        return sbChart;
    }

    public Chart read(URI uri) throws IOException {
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = null;
        rChart = rsChart.createResource(uri);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rChart.load(options);
        return (Chart)rChart.getContents().get(0);
    }

    public Chart readEmbedded(URI uri) throws IOException {
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = null;
        StringBuffer sb = null;
        sb = this.getChartStringFromStream(new FileInputStream(uri.toFileString()));
        File fTmp = File.createTempFile("_ChartResource", ".chart");
        FileWriter writer = new FileWriter(fTmp);
        System.out.println(fTmp.getAbsolutePath());
        writer.write(sb.toString());
        writer.flush();
        writer.close();
        URI uriEmbeddedModel = URI.createFileURI((String)fTmp.getAbsolutePath());
        rChart = rsChart.getResource(uriEmbeddedModel, true);
        rChart.load(Collections.EMPTY_MAP);
        if (fTmp.exists()) {
            fTmp.delete();
        }
        return (Chart)rChart.getContents().get(0);
    }

    public Chart fromXml(ByteArrayInputStream byais, boolean bStripHeaders) throws IOException {
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = rsChart.createResource(URI.createFileURI((String)"test.chart"));
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        if (bStripHeaders) {
            options.put("DECLARE_XML", Boolean.FALSE);
        }
        rChart.load((InputStream)byais, options);
        return (Chart)rChart.getContents().get(0);
    }

    public ChartPreferences loadPreferences(InputStream is) throws IOException {
        ResourceSetImpl rsChart = new ResourceSetImpl();
        rsChart.getResourceFactoryRegistry().getExtensionToFactoryMap().put("chart", new ModelResourceFactoryImpl());
        Resource rChart = rsChart.createResource(URI.createFileURI((String)"test.chart"));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        rChart.load(is, options);
        return (ChartPreferences)rChart.getContents().get(0);
    }

    static {
        EPackage.Registry.INSTANCE.put((Object)"http://birt.eclipse.org/ChartModel", (Object)ModelFactory.eINSTANCE);
    }
}

