/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.ComplexValueHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;

public class ColorHandle
extends ComplexValueHandle {
    private static final ColorPropertyType type;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ColorHandle(DesignElementHandle element, MemberRef memberRef) {
        super(element, memberRef);
        if (!$assertionsDisabled && !(memberRef.getMemberDefn().getType() instanceof ColorPropertyType)) {
            throw new AssertionError();
        }
    }

    public ColorHandle(DesignElementHandle element, ElementPropertyDefn thePropDefn) {
        super(element, thePropDefn);
        if (!$assertionsDisabled && !(thePropDefn.getType() instanceof ColorPropertyType)) {
            throw new AssertionError();
        }
    }

    public int getRGB() {
        return type.toInteger(this.getModule(), this.getValue());
    }

    public void setRGB(int rgbValue) throws SemanticException {
        this.setValue(new Integer(rgbValue));
    }

    public String getCssValue() {
        return type.toCSSCompatibleColor(this.getModule(), this.getValue());
    }

    public List getColors() {
        List retList = this.getCSSColors();
        List colors = this.getModule().getListProperty(this.getModule(), "colorPalette");
        if (colors == null) {
            return retList;
        }
        for (int i = 0; i < colors.size(); ++i) {
            CustomColor customColor = (CustomColor)colors.get(i);
            retList.add(customColor.getDisplayName(this.getModule()));
        }
        return retList;
    }

    public List getCSSColors() {
        ArrayList<String> retList = new ArrayList<String>();
        IChoice[] colors = type.getChoices().getChoices();
        for (int i = 0; i < colors.length; ++i) {
            retList.add(colors[i].getDisplayName());
        }
        return retList;
    }

    static {
        $assertionsDisabled = !ColorHandle.class.desiredAssertionStatus();
        type = (ColorPropertyType)MetaDataDictionary.getInstance().getPropertyType(4);
    }
}

