/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.MemberIterator;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.ValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class StructureHandle
extends ValueHandle {
    protected CachedMemberRef structRef;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StructureHandle(DesignElementHandle element, MemberRef ref) {
        super(element);
        this.structRef = new CachedMemberRef(ref);
        if (!this.structRef.checkOrCacheStructure(this.getModule(), this.getElement())) {
            throw new RuntimeException("The structure is floating, and its handle is invalid!");
        }
    }

    public StructureHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle.getElementHandle());
        this.structRef = new CachedMemberRef(new CachedMemberRef(valueHandle.getReference(), index));
        if (!this.structRef.checkOrCacheStructure(this.getModule(), this.getElement())) {
            throw new RuntimeException("The structure is floating, and its handle is invalid!");
        }
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.structRef.getPropDefn();
    }

    public IStructure getStructure() {
        return this.structRef.getStructure(this.getModule(), this.getElement());
    }

    public Object getProperty(String memberName) {
        MemberHandle handle = this.getMember(memberName);
        if (handle == null) {
            return null;
        }
        return handle.getValue();
    }

    protected String getStringProperty(String memberName) {
        MemberHandle handle = this.getMember(memberName);
        if (handle == null) {
            return null;
        }
        return handle.getStringValue();
    }

    public void setProperty(String memberName, Object value) throws SemanticException {
        MemberHandle memberHandle = this.getMember(memberName);
        if (memberHandle == null) {
            throw new PropertyNameException(this.getElement(), this.getStructure(), memberName);
        }
        memberHandle.setValue(value);
    }

    protected final void setPropertySilently(String memberName, Object value) {
        block2: {
            try {
                this.setProperty(memberName, value);
            }
            catch (SemanticException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public IStructureDefn getDefn() {
        return this.structRef.getStructDefn();
    }

    public MemberHandle getMember(String memberName) {
        StructPropertyDefn memberDefn = (StructPropertyDefn)this.getDefn().getMember(memberName);
        if (memberDefn == null) {
            return null;
        }
        return new MemberHandle(this, memberDefn);
    }

    public Iterator iterator() {
        return new MemberIterator(this);
    }

    public MemberRef getReference() {
        return this.structRef;
    }

    public void drop() throws PropertyValueException {
        CachedMemberRef listRef = null;
        MemberRef ref = this.getReference();
        ElementPropertyDefn propDefn = (ElementPropertyDefn)this.getPropertyDefn();
        if (propDefn.isList()) {
            if (ref.getDepth() == 1) {
                listRef = new CachedMemberRef(propDefn);
            } else if (ref.getDepth() == 2) {
                listRef = new CachedMemberRef(propDefn);
                listRef = new CachedMemberRef(listRef, ref.getIndex(), (StructPropertyDefn)ref.getMemberDefn());
            }
        } else {
            if (!$assertionsDisabled && ref.getDepth() != 1) {
                throw new AssertionError();
            }
            listRef = new CachedMemberRef(propDefn, (StructPropertyDefn)ref.getMemberDefn());
        }
        PropertyCommand cmd = new PropertyCommand(this.getModule(), this.getElement());
        cmd.removeItem((MemberRef)listRef, this.getStructure());
    }

    public String getExternalizedValue(String textIDProp, String textProp) {
        return ModelUtil.getExternalizedValue(this.getElement(), textIDProp, textProp, ThreadResources.getLocale());
    }

    public boolean isDesignTime() {
        return this.getStructure().isDesignTime();
    }

    public void setDesignTime(boolean isDesignTime) throws SemanticException {
        MemberHandle memberHandle = this.getMember("isDesignTime");
        if (memberHandle != null) {
            memberHandle.setValue(isDesignTime);
        }
    }

    static {
        $assertionsDisabled = !StructureHandle.class.desiredAssertionStatus();
    }
}

