/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.metadata;

import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class PropertyValueException
extends SemanticException {
    private static final long serialVersionUID = 6453952392044174297L;
    public static final String DESIGN_EXCEPTION_INVALID_VALUE = "Error.PropertyValueException.INVALID_VALUE";
    public static final String DESIGN_EXCEPTION_NEGATIVE_VALUE = "Error.PropertyValueException.NEGATIVE_VALUE";
    public static final String DESIGN_EXCEPTION_NON_POSITIVE_VALUE = "Error.PropertyValueException.NON_POSITIVE_VALUE";
    public static final String DESIGN_EXCEPTION_CHOICE_NOT_FOUND = "Error.PropertyValueException.CHOICE_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_NOT_LIST_TYPE = "Error.PropertyValueException.NOT_LIST_TYPE";
    public static final String DESIGN_EXCEPTION_ITEM_NOT_FOUND = "Error.PropertyValueException.ITEM_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_WRONG_ITEM_TYPE = "Error.PropertyValueException.WRONG_ITEM_TYPE";
    public static final String DESIGN_EXCEPTION_WRONG_ELEMENT_TYPE = "Error.PropertyValueException.WRONG_ELEMENT_TYPE";
    public static final String DESIGN_EXCEPTION_VALUE_EXISTS = "Error.PropertyValueException.VALUE_EXISTS";
    public static final String DESIGN_EXCEPTION_VALUE_REQUIRED = "Error.PropertyValueException.VALUE_REQUIRED";
    public static final String DESIGN_EXCEPTION_VALUE_LOCKED = "Error.PropertyValueException.VALUE_LOCKED";
    public static final String DESIGN_EXCEPTION_UNIT_NOT_ALLOWED = "Error.PropertyValueException.UNIT_NOT_ALLOWED";
    public static final String DESIGN_EXCEPTION_CHOICE_NOT_ALLOWED = "Error.PropertyValueException.CHOICE_NOT_ALLOWED";
    public static final String DESIGN_EXCEPTION_EXTENSION_SETTING_FORBIDDEN = "Error.PropertyValueException.EXTENSION_SETTING_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_PROPERTY_CHANGE_FORBIDDEN = "Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_DOT_FORBIDDEN = "Error.PropertyValueException.DOT_FORBIDDEN";
    protected Object invalidValue = null;
    protected String propertyName = null;
    protected String memberName = null;
    protected String propertyTypeName = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyValueException(Object value, String errCode, int type) {
        super(null, errCode);
        this.invalidValue = value;
        this.propertyTypeName = MetaDataDictionary.getInstance().getPropertyType(type).getName();
    }

    public PropertyValueException(DesignElement obj, String propName, Object value, String errCode) {
        super(obj, errCode);
        this.propertyName = propName;
        this.invalidValue = value;
        ElementPropertyDefn propDefn = this.element.getPropertyDefn(this.propertyName);
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.propertyTypeName = propDefn.getType().getName();
    }

    public PropertyValueException(DesignElement obj, IPropertyDefn propDefn, Object value, String errCode) {
        super(obj, errCode);
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.invalidValue = value;
        this.propertyName = propDefn.getName();
        this.propertyTypeName = ((PropertyDefn)propDefn).getType().getName();
    }

    public PropertyValueException(DesignElement obj, IPropertyDefn propDefn, IPropertyDefn memberDefn, Object value, String errCode) {
        super(obj, errCode);
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        this.invalidValue = value;
        this.propertyName = propDefn.getName();
        this.memberName = memberDefn.getName();
        this.propertyTypeName = ((PropertyDefn)propDefn).getType().getName();
    }

    public PropertyValueException(Object value, String errCode) {
        super(null, errCode);
        this.invalidValue = value;
    }

    public void setElement(DesignElement obj) {
        this.element = obj;
    }

    public void setPropertyName(String propName) {
        this.propertyName = propName;
    }

    public Object getInvalidValue() {
        return this.invalidValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getLocalizedMessage() {
        String value = "";
        if (this.invalidValue != null) {
            value = this.invalidValue.toString();
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_INVALID_VALUE) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{value, this.propertyTypeName});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_NEGATIVE_VALUE || this.sResourceKey == DESIGN_EXCEPTION_NON_POSITIVE_VALUE) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{value, this.propertyName});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_CHOICE_NOT_FOUND || this.sResourceKey == DESIGN_EXCEPTION_VALUE_EXISTS || this.sResourceKey == DESIGN_EXCEPTION_CHOICE_NOT_ALLOWED || this.sResourceKey == DESIGN_EXCEPTION_WRONG_ELEMENT_TYPE) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{value});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_VALUE_REQUIRED || this.sResourceKey == DESIGN_EXCEPTION_VALUE_LOCKED || this.sResourceKey == DESIGN_EXCEPTION_NOT_LIST_TYPE || this.sResourceKey == DESIGN_EXCEPTION_ITEM_NOT_FOUND) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.propertyName});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_WRONG_ITEM_TYPE) {
            PropertyDefn propDefn = this.element.getPropertyDefn(this.propertyName);
            if (this.memberName != null) {
                propDefn = (PropertyDefn)propDefn.getStructDefn().getMember(this.memberName);
            }
            if (!$assertionsDisabled && !(this.invalidValue instanceof IStructure)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && propDefn == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && propDefn.getTypeCode() != 16) {
                throw new AssertionError();
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{((IStructure)this.invalidValue).getStructName(), propDefn.getStructDefn().getName()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_UNIT_NOT_ALLOWED) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{value, this.propertyName});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_EXTENSION_SETTING_FORBIDDEN || this.sResourceKey == DESIGN_EXCEPTION_PROPERTY_CHANGE_FORBIDDEN) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.propertyName, this.element.getName()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_DOT_FORBIDDEN) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{(String)this.invalidValue});
        }
        return ModelMessages.getMessage(this.sResourceKey);
    }

    static {
        $assertionsDisabled = !PropertyValueException.class.desiredAssertionStatus();
    }
}

