/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public abstract class Structure
implements IStructure {
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean equals(Object obj) {
        if (!(obj instanceof Structure)) {
            return false;
        }
        Structure struct = (Structure)obj;
        if (struct.getDefn() != this.getDefn()) {
            return false;
        }
        Iterator iter = this.getDefn().getPropertyIterator();
        while (iter.hasNext()) {
            PropertyDefn defn = (PropertyDefn)iter.next();
            Object value = this.getLocalProperty(null, defn);
            if (!(value == null ? struct.getLocalProperty(null, defn) != null : !value.equals(struct.getLocalProperty(null, defn)))) continue;
            return false;
        }
        return true;
    }

    public final IStructure copy() {
        try {
            return (IStructure)this.clone();
        }
        catch (CloneNotSupportedException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public IStructureDefn getDefn() {
        return MetaDataDictionary.getInstance().getStructure(this.getStructName());
    }

    public IObjectDefn getObjectDefn() {
        return MetaDataDictionary.getInstance().getStructure(this.getStructName());
    }

    public final Object getProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getProperty(module, prop);
    }

    public Object getProperty(Module module, PropertyDefn propDefn) {
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        Object value = this.getLocalProperty(module, propDefn);
        if (value == null) {
            return propDefn.getDefault();
        }
        return value;
    }

    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        if (propDefn.isIntrinsic()) {
            return this.getIntrinsicProperty(propDefn.getName());
        }
        return null;
    }

    public Object getLocalProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        if (prop.isIntrinsic()) {
            return this.getIntrinsicProperty(memberName);
        }
        return null;
    }

    public final void setProperty(String propName, Object value) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(propName);
        if (prop == null) {
            return;
        }
        this.setProperty(prop, value);
    }

    public void setProperty(PropertyDefn prop, Object value) {
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop.getName(), value);
        }
    }

    protected abstract Object getIntrinsicProperty(String var1);

    protected abstract void setIntrinsicProperty(String var1, Object var2);

    public List validate(Module module, DesignElement element) {
        return new ArrayList();
    }

    public StructureHandle getHandle(SimpleValueHandle valueHandle, int index) {
        if (valueHandle == null || valueHandle.getListValue() == null) {
            return null;
        }
        if (index < 0 || index >= valueHandle.getListValue().size()) {
            return null;
        }
        return this.handle(valueHandle, index);
    }

    protected abstract StructureHandle handle(SimpleValueHandle var1, int var2);

    public StructureHandle getHandle(SimpleValueHandle valueHandle) {
        if (valueHandle == null || valueHandle.getListValue() == null) {
            return null;
        }
        int posn = valueHandle.getListValue().indexOf(this);
        if (posn == -1) {
            return null;
        }
        return this.handle(valueHandle, posn);
    }

    public boolean isReferencable() {
        return false;
    }

    public String getReferencableProperty() {
        return null;
    }

    public boolean isDesignTime() {
        return true;
    }

    static {
        $assertionsDisabled = !Structure.class.desiredAssertionStatus();
    }
}

