/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IImageItemModel;

public class ImageItem
extends ReportItem
implements IImageItemModel {
    public ImageItem() {
    }

    public ImageItem(String theName) {
        super(theName);
    }

    public void apply(ElementVisitor visitor) {
        visitor.visitImage(this);
    }

    public String getElementName() {
        return "Image";
    }

    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ImageHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ImageHandle(module, this);
        }
        return (ImageHandle)this.handle;
    }

    public double getImageScale(ReportDesign design) {
        return this.getFloatProperty(design, "scale");
    }

    public String getAltText(ReportDesign design) {
        return this.getStringProperty(design, "altText");
    }

    public String getDisplayLabel(Module module, int level) {
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2) {
            displayLabel = displayLabel + "(";
            String sourceType = this.getStringProperty(module, "source");
            if ("file".equalsIgnoreCase(sourceType) || "url".equalsIgnoreCase(sourceType)) {
                displayLabel = displayLabel + this.limitStringLength(this.getStringProperty(module, "uri"));
            } else if ("embed".equalsIgnoreCase(sourceType)) {
                displayLabel = displayLabel + this.limitStringLength(this.getStringProperty(module, "imageName"));
            } else if ("expr".equalsIgnoreCase(sourceType)) {
                displayLabel = displayLabel + this.limitStringLength(this.getStringProperty(module, "valueExpr"));
            }
            displayLabel = displayLabel + ")";
        }
        return displayLabel;
    }
}

