/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.xml.sax.SAXException;

public class EncryptedPropertyState
extends PropertyState {
    static final /* synthetic */ boolean $assertionsDisabled;

    EncryptedPropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    EncryptedPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element);
        this.propDefn = propDefn;
        this.struct = struct;
    }

    public void end() throws SAXException {
        DesignParserException e;
        String value = this.text.toString();
        PropertyDefn propDefn = null;
        if (this.struct != null) {
            StructureDefn structDefn = (StructureDefn)this.struct.getDefn();
            if (!$assertionsDisabled && structDefn == null) {
                throw new AssertionError();
            }
            propDefn = (StructPropertyDefn)structDefn.getMember(this.name);
        } else {
            propDefn = this.element.getPropertyDefn(this.name);
        }
        if (propDefn == null) {
            e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
            RecoverableError.dealUndefinedProperty(this.handler, e);
            this.valid = false;
            return;
        }
        if (!propDefn.isEncryptable()) {
            e = new DesignParserException(new String[]{propDefn.getName()}, "Error.DesignParserException.PROPERTY_IS_NOT_ENCRYPTABLE");
            this.handler.getErrorHandler().semanticError((Exception)((Object)e));
            this.valid = false;
            return;
        }
        String valueToSet = StringUtil.trimString(value);
        if (null == valueToSet) {
            return;
        }
        IEncryptionHelper helper = MetaDataDictionary.getInstance().getEncryptionHelper();
        valueToSet = helper.decrypt(valueToSet);
        if (this.struct != null) {
            this.doSetMember(propDefn.getName(), (StructPropertyDefn)propDefn, valueToSet);
            return;
        }
        this.doSetProperty(propDefn, valueToSet);
    }

    static {
        $assertionsDisabled = !EncryptedPropertyState.class.desiredAssertionStatus();
    }
}

