/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.extension.oda.OdaDummyProvider;
import org.eclipse.birt.report.model.parser.CompatibleOdaDataSetPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.OdaDataSourceState;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.parser.SimpleDataSetState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OdaDataSetState
extends SimpleDataSetState {
    private static final String OBSOLETE_FLAT_FILE_ID = "org.eclipse.birt.report.data.oda.flatfile.dataSet";
    private static final String NEW_FLAT_FILE_ID = "org.eclipse.datatools.connectivity.oda.flatfile.dataSet";
    private boolean isValidExtensionId = true;
    private ODAProvider provider = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public OdaDataSetState(ModuleParserHandler handler) {
        super(handler);
        this.element = new OdaDataSet();
    }

    public OdaDataSetState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
        this.element = new OdaDataSet();
    }

    public DesignElement getElement() {
        return this.element;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.parseODADataSetExtensionID(attrs, false);
        this.initElement(attrs, true);
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.PROPERTY_TAG == tagValue && (this.handler.isVersion(0) || this.handler.isVersion(1000000))) {
            return new CompatibleOdaDataSetPropertyState(this.handler, this.getElement());
        }
        if (this.isValidExtensionId) {
            return super.startElement(tagName);
        }
        return this.startDummyElement(tagName);
    }

    protected AbstractParseState startDummyElement(String tagName) {
        if ("property".equalsIgnoreCase(tagName) || "xml-property".equalsIgnoreCase(tagName) || "method".equalsIgnoreCase(tagName) || "expression".equalsIgnoreCase(tagName)) {
            return new OdaDataSourceState.DummyPropertyState(this.handler, this.getElement(), (OdaDummyProvider)this.provider);
        }
        return super.startElement(tagName);
    }

    private void parseODADataSetExtensionID(Attributes attrs, boolean extensionNameRequired) {
        String extensionID = this.getAttrib(attrs, "extensionID");
        if (StringUtil.isBlank(extensionID)) {
            if (!extensionNameRequired) {
                return;
            }
            SemanticError e = new SemanticError(this.element, "Error.SemanticError.MISSING_EXTENSION");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
            return;
        }
        if (this.handler.versionNumber < 3000000 && OBSOLETE_FLAT_FILE_ID.equalsIgnoreCase(extensionID)) {
            extensionID = NEW_FLAT_FILE_ID;
        }
        this.setProperty("extensionID", extensionID);
        this.provider = ((OdaDataSet)this.element).getProvider();
        if (this.provider == null) {
            return;
        }
        if (this.provider instanceof OdaDummyProvider) {
            SemanticError e = new SemanticError((DesignElement)this.element, new String[]{extensionID}, "Error.SemanticError.EXTENSION_NOT_FOUND");
            RecoverableError.dealMissingInvalidExtension(this.handler, e);
            this.isValidExtensionId = false;
        }
    }

    public void end() throws SAXException {
        super.end();
        OdaDataSet tmpElement = (OdaDataSet)this.getElement();
        this.doCompatibleDataSetProperty(tmpElement);
        this.mergeResultSetAndResultSetHints(tmpElement);
        TemplateParameterDefinition refTemplateParam = tmpElement.getTemplateParameterElement(this.handler.getModule());
        if (refTemplateParam == null) {
            return;
        }
        OdaDataSet refDefaultElement = (OdaDataSet)refTemplateParam.getDefaultElement();
        this.doCompatibleDataSetProperty(refDefaultElement);
        this.mergeResultSetAndResultSetHints(refDefaultElement);
    }

    private void doCompatibleDataSetProperty(OdaDataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        if (this.handler.versionNumber < 3020200) {
            List dataSetColumns = (List)dataSet.getLocalProperty(this.handler.module, "resultSet");
            Object dataSetHints = dataSet.getLocalProperty(this.handler.module, "resultSetHints");
            if (dataSetHints == null && dataSetColumns != null) {
                dataSet.setProperty("resultSetHints", ModelUtil.copyValue(dataSet.getPropertyDefn("resultSetHints"), dataSetColumns));
            }
        }
    }

    private void mergeResultSetAndResultSetHints(OdaDataSet dataSet) {
        if (this.handler.versionNumber >= 3020600 || this.handler.versionNumber < 3020200) {
            return;
        }
        ArrayList<ResultSetColumn> resultSets = (ArrayList<ResultSetColumn>)dataSet.getLocalProperty(this.handler.module, "resultSet");
        List resultSetHints = (List)dataSet.getLocalProperty(this.handler.module, "resultSetHints");
        if (resultSetHints == null) {
            OdaDataSetState.updateOdaResultSetColumn(resultSets);
            return;
        }
        for (int i = 0; i < resultSetHints.size(); ++i) {
            ResultSetColumn hint = (ResultSetColumn)resultSetHints.get(i);
            ResultSetColumn currentColumn = null;
            if (resultSets != null) {
                currentColumn = OdaDataSetState.findResultSet(resultSets, hint.getColumnName(), hint.getPosition());
            }
            if (currentColumn == null) {
                currentColumn = OdaDataSetState.convertResultSetColumnToOdaResultSetColumn(hint);
                if (resultSets == null) {
                    resultSets = new ArrayList<ResultSetColumn>();
                    dataSet.setProperty("resultSet", resultSets);
                }
                resultSets.add(currentColumn);
                continue;
            }
            String nativeName = currentColumn.getColumnName();
            String columnName = hint.getColumnName();
            currentColumn.setColumnName(columnName);
            ((OdaResultSetColumn)currentColumn).setNativeName(nativeName);
            if (currentColumn.getDataType() == null) {
                currentColumn.setDataType(hint.getDataType());
            }
            if (((OdaResultSetColumn)currentColumn).getNativeDataType() == null) {
                ((OdaResultSetColumn)currentColumn).setNativeDataType(hint.getNativeDataType());
            }
            if (((OdaResultSetColumn)currentColumn).getNativeName() == null) {
                ((OdaResultSetColumn)currentColumn).setNativeName(currentColumn.getColumnName());
            }
            if (currentColumn.getColumnName() != null) continue;
            currentColumn.setColumnName(((OdaResultSetColumn)currentColumn).getNativeName());
        }
    }

    private static OdaResultSetColumn findResultSet(List resultSets, String columnName, Integer pos) {
        for (int i = 0; i < resultSets.size(); ++i) {
            OdaResultSetColumn setColumn = (OdaResultSetColumn)resultSets.get(i);
            if ((pos == null || !pos.equals(setColumn.getPosition())) && (columnName == null || !columnName.equals(setColumn.getColumnName()))) continue;
            return setColumn;
        }
        return null;
    }

    private static OdaResultSetColumn convertResultSetColumnToOdaResultSetColumn(ResultSetColumn oldColumn) {
        if (!$assertionsDisabled && oldColumn == null) {
            throw new AssertionError();
        }
        OdaResultSetColumn newColumn = StructureFactory.createOdaResultSetColumn();
        newColumn.setColumnName(oldColumn.getColumnName());
        newColumn.setDataType(oldColumn.getDataType());
        newColumn.setNativeDataType(oldColumn.getNativeDataType());
        newColumn.setNativeName(oldColumn.getColumnName());
        newColumn.setPosition(oldColumn.getPosition());
        return newColumn;
    }

    private static void updateOdaResultSetColumn(List resultSets) {
        if (resultSets == null) {
            return;
        }
        for (int i = 0; i < resultSets.size(); ++i) {
            OdaResultSetColumn newColumn = (OdaResultSetColumn)resultSets.get(i);
            newColumn.setNativeName(newColumn.getColumnName());
        }
    }

    static {
        $assertionsDisabled = !OdaDataSetState.class.desiredAssertionStatus();
    }
}

