/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveReader;
import org.eclipse.birt.core.archive.FolderArchiveWriter;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class FolderArchive
implements IDocArchiveWriter,
IDocArchiveReader {
    private String folderName;
    private FolderArchiveReader reader;
    private FolderArchiveWriter writer;
    private boolean isOpen = false;
    private LinkedList openStreams = new LinkedList();

    public FolderArchive(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException("The folder name is null or empty string.");
        }
        File fd = new File(folderName);
        this.folderName = folderName = fd.getCanonicalPath();
        this.reader = new FolderArchiveReader(folderName);
        this.writer = new FolderArchiveWriter(folderName);
        this.initialize();
    }

    public void initialize() throws IOException {
        if (!this.isOpen) {
            this.writer.initialize();
            this.reader.open();
            this.isOpen = true;
        }
    }

    public String getName() {
        return this.folderName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        RAOutputStream raOutputStream = this.writer.createRandomAccessStream(relativePath);
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.add(raOutputStream);
        }
        return raOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        RAOutputStream raOutputStream = this.writer.openRandomAccessStream(relativePath);
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.add(raOutputStream);
        }
        return raOutputStream;
    }

    public boolean dropStream(String relativePath) {
        return this.writer.dropStream(relativePath);
    }

    public boolean exists(String relativePath) {
        return this.writer.exists(relativePath);
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
        this.writer.setStreamSorter(streamSorter);
    }

    public void finish() throws IOException {
        if (this.isOpen) {
            this.closeAllStream();
            this.writer.finish();
            this.reader.close();
            this.isOpen = false;
        }
    }

    public void open() throws IOException {
        this.initialize();
    }

    public RAInputStream getStream(String relativePath) throws IOException {
        return this.reader.getStream(relativePath);
    }

    public List listStreams(String relativeStoragePath) throws IOException {
        return this.reader.listStreams(relativeStoragePath);
    }

    public List listAllStreams() throws IOException {
        return this.reader.listAllStreams();
    }

    public void close() throws IOException {
        this.finish();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        IOException ioex = null;
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            Iterator iter = this.openStreams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.flush();
                }
                catch (IOException ex) {
                    ioex = ex;
                }
            }
        }
        if (ioex != null) {
            throw ioex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllStream() {
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            Iterator iter = this.openStreams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
            this.openStreams.clear();
        }
    }

    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, stream + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }
}

