/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.archive.compound.NameEntry;

class NameTable
implements ArchiveConstants {
    protected ArrayList slots;
    protected AllocEntry index;
    protected ArchiveFileV2 af;
    protected final int BLOCK_SIZE;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NameTable(ArchiveFileV2 af) throws IOException {
        this.af = af;
        this.BLOCK_SIZE = af.BLOCK_SIZE;
        this.slots = new ArrayList();
        this.index = af.allocTbl.loadEntry(2);
    }

    static NameTable loadTable(ArchiveFileV2 af) throws IOException {
        NameTable table = new NameTable(af);
        table.refresh();
        return table;
    }

    static NameTable createTable(ArchiveFileV2 af) throws IOException {
        NameTable table = new NameTable(af);
        return table;
    }

    synchronized void refresh() throws IOException {
        this.index.refresh(this.af.allocTbl);
        int maxSlots = this.index.getTotalBlocks() * this.BLOCK_SIZE / 128;
        int lastSlot = this.slots.size();
        while (lastSlot < maxSlots) {
            NameEntry entry = new NameEntry(lastSlot);
            entry.read(this);
            int usedSlots = entry.getUsedSlots();
            if (usedSlots == -1) break;
            if (usedSlots == 0) {
                usedSlots = 1;
            }
            lastSlot += usedSlots;
            this.slots.add(entry);
            for (int i = 1; i < usedSlots; ++i) {
                this.slots.add(null);
            }
        }
        if (!$assertionsDisabled && this.slots.size() != lastSlot) {
            throw new AssertionError();
        }
    }

    synchronized void flush() throws IOException {
        this.ensureSlots(this.slots.size() + 1);
        Iterator iter = this.slots.iterator();
        while (iter.hasNext()) {
            NameEntry entry = (NameEntry)iter.next();
            if (entry == null) continue;
            entry.write(this);
        }
        NameEntry lastEntry = new NameEntry(this.slots.size());
        lastEntry.setUsedSlots(-1);
        lastEntry.write(this);
    }

    synchronized void removeEntry(NameEntry entry) throws IOException {
        int slotId = entry.getSlotID();
        int usedSlots = entry.getUsedSlots();
        for (int i = slotId; i < usedSlots; ++i) {
            this.slots.set(i, new NameEntry(i));
        }
    }

    synchronized NameEntry createEntry(String name) throws IOException {
        int lastSlot = this.slots.size();
        NameEntry entry = new NameEntry(lastSlot, name);
        int usedSlots = entry.getUsedSlots();
        this.slots.add(entry);
        for (int i = 1; i < usedSlots; ++i) {
            this.slots.add(null);
        }
        return entry;
    }

    synchronized Collection listEntries() {
        ArrayList<NameEntry> entries = new ArrayList<NameEntry>();
        Iterator iter = this.slots.iterator();
        while (iter.hasNext()) {
            NameEntry entry = (NameEntry)iter.next();
            if (entry == null || entry.getUsedSlots() == 0) continue;
            entries.add(entry);
        }
        return entries;
    }

    private void ensureSlots(int slotSize) throws IOException {
        long offset = (long)(slotSize + 1) * 128L;
        int blockCount = (int)((offset + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE);
        for (int totalBlock = this.index.getTotalBlocks(); blockCount > totalBlock; ++totalBlock) {
            int freeBlock = this.af.allocTbl.getFreeBlock();
            this.index.appendBlock(freeBlock);
        }
    }

    void readSlot(int slotId, byte[] b, int off) throws IOException {
        long offset = (long)slotId * 128L;
        int blkId = (int)(offset / (long)this.BLOCK_SIZE);
        int blkOff = (int)(offset % (long)this.BLOCK_SIZE);
        int phyBlk = this.index.getBlock(blkId);
        this.af.read(phyBlk, blkOff, b, off, 128);
    }

    void writeSlot(int slotId, byte[] b, int off) throws IOException {
        long offset = (long)slotId * 128L;
        int blkId = (int)(offset / (long)this.BLOCK_SIZE);
        int blkOff = (int)(offset % (long)this.BLOCK_SIZE);
        int phyBlk = this.index.getBlock(blkId);
        int size = b.length - off;
        if (size > 128) {
            size = 128;
        }
        this.af.write(phyBlk, blkOff, b, off, size);
    }

    void debug_dump() {
        int i;
        System.out.println("NAME TABLE:");
        for (i = 0; i < this.index.getTotalBlocks(); ++i) {
            System.out.print(this.index.getBlock(i) + ",");
        }
        System.out.println();
        for (i = 0; i < this.slots.size(); ++i) {
            NameEntry entry = (NameEntry)this.slots.get(i);
            if (entry == null) continue;
            System.out.print(entry.getSlotID() + ",");
            System.out.print(entry.getUsedSlots() + ",");
            if (entry.getUsedSlots() > 0) {
                System.out.print(entry.getLength() + ",");
                System.out.print(entry.getName() + ",");
                System.out.print(entry.getBlock());
            }
            System.out.println();
        }
    }

    static {
        $assertionsDisabled = !NameTable.class.desiredAssertionStatus();
    }
}

