/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;

public class PlatformServletContext
implements IPlatformContext {
    protected static Logger log;
    private static final String RESOURCE_BASE = "/WEB-INF/platform/";
    private ServletContext context = null;
    private String platform;
    protected PlatformConfig platformConfig;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PlatformServletContext(ServletContext context, String urlLeadingString) {
        this.context = context;
    }

    public PlatformServletContext(ServletContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlatform() {
        if (this.platform == null) {
            PlatformServletContext platformServletContext = this;
            synchronized (platformServletContext) {
                if (this.platform == null) {
                    this.deploy();
                }
            }
        }
        return this.platform;
    }

    private void deploy() {
        if (!$assertionsDisabled && this.platform != null) {
            throw new AssertionError();
        }
        this.platform = this.context.getRealPath(RESOURCE_BASE);
        if (this.platform == null) {
            File contextTemp = (File)this.context.getAttribute("javax.servlet.context.tempdir");
            File platformFolder = new File(contextTemp, "platform");
            platformFolder.mkdir();
            this.copyResources(RESOURCE_BASE, platformFolder.getAbsolutePath());
            this.platform = platformFolder.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copyResources(String resourcePath, String platform) {
        Set paths = this.context.getResourcePaths(resourcePath);
        if (paths != null) {
            Iterator it = paths.iterator();
            while (it.hasNext()) {
                Exception exin2222;
                Object var12_12;
                OutputStream os;
                InputStream is;
                block20: {
                    block19: {
                        String path = (String)it.next();
                        File newFile = new File(platform, path.substring(RESOURCE_BASE.length()));
                        if (path.endsWith("/")) {
                            newFile.mkdir();
                            this.copyResources(path, platform);
                            continue;
                        }
                        is = null;
                        os = null;
                        if (!newFile.createNewFile()) break block19;
                        is = this.context.getResourceAsStream(path);
                        os = new FileOutputStream(newFile);
                        byte[] buffer = new byte[8192];
                        int bytesRead = is.read(buffer);
                        while (bytesRead != -1) {
                            os.write(buffer, 0, bytesRead);
                            bytesRead = is.read(buffer);
                        }
                        is.close();
                        os.close();
                    }
                    var12_12 = null;
                    if (is == null) break block20;
                    try {
                        is.close();
                    }
                    catch (Exception exin2222) {
                        log.log(Level.WARNING, "Error closing resource stream.", exin2222);
                    }
                    is = null;
                }
                if (os == null) continue;
                try {
                    os.close();
                }
                catch (Exception exout) {
                    log.log(Level.WARNING, "Error closing file output stream.", exout);
                }
                os = null;
                {
                    continue;
                    catch (IOException e) {
                        log.log(Level.WARNING, "Error copying resources {0} to platform.", e);
                        var12_12 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exin2222) {
                                log.log(Level.WARNING, "Error closing resource stream.", exin2222);
                            }
                            is = null;
                        }
                        if (os == null) continue;
                        try {
                            os.close();
                        }
                        catch (Exception exout) {
                            log.log(Level.WARNING, "Error closing file output stream.", exout);
                        }
                        os = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exin2222) {
                            log.log(Level.WARNING, "Error closing resource stream.", exin2222);
                        }
                        is = null;
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception exout) {
                            log.log(Level.WARNING, "Error closing file output stream.", exout);
                        }
                        os = null;
                    }
                    throw throwable;
                }
            }
        }
    }

    static {
        $assertionsDisabled = !PlatformServletContext.class.desiredAssertionStatus();
        log = Logger.getLogger(PlatformServletContext.class.getName());
    }
}

