/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;

class AllocTable
implements ArchiveConstants {
    private static final int BLOCK_COUNT_INCREASE = 32;
    private static final int LAST_BLOCK = -1;
    protected ArchiveFileV2 af;
    final int BLOCK_SIZE;
    final int INDEX_PER_BLOCK;
    protected int[] allocBlocks;
    protected int totalAllocBlocks;
    protected int[] freeBlocks;
    protected int totalFreeBlocks;
    protected HashMap entries = new HashMap();

    AllocTable(ArchiveFileV2 af) {
        this.af = af;
        this.BLOCK_SIZE = af.BLOCK_SIZE;
        this.INDEX_PER_BLOCK = this.BLOCK_SIZE / 4;
        this.allocBlocks = new int[32];
        this.allocBlocks[0] = 1;
        this.totalAllocBlocks = 1;
        this.freeBlocks = new int[32];
        this.totalFreeBlocks = 0;
        this.entries.put(new Integer(2), new AllocEntry(2));
    }

    static AllocTable createTable(ArchiveFileV2 af) throws IOException {
        AllocTable table = new AllocTable(af);
        return table;
    }

    static AllocTable loadTable(ArchiveFileV2 af) throws IOException {
        AllocTable table = new AllocTable(af);
        table.refresh();
        return table;
    }

    synchronized void flush() throws IOException {
        Iterator iter = this.entries.values().iterator();
        while (iter.hasNext()) {
            AllocEntry entry = (AllocEntry)iter.next();
            entry.flush(this);
        }
        if (this.totalFreeBlocks != 0) {
            for (int i = 1; i < this.totalFreeBlocks; ++i) {
                this.writeFATInt(this.freeBlocks[i - 1] * 4, this.freeBlocks[i]);
            }
            this.writeFATInt(this.freeBlocks[this.totalFreeBlocks - 1] * 4, -1);
        } else {
            this.writeFATInt(0L, -1);
        }
        for (int i = 1; i < this.totalAllocBlocks; ++i) {
            this.writeFATInt(this.allocBlocks[i - 1] * 4, this.allocBlocks[i]);
        }
        this.writeFATInt(this.allocBlocks[this.totalAllocBlocks - 1] * 4, -1);
    }

    synchronized void refresh() throws IOException {
        int lastBlockId = this.allocBlocks[this.totalAllocBlocks - 1];
        int blockId = this.readFATInt(lastBlockId * 4);
        while (blockId != -1) {
            this.ensureFATBlocks(this.totalAllocBlocks + 1);
            this.allocBlocks[this.totalAllocBlocks] = blockId;
            ++this.totalAllocBlocks;
            blockId = this.readFATInt(blockId * 4);
        }
        Iterator iter = this.entries.values().iterator();
        while (iter.hasNext()) {
            AllocEntry entry = (AllocEntry)iter.next();
            entry.refresh(this);
        }
    }

    synchronized int getFreeBlock() throws IOException {
        if (this.totalFreeBlocks > 0) {
            int freeBlockId = this.freeBlocks[this.totalFreeBlocks - 1];
            --this.totalFreeBlocks;
            return freeBlockId;
        }
        int freeBlockId = this.af.allocateBlock();
        if (freeBlockId % this.INDEX_PER_BLOCK == 0) {
            freeBlockId = this.af.allocateBlock();
        }
        return freeBlockId;
    }

    synchronized AllocEntry createEntry() throws IOException {
        int blockId = this.getFreeBlock();
        AllocEntry entry = new AllocEntry(blockId);
        this.entries.put(new Integer(blockId), entry);
        return entry;
    }

    synchronized AllocEntry loadEntry(int blockId) throws IOException {
        AllocEntry entry = (AllocEntry)this.entries.get(new Integer(blockId));
        if (entry == null) {
            entry = new AllocEntry(blockId);
            entry.refresh(this);
            this.entries.put(new Integer(blockId), entry);
        }
        return entry;
    }

    synchronized void removeEntry(AllocEntry entry) throws IOException {
        int totalBlocks = entry.getTotalBlocks();
        this.ensureFreeBlocks(this.totalFreeBlocks + totalBlocks);
        for (int i = 0; i < totalBlocks; ++i) {
            int freeBlock;
            this.freeBlocks[this.totalFreeBlocks] = freeBlock = entry.getBlock(i);
            ++this.totalFreeBlocks;
        }
        this.entries.remove(new Integer(entry.getFirstBlock()));
    }

    int readFATInt(long offset) throws IOException {
        if (offset > (long)this.totalAllocBlocks * (long)this.BLOCK_SIZE) {
            throw new EOFException();
        }
        int blockId = (int)(offset / (long)this.BLOCK_SIZE);
        int off = (int)(offset % (long)this.BLOCK_SIZE);
        int phyBlockId = this.getFATBlock(blockId);
        byte[] b = new byte[4];
        this.af.read(phyBlockId, off, b, 0, 4);
        return ArchiveUtil.bytesToInteger(b);
    }

    void writeFATInt(long offset, int block) throws IOException {
        int blockId = (int)(offset / (long)this.BLOCK_SIZE);
        int off = (int)(offset % (long)this.BLOCK_SIZE);
        if (blockId >= this.totalAllocBlocks) {
            int newTotalBlocks = blockId + 1;
            this.ensureFATBlocks(newTotalBlocks);
            for (int i = this.totalAllocBlocks; i < newTotalBlocks; ++i) {
                this.allocBlocks[this.totalAllocBlocks] = this.INDEX_PER_BLOCK * this.totalAllocBlocks;
                ++this.totalAllocBlocks;
            }
        }
        int phyBlockId = this.getFATBlock(blockId);
        byte[] b = new byte[4];
        ArchiveUtil.integerToBytes(block, b);
        this.af.write(phyBlockId, off, b, 0, 4);
    }

    private void ensureFATBlocks(int size) {
        if (this.allocBlocks.length < size) {
            int length = (size / 32 + 1) * 32;
            int[] blocks = new int[length];
            System.arraycopy(this.allocBlocks, 0, blocks, 0, this.totalAllocBlocks);
            this.allocBlocks = blocks;
        }
    }

    private void ensureFreeBlocks(int size) {
        if (this.freeBlocks.length < size) {
            int length = (size / 32 + 1) * 32;
            int[] blocks = new int[length];
            System.arraycopy(this.freeBlocks, 0, blocks, 0, this.totalFreeBlocks);
            this.freeBlocks = blocks;
        }
    }

    private int getFATBlock(int blockId) throws IOException {
        return this.allocBlocks[blockId];
    }

    void debug_dump() {
        int i;
        System.out.println("ALLOC:");
        for (i = 0; i < this.totalAllocBlocks; ++i) {
            System.out.print(this.allocBlocks[i] + ",");
        }
        System.out.println("FREE:");
        for (i = 0; i < this.totalFreeBlocks; ++i) {
            System.out.print(this.freeBlocks[i] + ",");
        }
        System.out.println();
        Iterator iter = this.entries.values().iterator();
        while (iter.hasNext()) {
            AllocEntry entry = (AllocEntry)iter.next();
            for (int i2 = 0; i2 < entry.getTotalBlocks(); ++i2) {
                System.out.print(entry.getBlock(i2) + ",");
            }
            System.out.println();
        }
    }
}

