/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.NameTable;

class NameEntry
implements ArchiveConstants {
    private int slotId;
    private int usedSlots;
    private long length;
    private int firstBlock;
    private String name;

    NameEntry(int slotId) {
        this.slotId = slotId;
        this.name = null;
        this.usedSlots = 0;
        this.firstBlock = -1;
        this.length = 0L;
    }

    NameEntry(int slotId, String name) {
        this.slotId = slotId;
        this.name = name;
        this.usedSlots = this.caculateUsedSlots(name);
        this.firstBlock = -1;
        this.length = 0L;
    }

    private int caculateUsedSlots(String name) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream(name.length() * 2);
        try {
            DataOutputStream os = new DataOutputStream(buff);
            os.writeUTF(name);
            os.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        int totalSize = buff.size() + 4 + 8 + 4;
        return (totalSize + 128 - 1) / 128;
    }

    void read(NameTable tbl) throws IOException {
        byte[] b = new byte[128];
        tbl.readSlot(this.slotId, b, 0);
        this.usedSlots = ArchiveUtil.bytesToInteger(b);
        if (this.usedSlots <= 0) {
            return;
        }
        if (this.usedSlots > 1) {
            byte[] nb = new byte[128 * this.usedSlots];
            System.arraycopy(b, 0, nb, 0, 128);
            for (int i = 1; i < this.usedSlots; ++i) {
                tbl.readSlot(this.slotId + i, nb, i * 128);
            }
            b = nb;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(b));
        is.skipBytes(4);
        this.length = is.readLong();
        this.firstBlock = is.readInt();
        this.name = is.readUTF();
    }

    void write(NameTable tbl) throws IOException {
        if (this.usedSlots > 0) {
            ByteArrayOutputStream buff = new ByteArrayOutputStream(128 * this.usedSlots);
            DataOutputStream os = new DataOutputStream(buff);
            os.writeInt(this.usedSlots);
            os.writeLong(this.length);
            os.writeInt(this.firstBlock);
            os.writeUTF(this.name);
            byte[] b = buff.toByteArray();
            for (int i = 0; i < this.usedSlots; ++i) {
                tbl.writeSlot(this.slotId + i, b, i * 128);
            }
        } else {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(buff);
            os.writeInt(this.usedSlots);
            os.writeLong(this.length);
            os.writeInt(this.firstBlock);
            os.writeUTF("");
            byte[] b = buff.toByteArray();
            tbl.writeSlot(this.slotId, b, 0);
        }
    }

    int getSlotID() {
        return this.slotId;
    }

    int getUsedSlots() {
        return this.usedSlots;
    }

    void setUsedSlots(int slots) {
        this.usedSlots = slots;
    }

    String getName() {
        return this.name;
    }

    long getLength() {
        return this.length;
    }

    void setLength(long length) {
        this.length = length;
    }

    int getBlock() {
        return this.firstBlock;
    }

    void setBlock(int blockId) {
        this.firstBlock = blockId;
    }
}

