/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.osgi;

import [Ljava.lang.String;;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;

public class OSGILauncher {
    private static Logger logger = Logger.getLogger(OSGILauncher.class.getName());
    private static final String ECLIPSE_STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static String PluginId = "org.eclipse.birt.core";
    private PlatformConfig platformConfig;
    private File platformDirectory;
    private URL osgiFramework;
    private ClassLoader frameworkClassLoader;
    private ClassLoader frameworkContextClassLoader;
    private HashMap properties;
    private Object bundleContext;
    private static final String PROP_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_OSGI_INSTANCE_AREA = "osgi.instance.area";
    private static final String PROP_OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String PROP_ECLIPSE_IGNOREAPP = "eclipse.ignoreApp";
    private static final String PROP_OSGI_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_OSGI_CLEAN = "osgi.clean";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FOLDER = "configuration";
    private static final String INSTANCE_FOLDER = "workspace";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(PlatformConfig config) throws BirtException {
        if (this.frameworkClassLoader != null) {
            logger.log(Level.WARNING, "Framework is already started");
            return;
        }
        this.platformConfig = config;
        IPlatformContext context = config.getPlatformContext();
        if (context == null) {
            throw new BirtException(PluginId, "PlatformContext is not setted - {0}", new Object[]{"PlatformConfig"});
        }
        String root = context.getPlatform();
        this.platformDirectory = new File(root);
        if (!this.platformDirectory.exists() || !this.platformDirectory.isDirectory()) {
            throw new BirtException(PluginId, "Could not start the Framework - {0}" + root, root);
        }
        String path = new File(this.platformDirectory, "plugins").toString();
        if ((path = this.searchFor("org.eclipse.osgi", path)) == null) {
            throw new BirtException(PluginId, "Could not find the Framework - {0}", new Object[]{"org.eclipse.osgi"});
        }
        try {
            this.osgiFramework = new File(path).toURL();
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            this.frameworkClassLoader = new ChildFirstURLClassLoader(new URL[]{this.osgiFramework}, loader);
            try {
                loader.loadClass("org.mozilla.javascript.Context");
                loader.loadClass("org.mozilla.javascript.Scriptable");
                loader.loadClass("org.mozilla.javascript.ScriptableObject");
            }
            catch (Exception ex) {
                // empty catch block
            }
            Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
            this.setupOSGiProperties();
            Method initPropertiesMethod = clazz.getMethod("setInitialProperties", Map.class);
            if (initPropertiesMethod != null) {
                System.setProperty("osgi.framework.useSystemProperties", "false");
                this.properties.put("osgi.framework.useSystemProperties", "false");
                initPropertiesMethod.invoke(null, this.properties);
            } else {
                Iterator iter = this.properties.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    System.setProperty(key, value);
                }
                System.setProperty("osgi.framework.useSystemProperties", "true");
            }
            Method runMethod = clazz.getMethod("startup", String;.class, Runnable.class);
            this.bundleContext = runMethod.invoke(null, new Object[]{new String[0], null});
            this.frameworkContextClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private void setupOSGiProperties() {
        String instanceArea;
        this.properties = new HashMap();
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Iterator<Map.Entry<Object, Object>> it = systemProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (!(key.startsWith("osgi.") || key.startsWith("eclipse.") || key.startsWith("org.osgi."))) {
                    this.properties.put(key, value);
                    continue;
                }
                this.properties.put(key, null);
            }
        }
        File configFolder = new File(this.platformDirectory, CONFIG_FOLDER);
        try {
            HashMap configProps = this.loadConfiguration(configFolder.toURL());
            this.properties.putAll(configProps);
        }
        catch (Exception ex) {
            // empty catch block
        }
        Map osgiConfig = this.platformConfig.getOSGiConfig();
        if (osgiConfig != null) {
            Iterator iter = osgiConfig.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String) || value != null && !(value instanceof String)) continue;
                this.properties.put(key, value);
            }
        }
        this.properties.put(PROP_OSGI_INSTALL_AREA, this.platformDirectory.getAbsolutePath());
        this.properties.put("osgi.framework", this.osgiFramework.toExternalForm());
        String configArea = this.getProperty(this.properties, PROP_OSGI_CONFIGURATION_AREA);
        if (configArea == null) {
            File configDirectory = new File(this.platformDirectory, CONFIG_FOLDER);
            this.properties.put(PROP_OSGI_CONFIGURATION_AREA, configDirectory.getAbsolutePath());
        }
        if ((instanceArea = this.getProperty(this.properties, PROP_OSGI_INSTANCE_AREA)) == null) {
            File workspaceDirectory = new File(this.platformDirectory, INSTANCE_FOLDER);
            if (!workspaceDirectory.exists()) {
                workspaceDirectory.mkdirs();
            }
            this.properties.put(PROP_OSGI_INSTANCE_AREA, workspaceDirectory.getAbsolutePath());
        }
        this.properties.put(PROP_ECLIPSE_IGNOREAPP, "true");
        this.properties.put(PROP_OSGI_NOSHUTDOWN, "true");
        String clean = this.getProperty(this.properties, PROP_OSGI_CLEAN);
        if (clean == null) {
            this.properties.put(PROP_OSGI_CLEAN, "true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap loadConfiguration(URL url) {
        Properties tempProp;
        HashMap<Object, Object> result;
        block11: {
            result = null;
            if (url == null) {
                return result;
            }
            try {
                url = new URL(url, CONFIG_FILE);
            }
            catch (MalformedURLException e) {
                return result;
            }
            tempProp = new Properties();
            try {
                result = new HashMap<Object, Object>();
                InputStream is = null;
                try {
                    is = url.openStream();
                    tempProp.load(is);
                    Object var6_7 = null;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Iterator<Map.Entry<Object, Object>> ti = tempProp.entrySet().iterator();
        while (ti.hasNext()) {
            Map.Entry<Object, Object> entry = ti.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            result.put(key, value);
        }
        return result;
    }

    private String getProperty(Map properties, String name) {
        Object value = properties.get(name);
        if (value instanceof String) {
            String strValue = (String)value;
            if ((strValue = strValue.trim()).length() > 0) {
                return strValue;
            }
        }
        return null;
    }

    public ClassLoader getFrameworkContextClassLoader() {
        return this.frameworkContextClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.platformDirectory == null) {
            logger.log(Level.WARNING, "Shutdown unnecessary. (not deployed)");
            return;
        }
        if (this.frameworkClassLoader == null) {
            logger.log(Level.WARNING, "Framework is already shutdown");
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
                Method method = clazz.getDeclaredMethod("shutdown", null);
                Thread.currentThread().setContextClassLoader(this.frameworkContextClassLoader);
                method.invoke(clazz, (Object[])null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while stopping Framework", e);
                Object var5_6 = null;
                this.frameworkClassLoader = null;
                this.frameworkContextClassLoader = null;
                Thread.currentThread().setContextClassLoader(original);
                return;
            }
            Object var5_5 = null;
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
            throw throwable;
        }
    }

    protected String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(target + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = candidates[i].getName();
        }
        int result = this.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return candidates[result].getAbsolutePath().replace(File.separatorChar, '/') + (candidates[result].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        for (int i = 0; i < candidates.length; ++i) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
                continue;
            }
            if (this.compareVersion(maxVersion, currentVersion) >= 0) continue;
            result = i;
            maxVersion = currentVersion;
        }
        return result;
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    Object getBundle(String symbolicName) {
        if (this.bundleContext == null) {
            return null;
        }
        try {
            Method methodLoadBundle = this.bundleContext.getClass().getMethod("getBundles", new Class[0]);
            Object objects = methodLoadBundle.invoke(this.bundleContext, new Object[0]);
            if (objects instanceof Object[]) {
                Object[] bundles = (Object[])objects;
                for (int i = 0; i < bundles.length; ++i) {
                    Object bundle = bundles[i];
                    Method methodGetSymbolicName = bundle.getClass().getMethod("getSymbolicName", new Class[0]);
                    Object name = methodGetSymbolicName.invoke(bundle, new Object[0]);
                    if (!symbolicName.equals(name)) continue;
                    return bundle;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected class ChildFirstURLClassLoader
    extends URLClassLoader {
        public ChildFirstURLClassLoader(URL[] urls) {
            super(urls);
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        public URL getResource(String name) {
            ClassLoader parent;
            URL resource = this.findResource(name);
            if (resource == null && (parent = this.getParent()) != null) {
                resource = parent.getResource(name);
            }
            return resource;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    ClassLoader parent = this.getParent();
                    clazz = parent != null ? parent.loadClass(name) : ChildFirstURLClassLoader.getSystemClassLoader().loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

