/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.api.DataSetID;

public class DataID {
    protected DataSetID dataSet;
    protected long rowId;

    public DataID(DataSetID dataSet, long rowId) {
        this.dataSet = dataSet;
        this.rowId = rowId;
    }

    public DataSetID getDataSetID() {
        return this.dataSet;
    }

    public long getRowID() {
        return this.rowId;
    }

    public void append(StringBuffer buffer) {
        this.dataSet.append(buffer);
        buffer.append(":");
        buffer.append(this.rowId);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer);
        return buffer.toString();
    }

    public boolean equals(Object a) {
        if (a instanceof DataID) {
            DataID aid = (DataID)a;
            if (this.rowId != aid.rowId) {
                return false;
            }
            return this.dataSet.equals(aid.dataSet);
        }
        return false;
    }

    static DataID parse(String dataId) {
        return DataID.parse(dataId.toCharArray(), 0, dataId.length());
    }

    static DataID parse(char[] buffer, int offset, int length) {
        int ptr;
        for (ptr = offset + length - 1; ptr >= offset && buffer[ptr] != ':'; --ptr) {
        }
        if (ptr >= offset && buffer[ptr] == ':') {
            DataSetID dataSetId;
            String strRowId = new String(buffer, ptr + 1, offset + length - ptr - 1);
            long rowId = Long.parseLong(strRowId);
            if (--ptr >= offset && (dataSetId = DataSetID.parse(buffer, offset, ptr - offset + 1)) != null) {
                return new DataID(dataSetId, rowId);
            }
        }
        return null;
    }
}

