/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class ImageContent
extends AbstractContent
implements IImageContent {
    protected String altText;
    protected String altTextKey;
    protected String helpTextKey;
    protected String extension;
    protected String uri;
    protected int sourceType = -1;
    protected transient byte[] data;
    protected Object imageMap;
    protected String MIMEType;
    protected static final short FIELD_ALTTEXT = 500;
    protected static final short FIELD_ALTTEXTKEY = 501;
    protected static final short FIELD_EXTENSEION = 502;
    protected static final short FIELD_URI = 503;
    protected static final short FIELD_SOURCETYPE = 504;
    protected static final short FIELD_IMAGEMAP = 505;
    protected static final short FIELD_MIMETYPE = 506;
    protected static final short FIELD_DATA = 507;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int getContentType() {
        return 5;
    }

    public ImageContent(ReportContent report) {
        super(report);
    }

    public ImageContent(IContent content) {
        super(content);
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitImage(this, value);
    }

    public String getAltText() {
        if (this.altText == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getAltText();
        }
        return this.altText;
    }

    public String getAltTextKey() {
        if (this.altTextKey == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getAltTextKey();
        }
        return this.altTextKey;
    }

    public void setAltTextKey(String key) {
        this.altTextKey = key;
    }

    public String getHelpText() {
        if (this.helpText == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getHelpText();
        }
        return this.helpText;
    }

    public String getHelpKey() {
        if (this.helpTextKey == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getHelpTextKey();
        }
        return this.helpTextKey;
    }

    public void setHelpKey(String key) {
        this.helpTextKey = key;
    }

    public byte[] getData() {
        if (this.sourceType == 1) {
            String imageName;
            ReportDesignHandle design;
            EmbeddedImage embeddedImage;
            Report reportDesign = this.report.getDesign();
            if (reportDesign != null && (embeddedImage = (design = reportDesign.getReportDesign()).findImage(imageName = this.getImageName())) != null) {
                return embeddedImage.getData(design.getModule());
            }
            return null;
        }
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getURI() {
        if (this.sourceType == 1) {
            return this.getImageName();
        }
        return this.uri;
    }

    public int getImageSource() {
        return this.sourceType;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    private void setImageName(String name) {
        if (!$assertionsDisabled && this.sourceType != 1) {
            throw new AssertionError();
        }
        this.uri = name;
        if (this.uri != null && this.generateBy instanceof ImageItemDesign && this.uri.equals(((ImageItemDesign)this.generateBy).getImageName())) {
            this.uri = null;
        }
        this.data = null;
    }

    private String getImageName() {
        if (!$assertionsDisabled && this.sourceType != 1) {
            throw new AssertionError();
        }
        if (this.uri == null && this.generateBy instanceof ImageItemDesign) {
            return ((ImageItemDesign)this.generateBy).getImageName();
        }
        return this.uri;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setImageSource(int sourceType) {
        this.sourceType = sourceType;
    }

    public void setURI(String uri) {
        if (this.sourceType == 1) {
            this.setImageName(uri);
        } else {
            this.uri = uri;
        }
    }

    public void setImageMap(Object imageMap) {
        this.imageMap = imageMap;
    }

    public Object getImageMap() {
        return this.imageMap;
    }

    public void setMIMEType(String MIMEType) {
        this.MIMEType = MIMEType;
    }

    public String getMIMEType() {
        return this.MIMEType;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.altText != null) {
            IOUtil.writeShort((OutputStream)out, (short)500);
            IOUtil.writeString((DataOutputStream)out, (String)this.altText);
        }
        if (this.altTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)501);
            IOUtil.writeString((DataOutputStream)out, (String)this.altTextKey);
        }
        if (this.extension != null) {
            IOUtil.writeShort((OutputStream)out, (short)502);
            IOUtil.writeString((DataOutputStream)out, (String)this.extension);
        }
        if (this.imageMap != null) {
            IOUtil.writeShort((OutputStream)out, (short)505);
            IOUtil.writeObject((DataOutputStream)out, (Object)this.imageMap);
        }
        if (this.sourceType != -1) {
            IOUtil.writeShort((OutputStream)out, (short)504);
            IOUtil.writeInt((OutputStream)out, (int)this.sourceType);
        }
        switch (this.sourceType) {
            case 0: 
            case 1: 
            case 3: {
                if (this.uri == null) break;
                IOUtil.writeShort((OutputStream)out, (short)503);
                IOUtil.writeString((DataOutputStream)out, (String)this.uri);
                break;
            }
            case 2: {
                if (this.data == null) break;
                IOUtil.writeShort((OutputStream)out, (short)507);
                IOUtil.writeBytes((DataOutputStream)out, (byte[])this.data);
            }
        }
        if (this.MIMEType != null) {
            IOUtil.writeShort((OutputStream)out, (short)506);
            IOUtil.writeString((DataOutputStream)out, (String)this.MIMEType);
        }
    }

    public boolean needSave() {
        return true;
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 500: {
                this.altText = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 501: {
                this.altTextKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 502: {
                this.extension = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 503: {
                this.uri = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 504: {
                this.sourceType = IOUtil.readInt((InputStream)in);
                break;
            }
            case 505: {
                this.imageMap = IOUtil.readObject((DataInputStream)in);
                break;
            }
            case 506: {
                this.MIMEType = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 507: {
                this.data = IOUtil.readBytes((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in);
            }
        }
    }

    static {
        $assertionsDisabled = !ImageContent.class.desiredAssertionStatus();
    }
}

