/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.birt;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractLengthManager;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class BackgroundPositionYManager
extends AbstractLengthManager {
    protected static final StringMap values = new StringMap();
    protected static final StringMap percentValues;

    public String getPropertyName() {
        return "background-position-y";
    }

    public boolean isInheritedProperty() {
        return false;
    }

    public Value getDefaultValue() {
        return CSSValueConstants.PERCENT_0;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                String s = lu.getStringValue().toLowerCase().intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return (Value)v;
            }
        }
        return super.createValue(lu, engine);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value.getCssValueType() == 1 && value.getPrimitiveType() == 21) {
            Value percentage = (Value)percentValues.get(value.getStringValue());
            if (percentage != null) {
                return percentage;
            }
            throw this.createInvalidIdentifierDOMException(value.getStringValue());
        }
        return super.computeValue(elt, engine, idx, value);
    }

    static {
        values.put("top", CSSValueConstants.TOP_VALUE);
        values.put("center", CSSValueConstants.CENTER_VALUE);
        values.put("bottom", CSSValueConstants.BOTTOM_VALUE);
        percentValues = new StringMap();
        percentValues.put("top", CSSValueConstants.PERCENT_0);
        percentValues.put("center", CSSValueConstants.PERCENT_50);
        percentValues.put("bottom", CSSValueConstants.PERCENT_100);
    }
}

