/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractColorManager;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.css.engine.value.css.ColorManager;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class BorderColorManager
extends ColorManager {
    protected static final StringMap values = new StringMap();

    public StringMap getIdentifiers() {
        return values;
    }

    public BorderColorManager(String propertyName) {
        super(propertyName, false, CSSValueConstants.BLACK_RGB_VALUE);
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        if (lu.getLexicalUnitType() == 35 && "transparent".equals(lu.getStringValue())) {
            return CSSValueConstants.TRANSPARENT_VALUE;
        }
        return super.createValue(lu, engine);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value == null) {
            return (Value)elt.getComputedStyle().getProperty(14);
        }
        if (CSSValueConstants.TRANSPARENT_VALUE == value) {
            return value;
        }
        return super.computeValue(elt, engine, idx, value);
    }

    static {
        AbstractColorManager.addColorIndent(values);
        values.put("transparent", CSSValueConstants.TRANSPARENT_VALUE);
    }
}

