/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.MasterPageExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutorUtil;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCTree;

public class ReportExecutor
implements IReportExecutor {
    protected static Logger logger = Logger.getLogger(ReportExecutor.class.getName());
    private ExecutionContext context;
    private ExecutorManager manager;
    private Report report;
    private ReportContent reportContent;
    private long uniqueId;
    int currentItem;

    public ReportExecutor(ExecutionContext context) {
        this.context = context;
        this.report = context.getReport();
        this.manager = new ExecutorManager(this);
        this.uniqueId = 0L;
    }

    public IReportContent execute() {
        this.reportContent = new ReportContent(this.report);
        this.context.setReportContent(this.reportContent);
        TOCTree tocTree = new TOCTree();
        this.reportContent.setTOCTree(tocTree);
        TOCBuilder tocBuilder = new TOCBuilder(tocTree);
        this.context.setTOCBuilder(tocBuilder);
        this.context.getDataEngine().prepare(this.report, this.context.getAppContext());
        this.currentItem = 0;
        return this.reportContent;
    }

    public void close() {
        this.uniqueId = 0L;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemDesign design = this.report.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(null, design);
            return executor;
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.currentItem < this.report.getContentCount();
    }

    public void execute(IContentEmitter emitter) {
        IReportContent report = this.execute();
        emitter.start(report);
        while (this.hasNextChild() && !this.context.isCanceled()) {
            IReportItemExecutor executor = this.getNextChild();
            ReportExecutorUtil.execute(executor, emitter);
        }
        emitter.end(report);
        this.close();
    }

    public ExecutionContext getContext() {
        return this.context;
    }

    public ExecutorManager getManager() {
        return this.manager;
    }

    long generateUniqueID() {
        return this.uniqueId++;
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        return new MasterPageExecutor(this.manager, pageNumber, pageDesign);
    }
}

