/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.IOException;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.emitter.ContentDOMVisitor;
import org.eclipse.birt.report.engine.emitter.DOMBuilderEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IReportContentLoader;
import org.eclipse.birt.report.engine.internal.document.v2.PageHintReaderV2;
import org.eclipse.birt.report.engine.internal.document.v2.ReportContentReaderV2;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.toc.TOCTree;

public class ReportContentLoaderV2
implements IReportContentLoader {
    protected static Logger logger;
    protected ExecutionContext context;
    protected IDataEngine dataEngine;
    protected IContentEmitter emitter;
    protected ReportContentReaderV2 reader;
    protected ReportContentReaderV2 pageReader;
    protected PageHintReaderV2 hintReader;
    protected Report report;
    protected IReportDocument reportDoc;
    protected ReportContent reportContent;
    protected IContent dummyReportContent;
    protected long currentOffset;
    protected Stack resultSets = new Stack();
    protected Stack contents = new Stack();
    protected IContentVisitor outputStartVisitor = new IContentVisitor(){

        public Object visit(IContent content, Object value) {
            return content.accept(this, value);
        }

        public Object visitContent(IContent content, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContent(content);
            return value;
        }

        public Object visitPage(IPageContent page, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startPage(page);
            return value;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContainer(container);
            return value;
        }

        public Object visitTable(ITableContent table, Object value) {
            int colCount = table.getColumnCount();
            for (int i = 0; i < colCount; ++i) {
                IColumn col = table.getColumn(i);
                InstanceID id = col.getInstanceID();
                if (id == null) continue;
                long cid = id.getComponentID();
                ColumnDesign colDesign = (ColumnDesign)ReportContentLoaderV2.this.report.getReportItemByID(cid);
                col.setGenerateBy(colDesign);
            }
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTable(table);
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            this.setupGroupBand(tableBand);
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTableBand(tableBand);
            return value;
        }

        public Object visitRow(IRowContent row, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startRow(row);
            return value;
        }

        public Object visitCell(ICellContent cell, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startCell(cell);
            return value;
        }

        public Object visitText(ITextContent text, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startText(text);
            return value;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            if (label.getGenerateBy() instanceof TemplateDesign) {
                TemplateDesign design = (TemplateDesign)label.getGenerateBy();
                label.setLabelKey(design.getPromptTextKey());
                label.setLabelText(design.getPromptText());
            }
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startLabel(label);
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            if (autoText.getType() == 0) {
                autoText.setText(String.valueOf(ReportContentLoaderV2.this.reportDoc.getPageCount()));
            }
            emitter.startAutoText(autoText);
            return value;
        }

        public Object visitData(IDataContent data, Object value) {
            String valueExpr;
            DataItemDesign design;
            IContentEmitter emitter = (IContentEmitter)value;
            if (data.getGenerateBy() instanceof DataItemDesign && (design = (DataItemDesign)data.getGenerateBy()).getMap() == null && (valueExpr = design.getValue()) != null) {
                Object dataValue = ReportContentLoaderV2.this.context.evaluate(valueExpr);
                data.setValue(dataValue);
            }
            emitter.startData(data);
            return value;
        }

        public Object visitImage(IImageContent image, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startImage(image);
            return value;
        }

        public Object visitForeign(IForeignContent content, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startForeign(content);
            return value;
        }

        public Object visitList(IListContent list, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startList(list);
            return value;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            this.setupGroupBand(listBand);
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListBand(listBand);
            return value;
        }

        protected void setupGroupBand(IBandContent bandContent) {
        }

        public Object visitGroup(IGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startGroup(group);
            return value;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListGroup(group);
            return value;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTableGroup(group);
            return value;
        }
    };
    protected IContentVisitor outputEndVisitor = new IContentVisitor(){

        public Object visit(IContent content, Object value) {
            return content.accept(this, value);
        }

        public Object visitContent(IContent content, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContent(content);
            return value;
        }

        public Object visitPage(IPageContent page, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endPage(page);
            return value;
        }

        public Object visitContainer(IContainerContent container, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContainer(container);
            return value;
        }

        public Object visitTable(ITableContent table, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTable(table);
            return value;
        }

        public Object visitTableBand(ITableBandContent tableBand, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableBand(tableBand);
            return value;
        }

        public Object visitRow(IRowContent row, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endRow(row);
            return value;
        }

        public Object visitCell(ICellContent cell, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endCell(cell);
            return value;
        }

        public Object visitText(ITextContent text, Object value) {
            return value;
        }

        public Object visitLabel(ILabelContent label, Object value) {
            return value;
        }

        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            return value;
        }

        public Object visitData(IDataContent data, Object value) {
            return value;
        }

        public Object visitImage(IImageContent image, Object value) {
            return value;
        }

        public Object visitForeign(IForeignContent content, Object value) {
            return value;
        }

        public Object visitList(IListContent list, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endList(list);
            return value;
        }

        public Object visitListBand(IListBandContent listBand, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListBand(listBand);
            return value;
        }

        public Object visitGroup(IGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endGroup(group);
            return value;
        }

        public Object visitListGroup(IListGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListGroup(group);
            return value;
        }

        public Object visitTableGroup(ITableGroupContent group, Object value) {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableGroup(group);
            return value;
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportContentLoaderV2(ExecutionContext context) {
        this.context = context;
        this.dataEngine = context.getDataEngine();
        this.report = context.getReport();
        this.reportContent = (ReportContent)ContentFactory.createReportContent(this.report);
        context.setReportContent(this.reportContent);
        this.dummyReportContent = new LabelContent(this.reportContent);
        this.dummyReportContent.setStyleClass(this.report.getRootStyleName());
        this.reportDoc = context.getReportDocument();
        this.dataEngine.prepare(this.report, context.getAppContext());
        TOCTree tocTree = (TOCTree)this.reportDoc.getTOCTree(null, null);
        this.reportContent.setTOCTree(tocTree);
    }

    protected void openReaders() {
        try {
            this.reader = new ReportContentReaderV2(this.reportContent, this.reportDoc);
            this.reader.open("/content/content.dat");
            this.pageReader = new ReportContentReaderV2(this.reportContent, this.reportDoc);
            this.pageReader.open("/content/page.dat");
            this.hintReader = new PageHintReaderV2(this.reportDoc.getArchive());
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Failed to open the content reader", ex);
            this.closeReaders();
        }
    }

    protected void closeReaders() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.pageReader != null) {
            this.pageReader.close();
            this.pageReader = null;
        }
        if (this.hintReader != null) {
            this.hintReader.close();
            this.hintReader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPage(long pageNumber, int paginationType, IContentEmitter emitter) {
        boolean bodyOnly = paginationType == 0 || paginationType == 2;
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            this.openReaders();
            this.excutePage(pageNumber, bodyOnly);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to load the page", ex);
            ex.printStackTrace();
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadReportlet(long offset, IContentEmitter emitter) {
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            this.openReaders();
            this.excuteReportlet(offset);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to load the page", ex);
            ex.printStackTrace();
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    protected IPageHint loadPageHint(long pageNumber) {
        try {
            return this.hintReader.getPageHint(pageNumber);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Failed to load page hint " + pageNumber, ex);
            return null;
        }
    }

    private void excutePage(long pageNumber, boolean bodyOnly) {
        IPageHint pageHint = this.loadPageHint(pageNumber);
        if (pageHint == null) {
            return;
        }
        IPageContent pageContent = null;
        if (!bodyOnly) {
            long pageOffset = pageHint.getOffset();
            try {
                pageContent = this.loadPageContent(pageOffset);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can't load the page content " + pageNumber, ex);
            }
            if (pageContent == null) {
                return;
            }
            Object generateBy = pageContent.getGenerateBy();
            if (generateBy instanceof SimpleMasterPageDesign) {
                SimpleMasterPageDesign pageDesign = (SimpleMasterPageDesign)generateBy;
                if (!pageDesign.isShowHeaderOnFirst() && pageNumber == 1L) {
                    pageContent.getHeader().clear();
                }
                if (!pageDesign.isShowFooterOnLast() && pageNumber == this.reportDoc.getPageCount()) {
                    pageContent.getFooter().clear();
                }
            }
            this.emitter.startPage(pageContent);
        }
        for (int i = 0; i < pageHint.getSectionCount(); ++i) {
            PageSection section = pageHint.getSection(i);
            long start = section.startOffset;
            long end = section.endOffset;
            if (start == -1L || end == -1L) continue;
            try {
                this.outputPageRegion(start, end);
                continue;
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Can't load the page content");
            }
        }
        while (!this.contents.isEmpty()) {
            IContent content = (IContent)this.contents.pop();
            this.endContent(content, this.emitter);
        }
        if (!bodyOnly) {
            this.emitter.endPage(pageContent);
        }
    }

    private void excuteReportlet(long offset) {
        try {
            this.reader.setOffset(offset);
            IContent root = this.reader.readContent();
            IContent parent = (IContent)root.getParent();
            if (parent != null) {
                this.outputParent(parent);
            }
            this.initializeContent(root);
            this.startContent(root, this.emitter);
            this.contents.push(root);
            parent = root;
            IContent next = this.reader.readContent();
            while (next != null) {
                if (next.getParent() == parent) {
                    this.initializeContent(next);
                    this.startContent(next, this.emitter);
                    this.contents.push(next);
                    parent = next;
                    next = this.reader.readContent();
                    continue;
                }
                if (parent != root) {
                    this.endContent(parent, this.emitter);
                    this.contents.pop();
                    parent = (IContent)parent.getParent();
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Can't load the page content", ex);
        }
        while (!this.contents.isEmpty()) {
            IContent content = (IContent)this.contents.pop();
            this.endContent(content, this.emitter);
        }
    }

    private void outputPageRegion(long start, long end) throws IOException {
        long offset = start;
        this.reader.setOffset(offset);
        while (offset <= end) {
            IContent parent;
            IContent content = this.reader.readContent();
            while (!this.contents.isEmpty() && (parent = (IContent)this.contents.peek()) != content.getParent()) {
                this.endContent(parent, this.emitter);
                this.contents.pop();
            }
            if (this.contents.isEmpty()) {
                long curOffset = this.reader.getOffset();
                IContent parent2 = (IContent)content.getParent();
                if (parent2 != null) {
                    this.outputParent(parent2);
                }
                this.reader.setOffset(curOffset);
            }
            this.initializeContent(content);
            this.startContent(content, this.emitter);
            this.contents.push(content);
            offset = this.reader.getOffset();
        }
    }

    private void outputParent(IContent content) throws IOException {
        ITableContent table;
        IContent parent = (IContent)content.getParent();
        if (parent != null && parent != this.dummyReportContent) {
            this.outputParent(parent);
        }
        this.initializeContent(content);
        this.startContent(content, this.emitter);
        this.contents.push(content);
        if (content instanceof ITableContent && (table = (ITableContent)content).isHeaderRepeat()) {
            ITableBandContent header = table.getHeader();
            if (header == null) {
                long offset = this.getIndex(table);
                this.reader.setOffset(offset);
                this.reader.readContent();
                IContent headerContent = this.reader.readContent();
                this.loadFullContent(headerContent, this.reader);
                table.getChildren().add(headerContent);
                header = table.getHeader();
            }
            if (header != null) {
                new ContentDOMVisitor().emit(header, this.emitter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPageRange(List pageList, int paginationType, IContentEmitter emitter) {
        boolean bodyOnly = paginationType == 0 || paginationType == 2;
        emitter.start(this.reportContent);
        this.emitter = emitter;
        try {
            this.openReaders();
            for (int m = 0; m < pageList.size(); ++m) {
                long[] ps = (long[])pageList.get(m);
                for (long i = ps[0]; i <= ps[1]; ++i) {
                    this.excutePage(i, bodyOnly);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to load the page", ex);
            ex.printStackTrace();
        }
        finally {
            emitter.end(this.reportContent);
            this.closeReaders();
        }
    }

    protected IPageContent loadPageContent(long offset) throws IOException {
        this.pageReader.setOffset(offset);
        IPageContent pageContent = (IPageContent)this.pageReader.readContent();
        this.initializeContent(pageContent);
        if (pageContent == null) {
            return null;
        }
        SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)pageContent.getGenerateBy();
        if (masterPage.getHeaderCount() > 0 || masterPage.getFooterCount() > 0) {
            int i;
            IContent nextContent = null;
            IContent content = this.pageReader.readContent();
            for (i = 0; i < masterPage.getHeaderCount(); ++i) {
                nextContent = this.loadFullContent(content, this.pageReader);
                pageContent.getHeader().add(content);
                content = nextContent;
            }
            for (i = 0; i < masterPage.getFooterCount(); ++i) {
                nextContent = this.loadFullContent(content, this.pageReader);
                pageContent.getFooter().add(content);
                content = nextContent;
            }
        }
        return pageContent;
    }

    protected IContent loadFullContent(IContent root, ReportContentReaderV2 reader) {
        DOMBuilderEmitter emitter = new DOMBuilderEmitter(root);
        IContent parent = root;
        this.initializeContent(root);
        this.openQuery(root);
        try {
            IContent next = reader.readContent();
            while (next != null) {
                if (next.getParent() == parent) {
                    this.initializeContent(next);
                    this.startContent(next, emitter);
                    parent = next;
                    next = reader.readContent();
                    continue;
                }
                if (parent == root) {
                    this.closeQuery(root);
                    return next;
                }
                this.endContent(parent, emitter);
                parent = (IContent)parent.getParent();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        while (parent != root) {
            this.endContent(parent, emitter);
            parent = (IContent)parent.getParent();
        }
        this.closeQuery(root);
        return null;
    }

    protected void initializeContent(IContent content) {
        long designId;
        InstanceID id;
        content.setReportContent(this.reportContent);
        IElement parent = content.getParent();
        if (parent == null) {
            content.setParent(this.dummyReportContent);
        }
        if ((id = content.getInstanceID()) != null && (designId = id.getComponentID()) != -1L) {
            ReportElementDesign generateBy = this.findReportItem(designId);
            content.setGenerateBy(generateBy);
        }
    }

    protected ReportElementDesign findReportItem(long designId) {
        return this.report.getReportItemByID(designId);
    }

    protected void openQuery(IContent content) {
        InstanceID iid;
        ReportItemDesign design;
        IBaseQueryDefinition query;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign && (query = (design = (ReportItemDesign)generateBy).getQuery()) != null) {
            DataSetID dataSetId;
            DataID dataId;
            InstanceID iid2 = content.getInstanceID();
            if (iid2 != null && (dataId = iid2.getDataID()) != null && (dataSetId = dataId.getDataSetID()) != null) {
                IResultSet rset;
                DataSetID parentSetId = dataSetId.getParentID();
                long parentRowId = dataSetId.getRowID();
                if (parentSetId != null && parentRowId != -1L && !this.resultSets.isEmpty() && (rset = (IResultSet)this.resultSets.peek()) != null && parentRowId != rset.getCurrentPosition()) {
                    rset.skipTo(parentRowId);
                }
            }
            IResultSet rset = this.dataEngine.execute(query);
            this.resultSets.push(rset);
        }
        if ((iid = content.getInstanceID()) != null) {
            long rowId;
            IResultSet rset;
            DataID dataId = iid.getDataID();
            while (dataId == null && iid.getParentID() != null) {
                iid = iid.getParentID();
                dataId = iid.getDataID();
            }
            if (dataId != null && !this.resultSets.isEmpty() && (rset = (IResultSet)this.resultSets.peek()) != null && (rowId = dataId.getRowID()) != -1L && rowId != rset.getCurrentPosition()) {
                rset.skipTo(rowId);
            }
        }
    }

    protected void checkDataSet(DataID dataId, IResultSet rset) {
        DataSetID dsetId = rset.getID();
        DataSetID rsetId = dataId.getDataSetID();
        if (!$assertionsDisabled && dsetId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rsetId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !dsetId.toString().equals(rsetId.toString())) {
            throw new AssertionError();
        }
    }

    protected void closeQuery(IContent content) {
        IResultSet rset;
        ReportItemDesign design;
        IBaseQueryDefinition query;
        Object generateBy = content.getGenerateBy();
        if (generateBy instanceof ReportItemDesign && (query = (design = (ReportItemDesign)generateBy).getQuery()) != null && (rset = (IResultSet)this.resultSets.pop()) != null) {
            rset.close();
        }
    }

    protected void startContent(IContent content, IContentEmitter emitter) {
        this.openQuery(content);
        this.outputStartVisitor.visit(content, emitter);
    }

    protected void endContent(IContent content, IContentEmitter emitter) {
        this.outputEndVisitor.visit(content, emitter);
        this.closeQuery(content);
    }

    long getIndex(IContent content) {
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null) {
            return docExt.getIndex();
        }
        return -1L;
    }

    static {
        $assertionsDisabled = !ReportContentLoaderV2.class.desiredAssertionStatus();
        logger = Logger.getLogger(IReportContentLoader.class.getName());
    }
}

