/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.birt.report.engine.internal.executor.doc.FragmentComparator;

public class Segment {
    LinkedList edges = new LinkedList();
    Object[][] sections;
    Comparator comparator;
    static final Object UNCLOSE_EDGE = new String("UNCLOSE");
    public static final Object LEFT_MOST_EDGE = new String("LEFT");
    public static final Object RIGHT_MOST_EDGE = new String("RIGHT");
    private static final int STATUS_INIT = 0;
    private static final int STATUS_START = 1;
    private static final int STATUS_CLOSE = 2;

    Segment(Comparator comparator) {
        if (!(comparator instanceof FragmentComparator)) {
            comparator = new FragmentComparator(comparator);
        }
        this.comparator = comparator;
    }

    void startSegment(Object left) {
        this.addEdge(left, true);
    }

    void endSegment(Object right) {
        this.addEdge(right, false);
    }

    boolean inSegment(Object offset) {
        if (this.sections == null) {
            this.normalize();
        }
        for (int i = 0; i < this.sections.length; ++i) {
            Object[] sect = this.sections[i];
            if (this.comparator.compare(sect[0], offset) > 0 || this.comparator.compare(sect[1], offset) < 0) continue;
            return true;
        }
        return false;
    }

    private void addEdge(Object offset, boolean left) {
        this.sections = null;
        SegmentEdge edge = null;
        ListIterator<SegmentEdge> iter = this.edges.listIterator(this.edges.size());
        while (iter.hasPrevious()) {
            SegmentEdge next = (SegmentEdge)iter.previous();
            if (this.comparator.compare(next.offset, offset) > 0) continue;
            edge = new SegmentEdge(offset, left);
            iter.next();
            iter.add(edge);
            return;
        }
        if (edge == null) {
            edge = new SegmentEdge(offset, left);
            this.edges.addFirst(edge);
        }
    }

    public void normalize() {
        int i;
        if (!this.edges.isEmpty()) {
            SegmentEdge start = (SegmentEdge)this.edges.getFirst();
            if (!start.leftEdge) {
                start = new SegmentEdge(LEFT_MOST_EDGE, true);
                this.edges.addFirst(start);
            }
            SegmentEdge end = (SegmentEdge)this.edges.getLast();
            if (end.leftEdge) {
                end = new SegmentEdge(RIGHT_MOST_EDGE, false);
                this.edges.addLast(end);
            }
        }
        ArrayList<Object[]> sects = new ArrayList<Object[]>();
        Object leftEdge = UNCLOSE_EDGE;
        Object rightEdge = UNCLOSE_EDGE;
        int status = 0;
        block9: for (i = 0; i < this.edges.size(); ++i) {
            SegmentEdge edge = (SegmentEdge)this.edges.get(i);
            switch (status) {
                case 0: {
                    if (edge.leftEdge) {
                        leftEdge = edge.offset;
                        rightEdge = UNCLOSE_EDGE;
                        status = 1;
                        continue block9;
                    }
                    leftEdge = LEFT_MOST_EDGE;
                    rightEdge = edge.offset;
                    status = 2;
                    continue block9;
                }
                case 1: {
                    if (edge.leftEdge) continue block9;
                    rightEdge = edge.offset;
                    status = 2;
                    continue block9;
                }
                case 2: {
                    if (edge.leftEdge) {
                        if (this.comparator.compare(edge.offset, rightEdge) == 0) {
                            rightEdge = UNCLOSE_EDGE;
                        } else {
                            if (!this.isSectEmpty(leftEdge, rightEdge)) {
                                sects.add(new Object[]{leftEdge, rightEdge});
                            }
                            leftEdge = edge.offset;
                            rightEdge = UNCLOSE_EDGE;
                        }
                        status = 1;
                        continue block9;
                    }
                    rightEdge = edge.offset;
                }
            }
        }
        switch (status) {
            case 1: {
                if (this.isSectEmpty(leftEdge, RIGHT_MOST_EDGE)) break;
                sects.add(new Object[]{leftEdge, RIGHT_MOST_EDGE});
                break;
            }
            case 2: {
                if (this.isSectEmpty(leftEdge, rightEdge)) break;
                sects.add(new Object[]{leftEdge, rightEdge});
            }
        }
        this.sections = new Object[sects.size()][];
        for (i = 0; i < sects.size(); ++i) {
            Object[] sect = (Object[])sects.get(i);
            this.sections[i] = sect;
        }
    }

    private boolean isSectEmpty(Object leftEdge, Object rightEdge) {
        return rightEdge == LEFT_MOST_EDGE || leftEdge == RIGHT_MOST_EDGE;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.sections == null) {
            this.normalize();
        }
        if (this.sections.length == 0) {
            return "[NONE]";
        }
        for (int i = 0; i < this.sections.length; ++i) {
            Object[] seg = this.sections[i];
            buffer.append("[");
            if (seg[0] == LEFT_MOST_EDGE && seg[1] == RIGHT_MOST_EDGE) {
                buffer.append("ALL");
            } else if (seg[0] == LEFT_MOST_EDGE && seg[1] == LEFT_MOST_EDGE) {
                buffer.append("NONE");
            } else {
                if (seg[0] != LEFT_MOST_EDGE) {
                    buffer.append(seg[0]);
                }
                buffer.append("-");
                if (seg[1] != RIGHT_MOST_EDGE) {
                    buffer.append(seg[1]);
                }
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    class SegmentEdge {
        Object offset;
        boolean leftEdge;

        SegmentEdge(Object offset, boolean leftEdge) {
            this.offset = offset;
            this.leftEdge = leftEdge;
        }
    }
}

