/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public abstract class PDFBlockStackingLM
extends PDFStackingLM
implements IBlockStackingLayoutManager {
    protected IReportItemExecutor blockExecutor = null;

    protected void addChild(PDFAbstractLM child) {
        this.child = child;
    }

    public PDFBlockStackingLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    protected boolean traverseChildren() {
        boolean childBreak = false;
        if (this.child != null && (childBreak = this.child.layout())) {
            if (this.child.isFinished()) {
                this.child = null;
            }
            return true;
        }
        if (this.blockExecutor == null) {
            this.blockExecutor = this.createExecutor();
        }
        while (this.blockExecutor.hasNextChild()) {
            IReportItemExecutor childExecutor = this.blockExecutor.getNextChild();
            if (childExecutor == null || !this.layoutChildNode(childExecutor)) continue;
            return true;
        }
        return false;
    }

    protected IReportItemExecutor createExecutor() {
        return new BlockStackingExecutor(this.content, this.executor);
    }

    private boolean layoutChildNode(IReportItemExecutor childExecutor) {
        boolean childBreak = false;
        IContent childContent = childExecutor.execute();
        PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, childExecutor);
        childBreak = childLM.layout();
        if (childBreak && !childLM.isFinished()) {
            this.child = childLM;
        }
        return childBreak;
    }

    protected void newContext() {
        this.createRoot();
        this.validateBoxProperty(this.root.getStyle(), this.parent.getMaxAvaWidth(), this.context.getMaxHeight());
        if (null != this.parent) {
            this.calculateSpecifiedWidth();
            int maxW = this.parent.getMaxAvaWidth() - this.parent.getCurrentIP();
            if (this.specifiedWidth > 0) {
                maxW = Math.min(maxW, this.specifiedWidth);
            }
            this.root.setAllocatedWidth(maxW);
            this.setMaxAvaWidth(this.root.getContentWidth());
            this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
            this.setMaxAvaHeight(this.root.getContentHeight());
        }
        this.setOffsetX(this.root.getContentX());
        this.setOffsetY(this.isFirst ? this.root.getContentY() : 0);
        this.setCurrentBP(0);
        this.setCurrentIP(0);
    }

    protected void closeLayout() {
        IStyle areaStyle = this.root.getStyle();
        if (!this.isLast) {
            areaStyle.setProperty(19, IStyle.NUMBER_0);
            areaStyle.setProperty(55, IStyle.NUMBER_0);
            areaStyle.setProperty(52, IStyle.NUMBER_0);
        }
        this.root.setHeight(this.getCurrentBP() + this.getOffsetY() + this.getDimensionValue(areaStyle.getProperty(55)) + this.getDimensionValue(areaStyle.getProperty(19)));
    }

    public boolean addArea(IArea area) {
        if (area == null) {
            return true;
        }
        AbstractArea aArea = (AbstractArea)area;
        if (aArea.getAllocatedHeight() + this.getCurrentBP() <= this.getMaxAvaHeight() || this.isPageEmpty()) {
            aArea.setAllocatedPosition(this.getCurrentIP() + this.getOffsetX(), this.getCurrentBP() + this.getOffsetY());
            this.setCurrentBP(this.getCurrentBP() + aArea.getAllocatedHeight());
            this.root.addChild(area);
            return true;
        }
        return false;
    }

    public int getLineHeight() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return PropertyUtil.getLineHeight(contentStyle.getLineHeight());
        }
        return 0;
    }

    public String getTextAlign() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return contentStyle.getTextAlign();
        }
        return null;
    }

    public int getTextIndent() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return this.getDimensionValue(contentStyle.getProperty(0), this.maxAvaWidth);
        }
        return 0;
    }

    protected void cancelChildren() {
        if (this.child != null) {
            this.child.cancel();
        }
    }
}

