/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.impl.CascadingParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.ParameterGroupDefn;
import org.eclipse.birt.report.engine.api.impl.ParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.impl.ScalarParameterDefn;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.MultiLineItemDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StylePropertyMapping;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.engine.parser.TableItemDesignLayout;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.FreeFormHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;

class EngineIRVisitor
extends DesignVisitor {
    protected static Logger logger;
    protected Object currentElement;
    protected String defaultUnit;
    protected Report report;
    protected ReportDesignHandle handle;
    protected CSSEngine cssEngine;
    StyleDeclaration nonInheritableReportStyle;
    StyleDeclaration inheritableReportStyle;
    long newCellId = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    EngineIRVisitor(ReportDesignHandle handle) {
        this.handle = handle;
    }

    public Report translate() {
        this.report = new Report();
        this.cssEngine = this.report.getCSSEngine();
        this.report.setReportDesign(this.handle);
        this.apply((DesignElementHandle)this.handle);
        return this.report;
    }

    public void visitReportDesign(ReportDesignHandle handle) {
        this.report.setUnit(handle.getDefaultUnits());
        if (handle.getBase() != null && !handle.getBase().equals("")) {
            this.report.setBasePath(handle.getBase());
        }
        this.defaultUnit = this.report.getUnit();
        this.setupNamedExpressions((DesignElementHandle)handle, this.report.getNamedExpressions());
        SharedStyleHandle defaultStyle = handle.findStyle("report");
        this.createReportDefaultStyles((StyleHandle)defaultStyle);
        PageSetupDesign pageSetup = new PageSetupDesign();
        SlotHandle pageSlot = handle.getMasterPages();
        for (int i = 0; i < pageSlot.getCount(); ++i) {
            this.apply(pageSlot.get(i));
            if (this.currentElement == null) continue;
            pageSetup.addMasterPage((MasterPageDesign)this.currentElement);
        }
        if (pageSlot.getCount() < 1) {
            SimpleMasterPageDesign masterPage = new SimpleMasterPageDesign();
            masterPage.setID(this.generateUniqueID());
            masterPage.setName("NewSimpleMasterPage");
            masterPage.setPageType("us-letter");
            masterPage.setOrientation("Auto");
            DimensionType top = new DimensionType(1.0, "in");
            DimensionType left = new DimensionType(1.25, "in");
            DimensionType right = new DimensionType(1.25, "in");
            DimensionType bottom = new DimensionType(1.0, "in");
            masterPage.setMargin(top, left, bottom, right);
            pageSetup.addMasterPage(masterPage);
        }
        this.report.setPageSetup(pageSetup);
        SlotHandle bodySlot = handle.getBody();
        for (int i = 0; i < bodySlot.getCount(); ++i) {
            this.apply(bodySlot.get(i));
            if (this.currentElement == null) continue;
            this.report.addContent((ReportItemDesign)this.currentElement);
        }
    }

    private void setupNamedExpressions(DesignElementHandle handle, Map namedExpressions) {
        List userProperties = handle.getUserProperties();
        if (userProperties == null || namedExpressions == null) {
            return;
        }
        for (int i = 0; i < userProperties.size(); ++i) {
            String name;
            String exprString;
            UserPropertyDefn userDef = (UserPropertyDefn)userProperties.get(i);
            if (userDef.getTypeCode() != 7 || (exprString = handle.getStringProperty(name = userDef.getName())) == null || exprString.trim().equals("")) continue;
            namedExpressions.put(name, exprString);
        }
    }

    private void setupMasterPage(MasterPageDesign page, MasterPageHandle handle) {
        this.setupStyledElement(page, (ReportElementHandle)handle);
        String styleName = this.setupBodyStyle(page);
        if (styleName != null) {
            page.setBodyStyleName(styleName);
        }
        page.setPageType(handle.getPageType());
        DimensionValue effectWidth = handle.getPageWidth();
        DimensionValue effectHeight = handle.getPageHeight();
        DimensionType width = null;
        DimensionType height = null;
        if (effectWidth != null) {
            width = new DimensionType(effectWidth.getMeasure(), effectWidth.getUnits());
        }
        if (effectHeight != null) {
            height = new DimensionType(effectHeight.getMeasure(), effectHeight.getUnits());
        }
        page.setPageSize(width, height);
        page.setOrientation(handle.getOrientation());
        DimensionType top = this.createDimension(handle.getTopMargin());
        DimensionType left = this.createDimension(handle.getLeftMargin());
        DimensionType bottom = this.createDimension(handle.getBottomMargin());
        DimensionType right = this.createDimension(handle.getRightMargin());
        page.setMargin(top, left, bottom, right);
    }

    protected void visitDesignElement(DesignElementHandle obj) {
        this.currentElement = null;
    }

    public void visitGraphicMasterPage(GraphicMasterPageHandle handle) {
        GraphicMasterPageDesign page = new GraphicMasterPageDesign();
        this.setupMasterPage(page, (MasterPageHandle)handle);
        page.setColumns(handle.getColumnCount());
        DimensionType spacing = this.createDimension(handle.getColumnSpacing());
        page.setColumnSpacing(spacing);
        SlotHandle contentSlot = handle.getContent();
        for (int i = 0; i < contentSlot.getCount(); ++i) {
            this.apply(contentSlot.get(i));
            if (this.currentElement == null) continue;
            page.addContent((ReportItemDesign)this.currentElement);
        }
        this.currentElement = page;
    }

    public void visitSimpleMasterPage(SimpleMasterPageHandle handle) {
        SimpleMasterPageDesign page = new SimpleMasterPageDesign();
        this.setupMasterPage(page, (MasterPageHandle)handle);
        page.setHeaderHeight(this.createDimension(handle.getHeaderHeight()));
        page.setFooterHeight(this.createDimension(handle.getFooterHeight()));
        page.setShowFooterOnLast(handle.showFooterOnLast());
        page.setShowHeaderOnFirst(handle.showHeaderOnFirst());
        page.setFloatingFooter(handle.isFloatingFooter());
        SlotHandle headerSlot = handle.getPageHeader();
        for (int i = 0; i < headerSlot.getCount(); ++i) {
            this.apply(headerSlot.get(i));
            if (this.currentElement == null) continue;
            page.addHeader((ReportItemDesign)this.currentElement);
        }
        SlotHandle footerSlot = handle.getPageFooter();
        for (int i = 0; i < footerSlot.getCount(); ++i) {
            this.apply(footerSlot.get(i));
            if (this.currentElement == null) continue;
            page.addFooter((ReportItemDesign)this.currentElement);
        }
        this.currentElement = page;
    }

    public void visitList(ListHandle handle) {
        SlotHandle footerSlot;
        ListItemDesign listItem = new ListItemDesign();
        this.setupListingItem(listItem, (ListingHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            ListBandDesign header = this.createListBand(headerSlot);
            header.setBandType(1);
            listItem.setHeader(header);
            listItem.setRepeatHeader(handle.repeatHeader());
        }
        SlotHandle groupsSlot = handle.getGroups();
        for (int i = 0; i < groupsSlot.getCount(); ++i) {
            this.apply(groupsSlot.get(i));
            if (this.currentElement == null) continue;
            GroupDesign group = (GroupDesign)this.currentElement;
            group.setGroupLevel(i);
            listItem.addGroup(group);
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            ListBandDesign detail = this.createListBand(detailSlot);
            detail.setBandType(0);
            listItem.setDetail(detail);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            ListBandDesign footer = this.createListBand(footerSlot);
            footer.setBandType(2);
            listItem.setFooter(footer);
        }
        this.currentElement = listItem;
    }

    public void visitFreeForm(FreeFormHandle handle) {
        FreeFormItemDesign container = new FreeFormItemDesign();
        this.setupReportItem(container, (ReportItemHandle)handle);
        SlotHandle slot = handle.getReportItems();
        for (int i = 0; i < slot.getCount(); ++i) {
            this.apply(slot.get(i));
            if (this.currentElement == null) continue;
            container.addItem((ReportItemDesign)this.currentElement);
        }
        this.currentElement = container;
    }

    public void visitTextDataItem(TextDataHandle handle) {
        MultiLineItemDesign multiLineItem = new MultiLineItemDesign();
        this.setupReportItem(multiLineItem, (ReportItemHandle)handle);
        String valueExpr = handle.getValueExpr();
        String contentType = handle.getContentType();
        multiLineItem.setContent(this.createExpression(valueExpr));
        multiLineItem.setContentType(contentType);
        this.setHighlight(multiLineItem, valueExpr);
        this.setMap(multiLineItem, valueExpr);
        this.currentElement = multiLineItem;
    }

    public void visitParameterGroup(ParameterGroupHandle handle) {
        ParameterGroupDefn paramGroup = new ParameterGroupDefn();
        paramGroup.setHandle((ReportElementHandle)handle);
        paramGroup.setParameterType(4);
        paramGroup.setName(handle.getName());
        paramGroup.setDisplayName(handle.getDisplayName());
        paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
        paramGroup.setHelpText(handle.getHelpText());
        paramGroup.setHelpTextKey(handle.getHelpTextKey());
        SlotHandle parameters = handle.getParameters();
        List properties = handle.getUserProperties();
        for (int i = 0; i < properties.size(); ++i) {
            UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
            paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
        }
        int size = parameters.getCount();
        for (int n = 0; n < size; ++n) {
            this.apply(parameters.get(n));
            if (this.currentElement == null) continue;
            paramGroup.addParameter((IParameterDefnBase)this.currentElement);
        }
        this.currentElement = paramGroup;
    }

    public void visitCascadingParameterGroup(CascadingParameterGroupHandle handle) {
        CascadingParameterGroupDefn paramGroup = new CascadingParameterGroupDefn();
        paramGroup.setHandle((ReportElementHandle)handle);
        paramGroup.setParameterType(5);
        paramGroup.setName(handle.getName());
        paramGroup.setDisplayName(handle.getDisplayName());
        paramGroup.setDisplayNameKey(handle.getDisplayNameKey());
        paramGroup.setHelpText(handle.getHelpText());
        paramGroup.setHelpTextKey(handle.getHelpTextKey());
        paramGroup.setPromptText(handle.getPromptText());
        DataSetHandle dset = handle.getDataSet();
        if (dset != null) {
            paramGroup.setDataSet(dset.getName());
        }
        SlotHandle parameters = handle.getParameters();
        List properties = handle.getUserProperties();
        for (int i = 0; i < properties.size(); ++i) {
            UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
            paramGroup.addUserProperty(p.getName(), handle.getProperty(p.getName()));
        }
        int size = parameters.getCount();
        for (int n = 0; n < size; ++n) {
            this.apply(parameters.get(n));
            if (this.currentElement == null) continue;
            paramGroup.addParameter((IParameterDefnBase)this.currentElement);
        }
        this.currentElement = paramGroup;
    }

    public void visitScalarParameter(ScalarParameterHandle handle) {
        if (!$assertionsDisabled && handle.getName() == null) {
            throw new AssertionError();
        }
        ScalarParameterDefn scalarParameter = new ScalarParameterDefn();
        scalarParameter.setHandle((ReportElementHandle)handle);
        scalarParameter.setParameterType(0);
        scalarParameter.setName(handle.getName());
        List properties = handle.getUserProperties();
        for (int i = 0; i < properties.size(); ++i) {
            UserPropertyDefn p = (UserPropertyDefn)properties.get(i);
            scalarParameter.addUserProperty(p.getName(), handle.getProperty(p.getName()));
        }
        String align = handle.getAlignment();
        if ("center".equals(align)) {
            scalarParameter.setAlignment(2);
        } else if ("left".equals(align)) {
            scalarParameter.setAlignment(1);
        } else if ("right".equals(align)) {
            scalarParameter.setAlignment(3);
        } else {
            scalarParameter.setAlignment(0);
        }
        scalarParameter.setAllowBlank(handle.allowBlank());
        scalarParameter.setAllowNull(handle.allowNull());
        String controlType = handle.getControlType();
        if ("check-box".equals(controlType)) {
            scalarParameter.setControlType(3);
        } else if ("list-box".equals(controlType)) {
            scalarParameter.setControlType(1);
        } else if ("radio-button".equals(controlType)) {
            scalarParameter.setControlType(2);
        } else {
            scalarParameter.setControlType(0);
        }
        scalarParameter.setDefaultValue(handle.getDefaultValue());
        scalarParameter.setDisplayName(handle.getDisplayName());
        scalarParameter.setDisplayNameKey(handle.getDisplayNameKey());
        scalarParameter.setFormat(handle.getPattern());
        scalarParameter.setHelpText(handle.getHelpText());
        scalarParameter.setHelpTextKey(handle.getHelpTextKey());
        scalarParameter.setPromptText(handle.getPromptText());
        scalarParameter.setPromptTextKey(handle.getPromptTextID());
        scalarParameter.setIsHidden(handle.isHidden());
        scalarParameter.setName(handle.getName());
        String valueType = handle.getDataType();
        if ("boolean".equals(valueType)) {
            scalarParameter.setDataType(5);
        } else if ("dateTime".equals(valueType)) {
            scalarParameter.setDataType(4);
        } else if ("decimal".equals(valueType)) {
            scalarParameter.setDataType(3);
        } else if ("float".equals(valueType)) {
            scalarParameter.setDataType(2);
        } else if ("string".equals(valueType)) {
            scalarParameter.setDataType(1);
        } else if ("integer".equals(valueType)) {
            scalarParameter.setDataType(6);
        } else {
            scalarParameter.setDataType(0);
        }
        ArrayList<ParameterSelectionChoice> values = new ArrayList<ParameterSelectionChoice>();
        Iterator selectionIter = handle.choiceIterator();
        while (selectionIter.hasNext()) {
            SelectionChoiceHandle selection = (SelectionChoiceHandle)selectionIter.next();
            ParameterSelectionChoice selectionChoice = new ParameterSelectionChoice(this.handle);
            selectionChoice.setLabel(selection.getLabelKey(), selection.getLabel());
            selectionChoice.setValue(selection.getValue(), scalarParameter.getDataType());
            values.add(selectionChoice);
        }
        scalarParameter.setSelectionList(values);
        scalarParameter.setAllowNewValues(!handle.isMustMatch());
        scalarParameter.setFixedOrder(handle.isFixedOrder());
        String paramType = handle.getValueType();
        if ("static".equals(paramType) && scalarParameter.getSelectionList() != null && scalarParameter.getSelectionList().size() > 0) {
            scalarParameter.setSelectionListType(2);
        } else if ("dynamic".equals(paramType)) {
            scalarParameter.setSelectionListType(1);
        } else {
            scalarParameter.setSelectionListType(0);
        }
        scalarParameter.setValueConcealed(handle.isConcealValue());
        this.currentElement = scalarParameter;
    }

    public void visitLabel(LabelHandle handle) {
        LabelItemDesign labelItem = new LabelItemDesign();
        this.setupReportItem(labelItem, (ReportItemHandle)handle);
        String text = handle.getText();
        String textKey = handle.getTextKey();
        labelItem.setText(textKey, text);
        ActionHandle action = handle.getActionHandle();
        if (action != null) {
            labelItem.setAction(this.createAction(action));
        }
        labelItem.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        this.currentElement = labelItem;
    }

    public void visitAutoText(AutoTextHandle handle) {
        AutoTextItemDesign autoTextItem = new AutoTextItemDesign();
        this.setupReportItem(autoTextItem, (ReportItemHandle)handle);
        autoTextItem.setType(handle.getAutoTextType());
        this.currentElement = autoTextItem;
    }

    public void visitDataItem(DataItemHandle handle) {
        ActionHandle action;
        DataItemDesign data = new DataItemDesign();
        this.setupReportItem(data, (ReportItemHandle)handle);
        data.setName(handle.getName());
        String expr = handle.getResultSetColumn();
        if (expr != null && expr.trim().length() > 0) {
            data.setBindingColumn(expr);
        }
        if ((action = handle.getActionHandle()) != null) {
            data.setAction(this.createAction(action));
        }
        data.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        this.setHighlight(data, expr);
        this.setMap(data, expr);
        this.currentElement = data;
    }

    public void visitGrid(GridHandle handle) {
        GridItemDesign grid = new GridItemDesign();
        this.setupReportItem(grid, (ReportItemHandle)handle);
        SlotHandle columnSlot = handle.getColumns();
        for (int i = 0; i < columnSlot.getCount(); ++i) {
            ColumnHandle columnHandle = (ColumnHandle)columnSlot.get(i);
            this.apply((DesignElementHandle)columnHandle);
            if (this.currentElement == null) continue;
            ColumnDesign columnDesign = (ColumnDesign)this.currentElement;
            for (int j = 0; j < columnHandle.getRepeatCount(); ++j) {
                grid.addColumn(columnDesign);
            }
        }
        SlotHandle rowSlot = handle.getRows();
        for (int i = 0; i < rowSlot.getCount(); ++i) {
            this.apply(rowSlot.get(i));
            if (this.currentElement == null) continue;
            grid.addRow((RowDesign)this.currentElement);
        }
        new TableItemDesignLayout().layout(grid);
        this.applyColumnHighlight(grid);
        this.currentElement = grid;
    }

    public void visitImage(ImageHandle handle) {
        ImageItemDesign image = new ImageItemDesign();
        this.setupReportItem(image, (ReportItemHandle)handle);
        ActionHandle action = handle.getActionHandle();
        if (action != null) {
            image.setAction(this.createAction(action));
        }
        image.setAltText(handle.getAltTextKey(), handle.getAltText());
        image.setHelpText(handle.getHelpTextKey(), handle.getHelpText());
        String imageSrc = handle.getSource();
        if ("url".equals(imageSrc)) {
            image.setImageUri(this.createExpression(handle.getURL()));
        } else if ("expr".equals(imageSrc)) {
            String valueExpr = handle.getValueExpression();
            String typeExpr = handle.getTypeExpression();
            String imageValue = this.createExpression(valueExpr);
            String imageType = this.createExpression(typeExpr);
            image.setImageExpression(imageValue, imageType);
        } else if ("embed".equals(imageSrc)) {
            image.setImageName(handle.getImageName());
        } else if ("file".equals(imageSrc)) {
            image.setImageFile(this.createExpression(handle.getFile()));
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        this.currentElement = image;
    }

    public void visitTable(TableHandle handle) {
        SlotHandle footerSlot;
        TableItemDesign table = new TableItemDesign();
        table.setRepeatHeader(handle.repeatHeader());
        this.setupListingItem(table, (ListingHandle)handle);
        String caption = handle.getCaption();
        String captionKey = handle.getCaptionKey();
        if (caption != null || captionKey != null) {
            table.setCaption(captionKey, caption);
        }
        SlotHandle columnSlot = handle.getColumns();
        for (int i = 0; i < columnSlot.getCount(); ++i) {
            ColumnHandle columnHandle = (ColumnHandle)columnSlot.get(i);
            this.apply((DesignElementHandle)columnHandle);
            if (this.currentElement == null) continue;
            ColumnDesign columnDesign = (ColumnDesign)this.currentElement;
            for (int j = 0; j < columnHandle.getRepeatCount(); ++j) {
                table.addColumn(columnDesign);
            }
        }
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            TableBandDesign header = this.createTableBand(headerSlot);
            header.setBandType(1);
            table.setHeader(header);
        }
        SlotHandle groupSlot = handle.getGroups();
        for (int i = 0; i < groupSlot.getCount(); ++i) {
            this.apply(groupSlot.get(i));
            if (this.currentElement == null) continue;
            TableGroupDesign group = (TableGroupDesign)this.currentElement;
            group.setGroupLevel(i);
            this.locateGroupIcon(group);
            table.addGroup(group);
        }
        SlotHandle detailSlot = handle.getDetail();
        if (detailSlot.getCount() > 0) {
            TableBandDesign detail = this.createTableBand(detailSlot);
            detail.setBandType(0);
            table.setDetail(detail);
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            TableBandDesign footer = this.createTableBand(footerSlot);
            footer.setBandType(2);
            table.setFooter(footer);
        }
        new TableItemDesignLayout().layout(table);
        this.applyColumnHighlight(table);
        TableBandDesign detail = (TableBandDesign)table.getDetail();
        if (detail != null) {
            for (int i = 0; i < detail.getRowCount(); ++i) {
                RowDesign row = detail.getRow(i);
                block4: for (int j = 0; j < row.getCellCount(); ++j) {
                    ReportItemDesign item;
                    int k;
                    CellDesign cell = row.getCell(j);
                    ColumnDesign column = table.getColumn(cell.getColumn());
                    if (column.getSuppressDuplicate()) {
                        for (k = 0; k < cell.getContentCount(); ++k) {
                            item = cell.getContent(k);
                            if (!(item instanceof DataItemDesign)) continue;
                            DataItemDesign dataItem = (DataItemDesign)item;
                            dataItem.setSuppressDuplicate(true);
                        }
                    }
                    if (column.hasDataItemsInDetail()) continue;
                    for (k = 0; k < cell.getContentCount(); ++k) {
                        item = cell.getContent(k);
                        if (!(item instanceof DataItemDesign)) continue;
                        column.setHasDataItemsInDetail(true);
                        continue block4;
                    }
                }
            }
        }
        this.currentElement = table;
    }

    private void locateGroupIcon(TableGroupDesign group) {
        CellDesign cell;
        RowDesign row;
        GroupHandle groupHandle = (GroupHandle)group.getHandle();
        TableHandle tableHandle = (TableHandle)groupHandle.getContainer();
        String keyExpression = groupHandle.getKeyExpr();
        if (keyExpression == null) {
            return;
        }
        keyExpression = keyExpression.trim();
        BandDesign groupHeader = group.getHeader();
        String columnBindingExpression = this.getColumnBinding(tableHandle, keyExpression);
        for (int i = 0; i < groupHeader.getContentCount(); ++i) {
            RowDesign row2 = (RowDesign)groupHeader.getContent(i);
            for (int j = 0; j < row2.getCellCount(); ++j) {
                CellDesign cell2 = row2.getCell(j);
                for (int k = 0; k < cell2.getContentCount(); ++k) {
                    ReportItemDesign item = cell2.getContent(k);
                    if (!this.hasExpression(tableHandle, item, keyExpression, columnBindingExpression)) continue;
                    cell2.setDisplayGroupIcon(true);
                    return;
                }
            }
        }
        if (groupHeader.getContentCount() > 0 && null != (row = (RowDesign)groupHeader.getContent(0)) && null != (cell = row.getCell(0))) {
            cell.setDisplayGroupIcon(true);
        }
    }

    private boolean hasExpression(TableHandle tableHandle, ReportItemDesign item, String keyExpression, String columnBindingExpression) {
        if (!$assertionsDisabled && keyExpression == null) {
            throw new AssertionError();
        }
        if (item instanceof DataItemDesign) {
            DataItemDesign data = (DataItemDesign)item;
            String value = data.getValue();
            if (value != null && keyExpression.equals(value.trim())) {
                return true;
            }
            String columnBinding = this.getColumnBinding(tableHandle, value);
            if (columnBinding != null && columnBindingExpression != null && columnBindingExpression.equals(columnBinding)) {
                return true;
            }
        }
        if (item instanceof GridItemDesign) {
            GridItemDesign grid = (GridItemDesign)item;
            GridHandle gridHandle = (GridHandle)grid.getHandle();
            PropertyHandle columnBindings = gridHandle.getColumnBindings();
            if (columnBindings != null && columnBindings.iterator().hasNext()) {
                return false;
            }
            for (int i = 0; i < grid.getRowCount(); ++i) {
                RowDesign row = grid.getRow(i);
                for (int j = 0; j < row.getCellCount(); ++j) {
                    CellDesign cell = row.getCell(j);
                    for (int k = 0; k < cell.getContentCount(); ++k) {
                        ReportItemDesign reportItem = cell.getContent(k);
                        if (!this.hasExpression(tableHandle, reportItem, keyExpression, columnBindingExpression)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private String getColumnBinding(TableHandle tableHandle, String keyExpression) {
        String columnBindingName = null;
        try {
            columnBindingName = ExpressionUtil.getColumnBindingName((String)keyExpression);
        }
        catch (BirtException e) {
            logger.log(Level.FINE, e.getMessage(), e);
            return null;
        }
        return this.getColumnBindingByName(tableHandle, columnBindingName);
    }

    private String getColumnBindingByName(TableHandle tableHandle, String columnBindingName) {
        if (columnBindingName == null) {
            return null;
        }
        Iterator iterator = tableHandle.columnBindingsIterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle columnBinding = (ComputedColumnHandle)iterator.next();
            if (!columnBindingName.equals(columnBinding.getName())) continue;
            return columnBinding.getExpression();
        }
        return null;
    }

    private void applyColumnHighlight(TableItemDesign table) {
        this.applyColumnHighlight(table, table.getDetail());
        for (int i = 0; i < table.getGroupCount(); ++i) {
            this.applyColumnHighlight(table, table.getGroup(i).getHeader());
            this.applyColumnHighlight(table, table.getGroup(i).getFooter());
        }
    }

    private void applyColumnHighlight(GridItemDesign grid) {
        for (int i = 0; i < grid.getRowCount(); ++i) {
            RowDesign row = grid.getRow(i);
            for (int j = 0; j < row.getCellCount(); ++j) {
                CellDesign cell = row.getCell(j);
                ColumnDesign column = grid.getColumn(cell.getColumn());
                this.applyColumnHighlight(column, cell);
            }
        }
    }

    private void applyColumnHighlight(TableItemDesign table, BandDesign band) {
        if (band == null) {
            return;
        }
        for (int i = 0; i < band.getContentCount(); ++i) {
            ReportItemDesign content = band.getContent(i);
            if (!(content instanceof RowDesign)) continue;
            RowDesign row = (RowDesign)content;
            for (int j = 0; j < row.getCellCount(); ++j) {
                CellDesign cell = row.getCell(j);
                ColumnDesign column = table.getColumn(cell.getColumn());
                this.applyColumnHighlight(column, cell);
            }
        }
    }

    private void applyColumnHighlight(ColumnDesign column, CellDesign cell) {
        HighlightDesign columnHighlight = column.getHighlight();
        if (columnHighlight != null && columnHighlight.getRuleCount() > 0) {
            HighlightDesign cellHighlight = cell.getHighlight();
            if (cellHighlight == null) {
                cellHighlight = new HighlightDesign();
                cell.setHighlight(cellHighlight);
            }
            for (int i = 0; i < columnHighlight.getRuleCount(); ++i) {
                cellHighlight.addRule(new HighlightRuleDesign(columnHighlight.getRule(i)));
            }
        }
    }

    public void visitColumn(ColumnHandle handle) {
        ColumnDesign col = new ColumnDesign();
        this.setupReportElement(col, (DesignElementHandle)handle);
        DimensionType width = this.createDimension(handle.getWidth());
        col.setWidth(width);
        boolean supress = handle.suppressDuplicates();
        col.setSuppressDuplicate(supress);
        VisibilityDesign visibility = this.createVisibility(handle.visibilityRulesIterator());
        col.setVisibility(visibility);
        this.currentElement = col;
    }

    public void visitRow(RowHandle handle) {
        RowDesign row = new RowDesign();
        this.setupStyledElement(row, (ReportElementHandle)handle);
        DimensionType height = this.createDimension(handle.getHeight());
        row.setHeight(height);
        String bookmark = handle.getBookmark();
        row.setBookmark(this.createExpression(bookmark));
        VisibilityDesign visibility = this.createVisibility(handle.visibilityRulesIterator());
        row.setVisibility(visibility);
        SlotHandle cellSlot = handle.getCells();
        for (int i = 0; i < cellSlot.getCount(); ++i) {
            this.apply(cellSlot.get(i));
            if (this.currentElement == null) continue;
            row.addCell((CellDesign)this.currentElement);
        }
        String onCreate = handle.getOnCreate();
        row.setOnCreate(this.createExpression(onCreate));
        row.setOnRender(handle.getOnRender());
        this.setHighlight(row, null);
        this.currentElement = row;
    }

    private boolean isContainer(ReportElementHandle handle) {
        if (handle instanceof TextItemHandle) {
            return false;
        }
        if (handle instanceof DataItemHandle) {
            return false;
        }
        if (handle instanceof LabelHandle) {
            return false;
        }
        if (handle instanceof TextDataHandle) {
            return false;
        }
        if (handle instanceof ExtendedItemHandle) {
            return false;
        }
        return !(handle instanceof ImageHandle);
    }

    protected void setupStyledElement(StyledElementDesign design, ReportElementHandle handle) {
        this.setupReportElement(design, (DesignElementHandle)handle);
        StyleDeclaration style = this.createPrivateStyle(handle, this.isContainer(handle));
        if (style != null && !style.isEmpty()) {
            design.setStyleName(this.assignStyleName(style));
        }
    }

    public void visitCell(CellHandle handle) {
        CellDesign cell = new CellDesign();
        this.setupStyledElement(cell, (ReportElementHandle)handle);
        SlotHandle contentSlot = handle.getContent();
        for (int i = 0; i < contentSlot.getCount(); ++i) {
            this.apply(contentSlot.get(i));
            if (this.currentElement == null) continue;
            cell.addContent((ReportItemDesign)this.currentElement);
        }
        cell.setColSpan(handle.getColumnSpan());
        int columnId = handle.getColumn() - 1;
        if (columnId < 0) {
            columnId = -1;
        }
        cell.setColumn(columnId);
        cell.setRowSpan(handle.getRowSpan());
        cell.setDrop(handle.getDrop());
        String onCreate = handle.getOnCreate();
        cell.setOnCreate(this.createExpression(onCreate));
        cell.setOnRender(handle.getOnRender());
        this.setHighlight(cell, null);
        this.currentElement = cell;
    }

    private ListBandDesign createListBand(SlotHandle elements) {
        ListBandDesign band = new ListBandDesign();
        band.setID(this.generateUniqueID());
        for (int i = 0; i < elements.getCount(); ++i) {
            this.apply(elements.get(i));
            if (this.currentElement == null) continue;
            band.addContent((ReportItemDesign)this.currentElement);
        }
        return band;
    }

    public void visitListGroup(ListGroupHandle handle) {
        SlotHandle footerSlot;
        ListGroupDesign listGroup = new ListGroupDesign();
        this.setupGroup(listGroup, (GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            ListBandDesign header = this.createListBand(headerSlot);
            header.setBandType(3);
            header.setGroup(listGroup);
            listGroup.setHeader(header);
            listGroup.setHeaderRepeat(handle.repeatHeader());
            String toc = handle.getTocExpression();
            if (null != toc && !"".equals(toc.trim())) {
                listGroup.setTOC(this.createExpression(toc));
            }
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            ListBandDesign footer = this.createListBand(footerSlot);
            footer.setBandType(4);
            footer.setGroup(listGroup);
            listGroup.setFooter(footer);
        }
        boolean hideDetail = handle.hideDetail();
        listGroup.setHideDetail(hideDetail);
        listGroup.setOnPageBreak(handle.getOnPageBreak());
        this.currentElement = listGroup;
    }

    public void visitTableGroup(TableGroupHandle handle) {
        SlotHandle footerSlot;
        TableGroupDesign tableGroup = new TableGroupDesign();
        this.setupGroup(tableGroup, (GroupHandle)handle);
        SlotHandle headerSlot = handle.getHeader();
        if (headerSlot.getCount() > 0) {
            TableBandDesign header = this.createTableBand(handle.getHeader());
            header.setBandType(3);
            header.setGroup(tableGroup);
            tableGroup.setHeader(header);
            tableGroup.setHeaderRepeat(handle.repeatHeader());
            String toc = handle.getTocExpression();
            if (null != toc && !"".equals(toc.trim())) {
                tableGroup.setTOC(this.createExpression(toc));
            }
        }
        if ((footerSlot = handle.getFooter()).getCount() > 0) {
            TableBandDesign footer = this.createTableBand(handle.getFooter());
            footer.setBandType(4);
            footer.setGroup(tableGroup);
            tableGroup.setFooter(footer);
        }
        boolean hideDetail = handle.hideDetail();
        tableGroup.setHideDetail(hideDetail);
        tableGroup.setOnPageBreak(handle.getOnPageBreak());
        this.currentElement = tableGroup;
    }

    public void visitTextItem(TextItemHandle handle) {
        TextItemDesign textItem = new TextItemDesign();
        this.setupReportItem(textItem, (ReportItemHandle)handle);
        String contentType = handle.getContentType();
        if (contentType != null) {
            textItem.setTextType(contentType);
        }
        textItem.setText(handle.getContentKey(), handle.getContent());
        this.currentElement = textItem;
    }

    protected void visitExtendedItem(ExtendedItemHandle obj) {
        ExtendedItemDesign extendedItem = new ExtendedItemDesign();
        this.setupReportItem(extendedItem, (ReportItemHandle)obj);
        extendedItem.setAltText(obj.getAltTextKey(), obj.getAltText());
        this.currentElement = extendedItem;
    }

    public void visitTemplateReportItem(TemplateReportItemHandle obj) {
        TemplateDesign template = new TemplateDesign();
        this.setupTemplateReportElement(template, obj);
        template.setPromptText(obj.getDescription());
        template.setPromptTextKey(obj.getDescriptionKey());
        template.setAllowedType(obj.getAllowedType());
        this.currentElement = template;
    }

    protected void setupGroup(GroupDesign group, GroupHandle handle) {
        group.setID(handle.getID());
        this.setupElementIDMap(group);
        group.setName(handle.getName());
        String pageBreakBefore = handle.getStringProperty("pageBreakBefore");
        String pageBreakAfter = handle.getStringProperty("pageBreakAfter");
        group.setPageBreakBefore(pageBreakBefore);
        group.setPageBreakAfter(pageBreakAfter);
        group.setHandle((DesignElementHandle)handle);
        group.setJavaClass(handle.getEventHandlerClass());
    }

    private TableBandDesign createTableBand(SlotHandle elements) {
        TableBandDesign band = new TableBandDesign();
        band.setID(this.generateUniqueID());
        for (int i = 0; i < elements.getCount(); ++i) {
            this.apply(elements.get(i));
            if (this.currentElement == null) continue;
            band.addRow((RowDesign)this.currentElement);
        }
        return band;
    }

    protected VisibilityDesign createVisibility(Iterator visibilityRulesIterator) {
        if (visibilityRulesIterator != null) {
            VisibilityDesign visibility = new VisibilityDesign();
            while (visibilityRulesIterator.hasNext()) {
                VisibilityRuleDesign hide = this.createHide((HideRuleHandle)visibilityRulesIterator.next());
                visibility.addRule(hide);
            }
            if (visibility.count() == 0) {
                return null;
            }
            return visibility;
        }
        return null;
    }

    protected VisibilityRuleDesign createHide(HideRuleHandle handle) {
        VisibilityRuleDesign rule = new VisibilityRuleDesign();
        rule.setExpression(this.createExpression(handle.getExpression()));
        String format = handle.getFormat();
        if ("html".equalsIgnoreCase(format)) {
            format = "viewer";
        }
        rule.setFormat(format);
        return rule;
    }

    private void setupReportItem(ReportItemDesign item, ReportItemHandle handle) {
        this.setupStyledElement(item, (ReportElementHandle)handle);
        DimensionType height = this.createDimension(handle.getHeight());
        DimensionType width = this.createDimension(handle.getWidth());
        DimensionType x = this.createDimension(handle.getX());
        DimensionType y = this.createDimension(handle.getY());
        item.setHeight(height);
        item.setWidth(width);
        item.setX(x);
        item.setY(y);
        String toc = handle.getTocExpression();
        item.setTOC(this.createExpression(toc));
        String bookmark = handle.getBookmark();
        item.setBookmark(this.createExpression(bookmark));
        String onCreate = handle.getOnCreate();
        item.setOnCreate(this.createExpression(onCreate));
        item.setOnRender(handle.getOnRender());
        item.setOnPageBreak(handle.getOnPageBreak());
        Iterator visibilityIter = handle.visibilityRulesIterator();
        VisibilityDesign visibility = this.createVisibility(visibilityIter);
        item.setVisibility(visibility);
        this.setHighlight(item, null);
    }

    private void setupReportElement(ReportElementDesign element, DesignElementHandle handle) {
        List list;
        element.setHandle(handle);
        element.setName(handle.getName());
        element.setID(handle.getID());
        DesignElementHandle extend = handle.getExtends();
        if (extend != null) {
            element.setExtends(extend.getName());
        }
        if ((list = handle.getUserProperties()) != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                UserPropertyDefn propDefn = (UserPropertyDefn)iter.next();
                String propName = propDefn.getName();
                PropertyHandle propHandle = handle.getPropertyHandle(propName);
                String propValue = propHandle.getStringValue();
                element.getCustomProperties().put(propName, propValue);
            }
        }
        this.setupNamedExpressions(handle, element.getNamedExpressions());
        this.setupElementIDMap(element);
        element.setJavaClass(handle.getEventHandlerClass());
    }

    private void setupTemplateReportElement(ReportItemDesign element, TemplateReportItemHandle handle) {
        this.setupReportElement(element, (DesignElementHandle)handle);
        Iterator visibilityIter = handle.visibilityRulesIterator();
        VisibilityDesign visibility = this.createVisibility(visibilityIter);
        element.setVisibility(visibility);
    }

    protected String createExpression(String expr) {
        if (expr != null && !expr.trim().equals("")) {
            return expr;
        }
        return null;
    }

    protected ActionDesign createAction(ActionHandle handle) {
        ActionDesign action = new ActionDesign();
        String linkType = handle.getLinkType();
        if ("hyperlink".equals(linkType)) {
            action.setHyperlink(this.createExpression(handle.getURI()));
            action.setTargetWindow(handle.getTargetWindow());
        } else if ("bookmark-link".equals(linkType)) {
            action.setBookmark(this.createExpression(handle.getTargetBookmark()));
            action.setBookmarkType(!"toc".equals(handle.getTargetBookmarkType()));
        } else if ("drill-through".equals(linkType)) {
            action.setTargetWindow(handle.getTargetWindow());
            DrillThroughActionDesign drillThrough = new DrillThroughActionDesign();
            action.setDrillThrough(drillThrough);
            drillThrough.setReportName(handle.getReportName());
            drillThrough.setFormat(handle.getFormatType());
            drillThrough.setBookmark(this.createExpression(handle.getTargetBookmark()));
            drillThrough.setBookmarkType(!"toc".equals(handle.getTargetBookmarkType()));
            HashMap<String, String> params = new HashMap<String, String>();
            Iterator paramIte = handle.paramBindingsIterator();
            while (paramIte.hasNext()) {
                ParamBindingHandle member = (ParamBindingHandle)paramIte.next();
                params.put(member.getParamName(), this.createExpression(member.getExpression()));
            }
            drillThrough.setParameters(params);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return action;
    }

    protected HighlightRuleDesign createHighlightRule(StructureHandle ruleHandle, String defaultStr) {
        HighlightRuleDesign rule = new HighlightRuleDesign();
        MemberHandle hOperator = ruleHandle.getMember("operator");
        MemberHandle hValue1 = ruleHandle.getMember("value1");
        MemberHandle hValue2 = ruleHandle.getMember("value2");
        MemberHandle hTestExpr = ruleHandle.getMember("testExpr");
        String oper = hOperator.getStringValue();
        String value1 = hValue1.getStringValue();
        String value2 = hValue2.getStringValue();
        String testExpr = hTestExpr.getStringValue();
        rule.setExpression(oper, value1, value2);
        if (testExpr != null && testExpr.length() > 0) {
            rule.setTestExpression(testExpr);
        } else if (defaultStr != null && defaultStr.length() > 0) {
            rule.setTestExpression(defaultStr);
        } else {
            return null;
        }
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        this.setupStyle(ruleHandle, style);
        if (style.isEmpty()) {
            return null;
        }
        rule.setStyle(style);
        return rule;
    }

    protected void setHighlight(StyledElementDesign item, String defaultStr) {
        StyleHandle handle = item.getHandle().getPrivateStyle();
        if (handle == null) {
            return;
        }
        Iterator iter = handle.highlightRulesIterator();
        if (iter == null) {
            return;
        }
        HighlightDesign highlight = new HighlightDesign();
        while (iter.hasNext()) {
            HighlightRuleHandle ruleHandle = (HighlightRuleHandle)iter.next();
            HighlightRuleDesign rule = this.createHighlightRule((StructureHandle)ruleHandle, defaultStr);
            if (rule == null) continue;
            highlight.addRule(rule);
        }
        if (highlight.getRuleCount() > 0) {
            item.setHighlight(highlight);
        }
    }

    protected void setMap(StyledElementDesign item, String defaultStr) {
        StyleHandle handle = item.getHandle().getPrivateStyle();
        if (handle == null) {
            return;
        }
        Iterator iter = handle.mapRulesIterator();
        if (iter == null) {
            return;
        }
        MapDesign map = new MapDesign();
        while (iter.hasNext()) {
            MapRuleHandle ruleHandle = (MapRuleHandle)iter.next();
            MapRuleDesign rule = this.createMapRule(ruleHandle, defaultStr);
            if (rule == null) continue;
            map.addRule(rule);
        }
        if (map.getRuleCount() > 0) {
            item.setMap(map);
        }
    }

    protected MapRuleDesign createMapRule(MapRuleHandle handle, String defaultStr) {
        MapRuleDesign rule = new MapRuleDesign();
        rule.setExpression(handle.getOperator(), handle.getValue1(), handle.getValue2());
        String displayText = handle.getDisplay();
        rule.setDisplayText(handle.getDisplayKey(), displayText == null ? "" : displayText);
        String testExpr = handle.getTestExpression();
        if (testExpr != null && testExpr.length() > 0) {
            rule.setTestExpression(testExpr);
        } else if (defaultStr != null && defaultStr.length() > 0) {
            rule.setTestExpression(defaultStr);
        } else {
            return null;
        }
        return rule;
    }

    private String assignStyleName(StyleDeclaration style) {
        if (style == null || style.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.report.getStyleCount(); ++i) {
            StyleDeclaration cachedStyle = (StyleDeclaration)this.report.getStyle(i);
            if (!cachedStyle.equals(style)) continue;
            style = cachedStyle;
            return "style_" + i;
        }
        String styleName = "style_" + this.report.getStyleCount();
        this.report.addStyle(styleName, style);
        return styleName;
    }

    protected String getElementProperty(ReportElementHandle handle, String name) {
        return this.getElementProperty(handle, name, false);
    }

    protected String getElementProperty(ReportElementHandle handle, String name, boolean isColorProperty) {
        FactoryPropertyHandle prop = handle.getFactoryPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            if (isColorProperty) {
                return prop.getColorValue();
            }
            return prop.getStringValue();
        }
        return null;
    }

    String getElementColorProperty(ReportElementHandle handle, String name) {
        FactoryPropertyHandle prop = handle.getFactoryPropertyHandle(name);
        if (prop != null && prop.isSet()) {
            return prop.getColorValue();
        }
        return null;
    }

    protected StyleDeclaration createPrivateStyle(ReportElementHandle handle) {
        return this.createPrivateStyle(handle, true);
    }

    protected String decodePageBreak(String pageBreak) {
        if (pageBreak == null) {
            return null;
        }
        if ("always".equals(pageBreak)) {
            return "always";
        }
        if ("always-excluding-last".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        if ("always".equals(pageBreak)) {
            return "always";
        }
        if ("always-excluding-first".equals(pageBreak)) {
            return "always";
        }
        if ("auto".equals(pageBreak)) {
            return "auto";
        }
        if ("avoid".equals(pageBreak)) {
            return "avoid";
        }
        return "auto";
    }

    protected StyleDeclaration createPrivateStyle(ReportElementHandle handle, boolean isContainer) {
        StyleDeclaration style = new StyleDeclaration(this.cssEngine);
        style.setBackgroundColor(this.getElementProperty(handle, "backgroundColor", true));
        style.setBackgroundImage(this.getElementProperty(handle, "backgroundImage"));
        style.setBackgroundPositionX(this.getElementProperty(handle, "backgroundPositionX"));
        style.setBackgroundPositionY(this.getElementProperty(handle, "backgroundPositionY"));
        style.setBackgroundRepeat(this.getElementProperty(handle, "backgroundRepeat"));
        style.setTextAlign(this.getElementProperty(handle, "textAlign"));
        style.setTextIndent(this.getElementProperty(handle, "textIndent"));
        style.setTextUnderline(this.getElementProperty(handle, "textUnderline"));
        style.setTextLineThrough(this.getElementProperty(handle, "textLineThrough"));
        style.setTextOverline(this.getElementProperty(handle, "textOverline"));
        style.setLetterSpacing(this.getElementProperty(handle, "letterSpacing"));
        style.setLineHeight(this.getElementProperty(handle, "lineHeight"));
        style.setOrphans(this.getElementProperty(handle, "orphans"));
        style.setTextTransform(this.getElementProperty(handle, "textTransform"));
        style.setVerticalAlign(this.getElementProperty(handle, "verticalAlign"));
        style.setWhiteSpace(this.getElementProperty(handle, "whiteSpace"));
        style.setWidows(this.getElementProperty(handle, "widows"));
        style.setWordSpacing(this.getElementProperty(handle, "wordSpacing"));
        style.setDisplay(this.getElementProperty(handle, "display"));
        style.setMasterPage(this.getElementProperty(handle, "masterPage"));
        String pageBreakAfter = this.getElementProperty(handle, "pageBreakAfter");
        style.setPageBreakAfter(this.decodePageBreak(pageBreakAfter));
        String pageBreakBefore = this.getElementProperty(handle, "pageBreakBefore");
        style.setPageBreakBefore(this.decodePageBreak(pageBreakBefore));
        style.setPageBreakInside(this.getElementProperty(handle, "pageBreakInside"));
        style.setFontFamily(this.getElementProperty(handle, "fontFamily"));
        style.setColor(this.getElementProperty(handle, "color", true));
        style.setFontSize(this.getElementProperty(handle, "fontSize"));
        style.setFontStyle(this.getElementProperty(handle, "fontStyle"));
        style.setFontWeight(this.getElementProperty(handle, "fontWeight"));
        style.setFontVariant(this.getElementProperty(handle, "fontVariant"));
        style.setBorderBottomColor(this.getElementProperty(handle, "borderBottomColor", true));
        style.setBorderBottomStyle(this.getElementProperty(handle, "borderBottomStyle"));
        style.setBorderBottomWidth(this.getElementProperty(handle, "borderBottomWidth"));
        style.setBorderLeftColor(this.getElementProperty(handle, "borderLeftColor", true));
        style.setBorderLeftStyle(this.getElementProperty(handle, "borderLeftStyle"));
        style.setBorderLeftWidth(this.getElementProperty(handle, "borderLeftWidth"));
        style.setBorderRightColor(this.getElementProperty(handle, "borderRightColor", true));
        style.setBorderRightStyle(this.getElementProperty(handle, "borderRightStyle"));
        style.setBorderRightWidth(this.getElementProperty(handle, "borderRightWidth"));
        style.setBorderTopColor(this.getElementProperty(handle, "borderTopColor", true));
        style.setBorderTopStyle(this.getElementProperty(handle, "borderTopStyle"));
        style.setBorderTopWidth(this.getElementProperty(handle, "borderTopWidth"));
        style.setMarginTop(this.getElementProperty(handle, "marginTop"));
        style.setMarginLeft(this.getElementProperty(handle, "marginLeft"));
        style.setMarginBottom(this.getElementProperty(handle, "marginBottom"));
        style.setMarginRight(this.getElementProperty(handle, "marginRight"));
        style.setPaddingTop(this.getElementProperty(handle, "paddingTop"));
        style.setPaddingLeft(this.getElementProperty(handle, "paddingLeft"));
        style.setPaddingBottom(this.getElementProperty(handle, "paddingBottom"));
        style.setPaddingRight(this.getElementProperty(handle, "paddingRight"));
        style.setNumberAlign(this.getElementProperty(handle, "numberAlign"));
        style.setDateFormat(this.getElementProperty(handle, "dateTimeFormat"));
        style.setNumberFormat(this.getElementProperty(handle, "numberFormat"));
        style.setStringFormat(this.getElementProperty(handle, "stringFormat"));
        style.setCanShrink(this.getElementProperty(handle, "canShrink"));
        style.setShowIfBlank(this.getElementProperty(handle, "showIfBlank"));
        return style;
    }

    String getMemberProperty(StructureHandle handle, String name) {
        MemberHandle prop = handle.getMember(name);
        if (prop != null) {
            return prop.getStringValue();
        }
        return null;
    }

    IStyle setupStyle(StructureHandle highlight, IStyle style) {
        style.setBackgroundColor(this.getMemberProperty(highlight, "backgroundColor"));
        style.setTextAlign(this.getMemberProperty(highlight, "textAlign"));
        style.setTextIndent(this.getMemberProperty(highlight, "textIndent"));
        style.setTextUnderline(this.getMemberProperty(highlight, "textUnderline"));
        style.setTextLineThrough(this.getMemberProperty(highlight, "textLineThrough"));
        style.setTextOverline(this.getMemberProperty(highlight, "textOverline"));
        style.setTextTransform(this.getMemberProperty(highlight, "textTransform"));
        style.setFontFamily(this.getMemberProperty(highlight, "fontFamily"));
        style.setColor(this.getMemberProperty(highlight, "color"));
        style.setFontSize(this.getMemberProperty(highlight, "fontSize"));
        style.setFontStyle(this.getMemberProperty(highlight, "fontStyle"));
        style.setFontWeight(this.getMemberProperty(highlight, "fontWeight"));
        style.setFontVariant(this.getMemberProperty(highlight, "fontVariant"));
        style.setBorderBottomColor(this.getMemberProperty(highlight, "borderBottomColor"));
        style.setBorderBottomStyle(this.getMemberProperty(highlight, "borderBottomStyle"));
        style.setBorderBottomWidth(this.getMemberProperty(highlight, "borderBottomWidth"));
        style.setBorderLeftColor(this.getMemberProperty(highlight, "borderLeftColor"));
        style.setBorderLeftStyle(this.getMemberProperty(highlight, "borderLeftStyle"));
        style.setBorderLeftWidth(this.getMemberProperty(highlight, "borderLeftWidth"));
        style.setBorderRightColor(this.getMemberProperty(highlight, "borderRightColor"));
        style.setBorderRightStyle(this.getMemberProperty(highlight, "borderRightStyle"));
        style.setBorderRightWidth(this.getMemberProperty(highlight, "borderRightWidth"));
        style.setBorderTopColor(this.getMemberProperty(highlight, "borderTopColor"));
        style.setBorderTopStyle(this.getMemberProperty(highlight, "borderTopStyle"));
        style.setBorderTopWidth(this.getMemberProperty(highlight, "borderTopWidth"));
        style.setNumberAlign(this.getMemberProperty(highlight, "numberAlign"));
        style.setDateFormat(this.getMemberProperty(highlight, "dateTimeFormat"));
        style.setNumberFormat(this.getMemberProperty(highlight, "numberFormat"));
        style.setStringFormat(this.getMemberProperty(highlight, "stringFormat"));
        return style;
    }

    protected DimensionType createDimension(DimensionHandle handle) {
        if (handle == null || !handle.isSet()) {
            return null;
        }
        if (handle.isKeyword()) {
            return new DimensionType(handle.getStringValue());
        }
        double measure = handle.getMeasure();
        String unit = handle.getUnits();
        if ("".equals(unit)) {
            unit = this.defaultUnit;
        }
        return new DimensionType(measure, unit);
    }

    protected void setupListingItem(ListingDesign listing, ListingHandle handle) {
        this.setupReportItem(listing, (ReportItemHandle)handle);
        listing.setPageBreakInterval(handle.getPageBreakInterval());
    }

    protected void addReportDefaultPropertyValue(String name, StyleHandle handle) {
        this.addReportDefaultPropertyValue(name, handle, false);
    }

    protected void addReportDefaultPropertyValue(String name, StyleHandle handle, boolean isColorProperty) {
        Object value = null;
        int index = StylePropertyMapping.getPropertyID(name);
        if (StylePropertyMapping.canInherit(name)) {
            if (handle != null) {
                value = isColorProperty ? handle.getColorProperty(name).getStringValue() : handle.getProperty(name);
            }
            if (value == null) {
                value = StylePropertyMapping.getDefaultValue(name);
            }
            this.inheritableReportStyle.setCssText(index, value == null ? null : value.toString());
        } else {
            value = StylePropertyMapping.getDefaultValue(name);
            this.nonInheritableReportStyle.setCssText(index, value == null ? null : value.toString());
        }
    }

    protected void createReportDefaultStyles(StyleHandle handle) {
        this.nonInheritableReportStyle = new StyleDeclaration(this.cssEngine);
        this.inheritableReportStyle = new StyleDeclaration(this.cssEngine);
        this.addReportDefaultPropertyValue("backgroundColor", handle, true);
        this.addReportDefaultPropertyValue("backgroundImage", handle);
        this.addReportDefaultPropertyValue("backgroundPositionX", handle);
        this.addReportDefaultPropertyValue("backgroundPositionY", handle);
        this.addReportDefaultPropertyValue("backgroundRepeat", handle);
        this.addReportDefaultPropertyValue("textAlign", handle);
        this.addReportDefaultPropertyValue("textIndent", handle);
        this.addReportDefaultPropertyValue("letterSpacing", handle);
        this.addReportDefaultPropertyValue("lineHeight", handle);
        this.addReportDefaultPropertyValue("orphans", handle);
        this.addReportDefaultPropertyValue("textTransform", handle);
        this.addReportDefaultPropertyValue("verticalAlign", handle);
        this.addReportDefaultPropertyValue("whiteSpace", handle);
        this.addReportDefaultPropertyValue("widows", handle);
        this.addReportDefaultPropertyValue("wordSpacing", handle);
        this.addReportDefaultPropertyValue("display", handle);
        this.addReportDefaultPropertyValue("masterPage", handle);
        this.addReportDefaultPropertyValue("pageBreakAfter", handle);
        this.addReportDefaultPropertyValue("pageBreakBefore", handle);
        this.addReportDefaultPropertyValue("pageBreakInside", handle);
        this.addReportDefaultPropertyValue("fontFamily", handle);
        this.addReportDefaultPropertyValue("color", handle, true);
        this.addReportDefaultPropertyValue("fontSize", handle);
        this.addReportDefaultPropertyValue("fontStyle", handle);
        this.addReportDefaultPropertyValue("fontWeight", handle);
        this.addReportDefaultPropertyValue("fontVariant", handle);
        this.addReportDefaultPropertyValue("textLineThrough", handle);
        this.addReportDefaultPropertyValue("textOverline", handle);
        this.addReportDefaultPropertyValue("textUnderline", handle);
        this.addReportDefaultPropertyValue("borderBottomColor", handle, true);
        this.addReportDefaultPropertyValue("borderBottomStyle", handle);
        this.addReportDefaultPropertyValue("borderBottomWidth", handle);
        this.addReportDefaultPropertyValue("borderLeftColor", handle, true);
        this.addReportDefaultPropertyValue("borderLeftStyle", handle);
        this.addReportDefaultPropertyValue("borderLeftWidth", handle);
        this.addReportDefaultPropertyValue("borderRightColor", handle, true);
        this.addReportDefaultPropertyValue("borderRightStyle", handle);
        this.addReportDefaultPropertyValue("borderRightWidth", handle);
        this.addReportDefaultPropertyValue("borderTopColor", handle, true);
        this.addReportDefaultPropertyValue("borderTopStyle", handle);
        this.addReportDefaultPropertyValue("borderTopWidth", handle);
        this.addReportDefaultPropertyValue("marginTop", handle);
        this.addReportDefaultPropertyValue("marginLeft", handle);
        this.addReportDefaultPropertyValue("marginBottom", handle);
        this.addReportDefaultPropertyValue("marginRight", handle);
        this.addReportDefaultPropertyValue("paddingTop", handle);
        this.addReportDefaultPropertyValue("paddingLeft", handle);
        this.addReportDefaultPropertyValue("paddingBottom", handle);
        this.addReportDefaultPropertyValue("paddingRight", handle);
        this.report.setRootStyleName(this.assignStyleName(this.inheritableReportStyle));
    }

    protected String setupBodyStyle(MasterPageDesign design) {
        String styleName = design.getStyleName();
        IStyle style = this.report.findStyle(styleName);
        if (style == null || style.isEmpty()) {
            return null;
        }
        StyleDeclaration contentStyle = new StyleDeclaration(this.cssEngine);
        contentStyle.setProperty(20, style.getProperty(20));
        contentStyle.setProperty(9, style.getProperty(9));
        contentStyle.setProperty(35, style.getProperty(35));
        contentStyle.setProperty(45, style.getProperty(45));
        contentStyle.setProperty(3, style.getProperty(3));
        String bodyStyleName = this.assignStyleName(contentStyle);
        return bodyStyleName;
    }

    private void setupElementIDMap(ReportElementDesign rptElement) {
        this.report.setReportItemInstanceID(rptElement.getID(), rptElement);
    }

    protected long generateUniqueID() {
        return this.newCellId--;
    }

    static {
        $assertionsDisabled = !EngineIRVisitor.class.desiredAssertionStatus();
        logger = Logger.getLogger(EngineIRVisitor.class.getName());
    }
}

