/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAOutputStream;

public class FolderArchiveWriter
implements IDocArchiveWriter {
    private String folderName;
    private IStreamSorter streamSorter = null;
    private LinkedList openStreams = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FolderArchiveWriter(String folderName) throws IOException {
        if (folderName == null || folderName.length() == 0) {
            throw new IOException("The folder name is null or empty string.");
        }
        File fd = new File(folderName);
        this.folderName = folderName = fd.getCanonicalPath();
    }

    public void initialize() {
        new File(this.folderName).mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAOutputStream createRandomAccessStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        ArchiveUtil.createParentFolder(fd);
        RAFolderOutputStream out = new RAFolderOutputStream(this, fd);
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.add(out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAOutputStream openRandomAccessStream(String relativePath) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        ArchiveUtil.createParentFolder(fd);
        RAFolderOutputStream out = new RAFolderOutputStream(this, fd, true);
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.add(out);
        }
        return out;
    }

    public boolean dropStream(String relativePath) {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        return this.removeFileAndFolder(fd);
    }

    public String getName() {
        return this.folderName;
    }

    public boolean exists(String relativePath) {
        String path = ArchiveUtil.generateFullPath(this.folderName, relativePath);
        File fd = new File(path);
        return fd.exists();
    }

    public void setStreamSorter(IStreamSorter streamSorter) {
        this.streamSorter = streamSorter;
    }

    public void finish() throws IOException {
        this.closeAllStream();
    }

    public void toFileArchive(String fileArchiveName) throws IOException {
        ArchiveUtil.archive(this.folderName, this.streamSorter, fileArchiveName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        IOException ioex = null;
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            Iterator iter = this.openStreams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.flush();
                }
                catch (IOException ex) {
                    ioex = ex;
                }
            }
        }
        if (ioex != null) {
            throw ioex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStream(RAFolderOutputStream stream) {
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            this.openStreams.remove(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllStream() {
        LinkedList linkedList = this.openStreams;
        synchronized (linkedList) {
            LinkedList streams = new LinkedList(this.openStreams);
            Iterator iter = streams.iterator();
            while (iter.hasNext()) {
                RAFolderOutputStream stream = (RAFolderOutputStream)iter.next();
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException ex) {}
            }
            this.openStreams.clear();
        }
    }

    private boolean removeFileAndFolder(File file) {
        File[] children;
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                this.removeFileAndFolder(children[i]);
            }
        }
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public Object lock(String stream) throws IOException {
        String path = ArchiveUtil.generateFullPath(this.folderName, stream + ".lck");
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    public void unlock(Object lock) {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(lock);
    }

    static {
        $assertionsDisabled = !FolderArchiveWriter.class.desiredAssertionStatus();
    }
}

