/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.internal.adapter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.BaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.internal.adapter.ColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ComputedColumnAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.FilterAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.InputParamBindingAdapter;
import org.eclipse.birt.report.data.adapter.internal.adapter.ParameterAdapter;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;

class DataAdapterUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    DataAdapterUtil() {
    }

    public static void adaptBaseDataSource(DataSourceHandle source, BaseDataSourceDesign dest) {
        dest.setBeforeOpenScript(source.getBeforeOpen());
        dest.setAfterOpenScript(source.getAfterOpen());
        dest.setBeforeCloseScript(source.getBeforeClose());
        dest.setAfterCloseScript(source.getAfterClose());
    }

    public static void adaptBaseDataSet(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) throws BirtException {
        if (!(modelDataSet instanceof JointDataSetHandle) && modelDataSet.getDataSource() == null) {
            throw new AdapterException("datasource.null.error");
        }
        if (!(modelDataSet instanceof JointDataSetHandle)) {
            dteDataSet.setDataSource(modelDataSet.getDataSource().getQualifiedName());
            dteDataSet.setBeforeOpenScript(modelDataSet.getBeforeOpen());
            dteDataSet.setAfterOpenScript(modelDataSet.getAfterOpen());
            dteDataSet.setOnFetchScript(modelDataSet.getOnFetch());
            dteDataSet.setBeforeCloseScript(modelDataSet.getBeforeClose());
            dteDataSet.setAfterCloseScript(modelDataSet.getAfterClose());
        }
        DataAdapterUtil.populateParameter(modelDataSet, dteDataSet);
        DataAdapterUtil.populateComputedColumn(modelDataSet, dteDataSet);
        DataAdapterUtil.populateFilter(modelDataSet, dteDataSet);
        DataAdapterUtil.mergeHints(modelDataSet, dteDataSet);
        dteDataSet.setRowFetchLimit(modelDataSet.getRowFetchLimit());
    }

    private static void populateParameter(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        HashMap<String, String> paramBindingCandidates = new HashMap<String, String>();
        Iterator elmtIter = modelDataSet.parametersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                DataSetParameterHandle modelParam = (DataSetParameterHandle)elmtIter.next();
                dteDataSet.addParameter((IParameterDefinition)new ParameterAdapter(modelParam));
                if (!modelParam.isInput()) continue;
                String defaultValueExpr = null;
                defaultValueExpr = modelParam instanceof OdaDataSetParameterHandle && ((OdaDataSetParameterHandle)modelParam).getParamName() != null ? ExpressionUtil.createJSParameterExpression((String)((OdaDataSetParameterHandle)modelParam).getParamName()) : modelParam.getDefaultValue();
                if (defaultValueExpr == null) continue;
                paramBindingCandidates.put(modelParam.getName(), defaultValueExpr);
            }
        }
        if ((elmtIter = modelDataSet.paramBindingsIterator()) != null) {
            while (elmtIter.hasNext()) {
                ParamBindingHandle modelParamBinding = (ParamBindingHandle)elmtIter.next();
                paramBindingCandidates.put(modelParamBinding.getParamName(), modelParamBinding.getExpression());
            }
        }
        if (paramBindingCandidates.size() > 0) {
            elmtIter = paramBindingCandidates.keySet().iterator();
            while (elmtIter.hasNext()) {
                Object paramName = elmtIter.next();
                if (!($assertionsDisabled || paramName != null && paramName instanceof String)) {
                    throw new AssertionError();
                }
                String expression = (String)paramBindingCandidates.get(paramName);
                dteDataSet.addInputParamBinding((IInputParameterBinding)new InputParamBindingAdapter((String)paramName, expression));
            }
        }
    }

    private static void populateComputedColumn(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        Iterator elmtIter = modelDataSet.computedColumnsIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                ComputedColumnHandle modelCmptdColumn = (ComputedColumnHandle)elmtIter.next();
                dteDataSet.addComputedColumn((IComputedColumn)new ComputedColumnAdapter(modelCmptdColumn));
            }
        }
    }

    private static void populateFilter(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        Iterator elmtIter = modelDataSet.filtersIterator();
        if (elmtIter != null) {
            while (elmtIter.hasNext()) {
                FilterConditionHandle modelFilter = (FilterConditionHandle)elmtIter.next();
                dteDataSet.addFilter((IFilterDefinition)new FilterAdapter(modelFilter));
            }
        }
    }

    private static void mergeHints(DataSetHandle modelDataSet, BaseDataSetDesign dteDataSet) {
        OdaResultSetColumnHandle modelColumn;
        Iterator elmtIter;
        if (modelDataSet instanceof OdaDataSetHandle) {
            elmtIter = modelDataSet.resultSetIterator();
            if (elmtIter != null) {
                while (elmtIter.hasNext()) {
                    modelColumn = (OdaResultSetColumnHandle)elmtIter.next();
                    if (modelColumn.getColumnName().equals(modelColumn.getNativeName())) continue;
                    dteDataSet.addResultSetHint((IColumnDefinition)new ColumnAdapter((ResultSetColumnHandle)modelColumn));
                }
            }
        } else {
            elmtIter = modelDataSet.resultSetHintsIterator();
            if (elmtIter != null) {
                while (elmtIter.hasNext()) {
                    modelColumn = (ResultSetColumnHandle)elmtIter.next();
                    dteDataSet.addResultSetHint((IColumnDefinition)new ColumnAdapter((ResultSetColumnHandle)modelColumn));
                }
            }
        }
        if ((elmtIter = modelDataSet.columnHintsIterator()) != null) {
            List columnDefns = dteDataSet.getResultSetHints();
            while (elmtIter.hasNext()) {
                ColumnHintHandle modelColumnHint = (ColumnHintHandle)elmtIter.next();
                ColumnDefinition existDefn = DataAdapterUtil.findColumnDefn(columnDefns, modelColumnHint.getColumnName());
                if (existDefn != null) {
                    DataAdapterUtil.updateColumnDefn(existDefn, modelColumnHint);
                    continue;
                }
                dteDataSet.addResultSetHint((IColumnDefinition)new ColumnAdapter(modelColumnHint));
            }
        }
    }

    public static void updateColumnDefn(ColumnDefinition dteColumn, ColumnHintHandle modelColumnHint) {
        String searchConstant;
        if (!$assertionsDisabled && !dteColumn.getColumnName().equals(modelColumnHint.getColumnName())) {
            throw new AssertionError();
        }
        dteColumn.setAlias(modelColumnHint.getAlias());
        String exportConstant = modelColumnHint.getExport();
        if (exportConstant != null) {
            int exportHint = 1;
            if (exportConstant.equals("if-realized")) {
                exportHint = 2;
            } else if (exportConstant.equals("always")) {
                exportHint = 3;
            } else if (!$assertionsDisabled && !exportConstant.equals("none")) {
                throw new AssertionError();
            }
            dteColumn.setExportHint(exportHint);
        }
        if ((searchConstant = modelColumnHint.getSearching()) != null) {
            int searchHint = 3;
            if (searchConstant.equals("indexed")) {
                searchHint = 2;
            } else if (searchConstant.equals("any")) {
                searchHint = 1;
            } else if (!$assertionsDisabled && !searchConstant.equals("none")) {
                throw new AssertionError();
            }
            dteColumn.setSearchHint(searchHint);
        }
    }

    private static ColumnDefinition findColumnDefn(List columnDefns, String columnName) {
        if (!$assertionsDisabled && columnName == null) {
            throw new AssertionError();
        }
        if (columnDefns == null) {
            return null;
        }
        Iterator iter = columnDefns.iterator();
        if (iter == null) {
            return null;
        }
        while (iter.hasNext()) {
            ColumnDefinition column = (ColumnDefinition)iter.next();
            if (!columnName.equals(column.getColumnName())) continue;
            return column;
        }
        return null;
    }

    public static Map getExtensionProperties(ReportElementHandle dataHandle, List driverPropList) {
        if (driverPropList == null || driverPropList.isEmpty()) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Iterator elmtIter = driverPropList.iterator();
        while (elmtIter.hasNext()) {
            IPropertyDefn modelExtProp = (IPropertyDefn)elmtIter.next();
            String propName = modelExtProp.getName();
            if (!($assertionsDisabled || propName != null && propName.length() > 0)) {
                throw new AssertionError();
            }
            Object propValueObj = dataHandle.getProperty(modelExtProp.getName());
            String propValue = propValueObj == null ? null : propValueObj.toString();
            properties.put(propName, propValue);
        }
        return properties;
    }

    static {
        $assertionsDisabled = !DataAdapterUtil.class.desiredAssertionStatus();
    }
}

