/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.image;

import com.ibm.icu.util.ULocale;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.image.IOUtil;

class Chunk {
    static final String CHUNK_IHDR = "IHDR";
    static final String CHUNK_PLTE = "PLTE";
    static final String CHUNK_TRNS = "tRNS";
    static final String CHUNK_IDAT = "IDAT";
    static final String CHUNK_IEND = "IEND";
    private ByteArrayOutputStream data;
    private String type;

    Chunk(String type) {
        this.type = type;
        if (type == null || type.length() != 4) {
            throw new IllegalArgumentException(Messages.getString("Chunk.exception.invalid.png.chunk", new Object[]{type}, ULocale.getDefault()));
        }
        this.data = new ByteArrayOutputStream();
    }

    void write(int value) {
        this.data.write(Chunk.intToBytes(value), 0, 4);
    }

    void writeInt(int value) {
        this.write(value);
    }

    void write(short value) {
        this.data.write((value & 0xFF) >>> 8);
        this.data.write(value & 0xFF);
    }

    void writeShort(int value) {
        this.write((short)value);
    }

    void write(byte value) {
        this.data.write(value);
    }

    void writeByte(int value) {
        this.write((byte)value);
    }

    void write(byte[] block) {
        this.data.write(block, 0, block.length);
    }

    ByteArrayOutputStream getDataStream() {
        return this.data;
    }

    void output(OutputStream out) throws IOException {
        CRC32 crc = new CRC32();
        byte[] dataBytes = this.data.toByteArray();
        byte[] lenBytes = Chunk.intToBytes(dataBytes.length);
        out.write(lenBytes);
        for (int i = 0; i < 4; ++i) {
            crc.update(this.type.charAt(i));
            out.write(this.type.charAt(i));
        }
        crc.update(dataBytes);
        out.write(dataBytes);
        out.write(Chunk.intToBytes((int)crc.getValue()));
    }

    private static byte[] intToBytes(int value) {
        byte[] ret = new byte[]{(byte)((value & 0xFF000000) >>> 24), (byte)((value & 0xFF0000) >>> 16), (byte)((value & 0xFF00) >>> 8), (byte)(value & 0xFF)};
        return ret;
    }

    void close() {
        IOUtil.close(this.data);
        this.data = null;
    }
}

