/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;
import org.eclipse.birt.core.archive.compound.NameEntry;

class ArchiveEntryV2
extends ArchiveEntry
implements ArchiveConstants {
    protected final int BLOCK_SIZE;
    protected int cachId;
    protected ArchiveFileV2 af;
    protected NameEntry entry;
    protected AllocEntry index;

    ArchiveEntryV2(ArchiveFileV2 af, NameEntry entry) throws IOException {
        this.af = af;
        this.BLOCK_SIZE = af.BLOCK_SIZE;
        this.entry = entry;
        this.cachId = entry.getBlock();
        if (this.cachId != -1) {
            this.index = af.allocTbl.loadEntry(this.cachId);
        }
    }

    public long getLength() throws IOException {
        return this.entry.getLength();
    }

    public void setLength(long length) throws IOException {
        this.ensureSize(length);
        this.entry.setLength(length);
    }

    public void flush() throws IOException {
    }

    public void refresh() throws IOException {
    }

    public Object lock() throws IOException {
        return this.af.lockEntry(this);
    }

    public void unlock(Object lock) throws IOException {
        this.af.unlockEntry(lock);
    }

    public int read(long pos, byte[] b, int off, int len) throws IOException {
        int remainSize;
        long length = this.entry.getLength();
        if (pos >= length) {
            return -1;
        }
        if (pos + (long)len > length) {
            len = (int)(length - pos);
        }
        if (len == 0) {
            return 0;
        }
        int blockId = (int)(pos / (long)this.BLOCK_SIZE);
        int blockOff = (int)(pos % (long)this.BLOCK_SIZE);
        int readSize = this.BLOCK_SIZE - blockOff;
        if (len < readSize) {
            readSize = len;
        }
        int phyBlockId = this.index.getBlock(blockId);
        this.af.read(phyBlockId, blockOff, b, off, readSize);
        for (remainSize = len - readSize; remainSize >= this.BLOCK_SIZE; remainSize -= this.BLOCK_SIZE) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.read(phyBlockId, 0, b, off + readSize, this.BLOCK_SIZE);
            readSize += this.BLOCK_SIZE;
        }
        if (remainSize > 0) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.read(phyBlockId, 0, b, off + readSize, remainSize);
            readSize += remainSize;
        }
        return readSize;
    }

    public void write(long pos, byte[] b, int off, int len) throws IOException {
        long offset;
        long length;
        int remainSize;
        this.ensureSize(pos + (long)len);
        if (len == 0) {
            return;
        }
        int blockId = (int)(pos / (long)this.BLOCK_SIZE);
        int phyBlockId = this.index.getBlock(blockId);
        int blockOff = (int)(pos % (long)this.BLOCK_SIZE);
        int writeSize = this.BLOCK_SIZE - blockOff;
        if (len < writeSize) {
            writeSize = len;
        }
        this.af.write(phyBlockId, blockOff, b, off, writeSize);
        for (remainSize = len - writeSize; remainSize >= this.BLOCK_SIZE; remainSize -= this.BLOCK_SIZE) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.write(phyBlockId, 0, b, off + writeSize, this.BLOCK_SIZE);
            writeSize += this.BLOCK_SIZE;
        }
        if (remainSize > 0) {
            phyBlockId = this.index.getBlock(++blockId);
            this.af.write(phyBlockId, 0, b, off + writeSize, remainSize);
        }
        if ((length = this.entry.getLength()) < (offset = pos + (long)len)) {
            this.setLength(offset);
        }
    }

    protected void ensureSize(long newLength) throws IOException {
        int totalBlock;
        int blockCount;
        if (this.index == null) {
            this.index = this.af.allocTbl.createEntry();
            this.entry.setBlock(this.index.getFirstBlock());
        }
        if ((blockCount = (int)((newLength + (long)this.BLOCK_SIZE - 1L) / (long)this.BLOCK_SIZE)) > (totalBlock = this.index.getTotalBlocks())) {
            while (totalBlock < blockCount) {
                int freeBlock = this.af.allocTbl.getFreeBlock();
                this.index.appendBlock(freeBlock);
                ++totalBlock;
            }
        }
    }
}

