/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveEntryInputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;

public class ArchiveReader
implements IDocArchiveReader {
    protected ArchiveFile archive;
    protected boolean shareArchive;

    public ArchiveReader(ArchiveFile archive) throws IOException {
        this.shareArchive = true;
        this.archive = archive;
    }

    public ArchiveReader(String archiveName) throws IOException {
        if (archiveName == null || archiveName.length() == 0) {
            throw new IOException("The file archive name is null or empty string.");
        }
        File fd = new File(archiveName);
        if (!fd.isFile()) {
            throw new IOException("The specified name is not a file name. The FileArchiveReader is expecting a valid file archive name.");
        }
        if (!fd.exists()) {
            throw new IOException("The specified file do not exist.");
        }
        archiveName = fd.getCanonicalPath();
        this.shareArchive = false;
        this.archive = new ArchiveFile(archiveName, "r");
    }

    public void close() throws IOException {
        if (!this.shareArchive) {
            this.archive.close();
        }
    }

    public ArchiveFile getArchive() {
        return this.archive;
    }

    public boolean exists(String relativePath) {
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = ArchiveUtil.UNIX_SEPERATOR + relativePath;
        }
        return this.archive.exists(relativePath);
    }

    public String getName() {
        return this.archive.getName();
    }

    public RAInputStream getStream(String relativePath) throws IOException {
        ArchiveEntry entry;
        if (!relativePath.startsWith(ArchiveUtil.UNIX_SEPERATOR)) {
            relativePath = ArchiveUtil.UNIX_SEPERATOR + relativePath;
        }
        if ((entry = this.archive.getEntry(relativePath)) != null) {
            return new ArchiveEntryInputStream(entry);
        }
        throw new IOException(relativePath + " doesn't exist");
    }

    public List listAllStreams() throws IOException {
        ArrayList list = new ArrayList();
        list.addAll(this.archive.listEntries("/"));
        return list;
    }

    public List listStreams(String namePattern) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = this.archive.listEntries("/").iterator();
        while (iter.hasNext()) {
            String diffString;
            String name = (String)iter.next();
            if (!name.startsWith(namePattern) || name.equalsIgnoreCase(namePattern) || (diffString = ArchiveUtil.generateRelativePath(namePattern, name)).lastIndexOf(ArchiveUtil.UNIX_SEPERATOR) != 0) continue;
            list.add(name);
        }
        return list;
    }

    public void open() throws IOException {
    }

    public Object lock(String stream) throws IOException {
        ArchiveEntry entry = this.archive.getEntry(stream);
        if (entry != null) {
            return this.archive.lockEntry(entry);
        }
        throw new IOException("can't find the entry " + stream);
    }

    public void unlock(Object locker) {
        try {
            this.archive.unlockEntry(locker);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

