/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentStreamSorter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.ir.EngineIRWriter;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCTree;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.util.DocumentUtil;

public class ReportDocumentWriter
implements ReportDocumentConstants {
    private static Logger logger = Logger.getLogger(ReportDocumentWriter.class.getName());
    protected IReportEngine engine;
    private IDocArchiveWriter archive;
    private String designName;
    private HashMap paramters = new HashMap();
    private HashMap globalVariables = new HashMap();
    private int checkpoint = 0;
    private long pageCount = 0L;
    private HashMap bookmarks = new HashMap();
    private TOCTree tocTree = null;
    private HashMap idToOffset = new HashMap();
    private HashMap bookmarkToOffset = new HashMap();

    public ReportDocumentWriter(IReportEngine engine, IDocArchiveWriter archive) {
        this.engine = engine;
        this.archive = archive;
        try {
            archive.initialize();
            this.saveCoreStreams();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in initializing the archive", e);
        }
    }

    public IDocArchiveWriter getArchive() {
        return this.archive;
    }

    public void close() {
        try {
            this.checkpoint = -1;
            this.saveCoreStreams();
            this.archive.setStreamSorter((IStreamSorter)new ReportDocumentStreamSorter());
            this.archive.finish();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in close the archive", e);
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    public void saveTOC(TOCTree tocTree) {
        this.tocTree = tocTree;
    }

    public void saveBookmarks(HashMap bookmarks) {
        if (bookmarks.isEmpty()) {
            return;
        }
        this.bookmarks = new HashMap();
        this.bookmarks.putAll(bookmarks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDesign(ReportRunnable runnable) {
        RAOutputStream out;
        block19: {
            block18: {
                out = null;
                ReportDesignHandle design = runnable.getReport();
                out = this.archive.createRandomAccessStream("/design");
                DocumentUtil.serialize((ReportDesignHandle)design, (OutputStream)out);
                this.designName = design.getFileName();
                Object var5_6 = null;
                if (out == null) break block18;
                try {
                    out.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            out = null;
            {
                break block19;
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Failed to save design!", ex);
                    Object var5_7 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    out = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                out = null;
                throw throwable;
            }
        }
        Report reportIR = runnable.getReportIR();
        out = this.archive.createRandomAccessStream("/design.ir");
        new EngineIRWriter().write((OutputStream)out, reportIR);
        Object var8_13 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex3) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save design IR!", ex);
                Object var8_14 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex3) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void saveParamters(HashMap map) {
        this.paramters = new HashMap();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            ParameterAttribute valueObj = (ParameterAttribute)entry.getValue();
            Object value = valueObj.getValue();
            String display = valueObj.getDisplayText();
            this.paramters.put(key, new Object[]{value, display});
        }
    }

    public void savePersistentObjects(Map map) {
        this.globalVariables = new HashMap();
        this.globalVariables.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCoreStreams() throws Exception {
        Object lock = this.archive.lock("/core");
        try {
            Object object = lock;
            synchronized (object) {
                this.doSaveCoreStreams();
            }
        }
        finally {
            this.archive.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSaveCoreStreams() throws Exception {
        RAOutputStream out = null;
        DataOutputStream coreStream = null;
        out = this.archive.createRandomAccessStream("/core");
        coreStream = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
        IOUtil.writeString((DataOutputStream)coreStream, (String)"reportdocument");
        IOUtil.writeString((DataOutputStream)coreStream, (String)"CORE_VERSION_0");
        IOUtil.writeString((DataOutputStream)coreStream, (String)"2.1.3-2.2RC0");
        if (this.checkpoint != -1) {
            ++this.checkpoint;
        }
        IOUtil.writeInt((OutputStream)coreStream, (int)this.checkpoint);
        IOUtil.writeLong((DataOutputStream)coreStream, (long)this.pageCount);
        IOUtil.writeString((DataOutputStream)coreStream, (String)this.designName);
        IOUtil.writeMap((DataOutputStream)coreStream, (Map)this.paramters);
        IOUtil.writeMap((DataOutputStream)coreStream, (Map)this.globalVariables);
        if (this.checkpoint == -1) {
            this.writeMap(coreStream, this.bookmarks);
            TOCBuilder.write(this.tocTree, coreStream);
            this.writeMap(coreStream, this.idToOffset);
            this.writeMap(coreStream, this.bookmarkToOffset);
        }
        coreStream.flush();
        Object var5_3 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Failed to save the core stream!", ex);
                Object var5_4 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                out = null;
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private void writeMap(DataOutputStream stream, HashMap map) throws Exception {
        IOUtil.writeLong((DataOutputStream)stream, (long)map.size());
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Long value = (Long)entry.getValue();
            IOUtil.writeString((DataOutputStream)stream, (String)key);
            IOUtil.writeLong((DataOutputStream)stream, (long)value);
        }
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public void saveReprotletsBookmarkIndex(Map bookmarkToOffset) {
        this.bookmarkToOffset = new HashMap();
        this.bookmarkToOffset.putAll(bookmarkToOffset);
    }

    public void saveReportletsIdIndex(Map idToOffset) {
        this.idToOffset = new HashMap();
        this.idToOffset.putAll(idToOffset);
    }
}

