/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.ContainerContent;
import org.eclipse.birt.report.engine.content.impl.DataContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.content.impl.LabelContent;
import org.eclipse.birt.report.engine.content.impl.ListBandContent;
import org.eclipse.birt.report.engine.content.impl.ListContent;
import org.eclipse.birt.report.engine.content.impl.ListGroupContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableBandContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.content.impl.TableGroupContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.toc.TOCTree;

public class ReportContent
implements IReportContent {
    private CSSEngine cssEngine;
    private Report report;
    private ArrayList errors = new ArrayList();
    private TOCTree tocTree;
    private IContent root;
    private long totalPage;

    public ReportContent(Report report) {
        this.cssEngine = report.getCSSEngine();
        this.report = report;
        this.root = this.createContainerContent();
        this.root.setStyleClass(report.getRootStyleName());
    }

    public ReportContent() {
        this.cssEngine = new BIRTCSSEngine();
    }

    public Report getDesign() {
        return this.report;
    }

    public IStyle findStyle(String styleClass) {
        return this.report == null ? null : this.report.findStyle(styleClass);
    }

    public CSSEngine getCSSEngine() {
        return this.cssEngine;
    }

    public IContent getRoot() {
        return this.root;
    }

    public IPageContent getPageContent(long pageNumber) {
        return null;
    }

    public long getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public IContent getContent(InstanceID id) {
        return null;
    }

    public IHyperlinkAction createActionContent() {
        return new ActionContent();
    }

    public IStyle createStyle() {
        return new StyleDeclaration(this.cssEngine);
    }

    public ICellContent createCellContent() {
        return new CellContent(this);
    }

    public IContainerContent createContainerContent() {
        return new ContainerContent(this);
    }

    public IPageContent createPageContent() {
        return new PageContent(this);
    }

    public IRowContent createRowContent() {
        return new RowContent(this);
    }

    public IListContent createListContent() {
        return new ListContent(this);
    }

    public IListGroupContent createListGroupContent() {
        return new ListGroupContent(this);
    }

    public IListBandContent createListBandContent() {
        return new ListBandContent(this);
    }

    public ITableContent createTableContent() {
        return new TableContent(this);
    }

    public ITableGroupContent createTableGroupContent() {
        return new TableGroupContent(this);
    }

    public ITableBandContent createTableBandContent() {
        return new TableBandContent(this);
    }

    public ITextContent createTextContent() {
        return new TextContent(this);
    }

    public ITextContent createTextContent(IContent content) {
        return new TextContent(content);
    }

    public IDataContent createDataContent() {
        return new DataContent(this);
    }

    public IDataContent createDataContent(IContent content) {
        return new DataContent(content);
    }

    public ILabelContent createLabelContent() {
        return new LabelContent(this);
    }

    public ILabelContent createLabelContent(IContent content) {
        return new LabelContent(content);
    }

    public IAutoTextContent createAutoTextContent() {
        return new AutoTextContent(this);
    }

    public IForeignContent createForeignContent() {
        return new ForeignContent(this);
    }

    public IForeignContent createForeignContent(IContent content) {
        return new ForeignContent(content);
    }

    public IImageContent createImageContent() {
        return new ImageContent(this);
    }

    public IImageContent createImageContent(IContent content) {
        return new ImageContent(content);
    }

    public List getErrors() {
        return this.errors;
    }

    public ITOCTree getTOCTree(String format, ULocale locale) {
        if (this.tocTree == null) {
            this.tocTree = new TOCTree();
        }
        return new TOCTree(this.tocTree.getTOCRoot(), format, locale);
    }

    public void setTOCTree(TOCTree tocTree) {
        this.tocTree = tocTree;
    }

    public TOCNode getTOC() {
        return this.getTOCTree("viewer", ULocale.getDefault()).getRoot();
    }
}

