/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;

public abstract class AbstractReportContentWriter
implements IReportContentWriter {
    protected static Logger logger = Logger.getLogger(IReportContentWriter.class.getName());

    public long writeFullContent(IContent content) throws IOException {
        long offset = this.getOffset();
        new ContentWriterVisitor().write(content, this);
        return offset;
    }

    private class ContentWriterVisitor
    extends ContentVisitorAdapter {
        private ContentWriterVisitor() {
        }

        public void write(IContent content, IReportContentWriter writer) {
            this.visit(content, writer);
        }

        public Object visitContent(IContent content, Object value) {
            IReportContentWriter writer = (IReportContentWriter)value;
            try {
                writer.writeContent(content);
                Iterator iter = content.getChildren().iterator();
                while (iter.hasNext()) {
                    IContent child = (IContent)iter.next();
                    this.visitContent(child, value);
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "write content failed");
            }
            return value;
        }

        public Object visitPage(IPageContent page, Object value) {
            IReportContentWriter writer = (IReportContentWriter)value;
            try {
                IContent content;
                writer.writeContent(page);
                Iterator iter = page.getHeader().iterator();
                while (iter.hasNext()) {
                    content = (IContent)iter.next();
                    this.visitContent(content, value);
                }
                iter = page.getFooter().iterator();
                while (iter.hasNext()) {
                    content = (IContent)iter.next();
                    this.visitContent(content, value);
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "write content failed");
            }
            return value;
        }
    }
}

