/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v1;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.internal.document.IPageHintReader;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;

public class PageHintReaderV1
implements IPageHintReader {
    protected IReportDocument document;
    ArrayList pageHints = new ArrayList();

    public PageHintReaderV1(IReportDocument document) throws IOException {
        this.document = document;
        IDocArchiveReader reader = document.getArchive();
        RAInputStream in = reader.getStream("/pages");
        try {
            DataInputStream di = new DataInputStream(new BufferedInputStream((InputStream)in));
            long pageCount = IOUtil.readLong((DataInputStream)di);
            for (long i = 0L; i < pageCount; ++i) {
                PageHint hint = this.readPageHint(di);
                this.pageHints.add(hint);
            }
        }
        catch (IOException ex) {
            in.close();
            throw ex;
        }
    }

    public int getVersion() {
        return 0;
    }

    public void close() {
    }

    public long getTotalPage() throws IOException {
        return this.pageHints.size();
    }

    public IPageHint getPageHint(long pageNumber) throws IOException {
        return (IPageHint)this.pageHints.get((int)pageNumber);
    }

    public long findPage(long offset) throws IOException {
        for (int i = 0; i < this.pageHints.size(); ++i) {
            IPageHint hint = (IPageHint)this.pageHints.get(i);
            PageSection section = hint.getSection(0);
            if (section.startOffset <= offset) continue;
            return i + 1;
        }
        return this.pageHints.size();
    }

    private PageHint readPageHint(DataInputStream in) throws IOException {
        long pageNumber = IOUtil.readLong((DataInputStream)in);
        long pageOffset = IOUtil.readLong((DataInputStream)in);
        PageHint hint = new PageHint(pageNumber, pageOffset);
        PageSection section = new PageSection();
        section.startOffset = IOUtil.readLong((DataInputStream)in);
        section.endOffset = IOUtil.readLong((DataInputStream)in);
        hint.addSection(section);
        return hint;
    }
}

