/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v2;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageSection;

public class PageHintWriterV2
implements IPageHintWriter {
    protected IDocArchiveWriter writer;
    protected RAOutputStream indexStream;
    protected RAOutputStream hintsStream;
    private ByteArrayOutputStream writeBuffer = new ByteArrayOutputStream();
    private DataOutputStream hintBuffer = new DataOutputStream(this.writeBuffer);

    public PageHintWriterV2(IDocArchiveWriter writer) throws IOException {
        this.writer = writer;
        try {
            this.hintsStream = writer.createRandomAccessStream("/pages");
            this.hintsStream.writeInt(2);
            this.indexStream = writer.createRandomAccessStream("/pages_index");
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writePageHint(IPageHint pageHint) throws IOException {
        long offset = this.hintsStream.getOffset();
        this.indexStream.seek(pageHint.getPageNumber() * 8L);
        this.indexStream.writeLong(offset);
        this.writeBuffer.reset();
        this.writePageHint(this.hintBuffer, pageHint);
        this.hintsStream.write(this.writeBuffer.toByteArray());
    }

    public void writeTotalPage(long totalPage) throws IOException {
        this.indexStream.seek(0L);
        this.indexStream.writeLong(totalPage);
    }

    protected void writePageHint(DataOutputStream out, IPageHint hint) throws IOException {
        IOUtil.writeLong((DataOutputStream)out, (long)hint.getPageNumber());
        IOUtil.writeLong((DataOutputStream)out, (long)hint.getOffset());
        int sectionCount = hint.getSectionCount();
        IOUtil.writeInt((OutputStream)out, (int)sectionCount);
        for (int i = 0; i < sectionCount; ++i) {
            PageSection section = hint.getSection(i);
            this.writeInstanceIndex(out, section.starts);
            this.writeInstanceIndex(out, section.ends);
        }
    }

    protected void writeInstanceIndex(DataOutputStream out, InstanceIndex[] indexes) throws IOException {
        if (indexes == null) {
            IOUtil.writeInt((OutputStream)out, (int)0);
            return;
        }
        IOUtil.writeInt((OutputStream)out, (int)indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            IOUtil.writeString((DataOutputStream)out, (String)indexes[i].getInstanceID().toString());
            IOUtil.writeLong((DataOutputStream)out, (long)indexes[i].getOffset());
        }
    }
}

