/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ListingElementExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ListingElementExecutorUtil;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class GroupExecutor
extends ContainerExecutor {
    private ListingElementExecutor listingExecutor = null;
    private ReportItemDesign[] executableElements = null;
    private int totalElements = 0;
    private int currentElement = 0;
    private ListingElementExecutorUtil executorUtil = null;

    protected GroupExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    public void close() {
        this.listingExecutor = null;
        this.executableElements = null;
        this.totalElements = 0;
        this.currentElement = 0;
        this.executorUtil = null;
        super.close();
    }

    void setLisingExecutor(ListingElementExecutor executor) {
        this.listingExecutor = executor;
        this.rset = this.listingExecutor.rset;
    }

    ListingElementExecutor getListingExecutor() {
        return this.listingExecutor;
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        if (this.currentElement >= this.totalElements) {
            this.collectExecutables();
        }
        if (this.currentElement < this.totalElements) {
            ReportItemDesign childDesign = this.executableElements[this.currentElement];
            ++this.currentElement;
            ReportItemExecutor childExecutor = this.manager.createExecutor(this, childDesign, offset);
            if (childExecutor instanceof GroupExecutor) {
                GroupExecutor groupExecutor = (GroupExecutor)childExecutor;
                groupExecutor.setLisingExecutor(this.listingExecutor);
            }
            return childExecutor;
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID iid, long offset) throws Exception {
        long uid = iid.getUniqueID();
        DataID dataId = iid.getDataID();
        long rowId = dataId.getRowID();
        long rsetPosition = this.rset.getCurrentPosition();
        if (rsetPosition == rowId) {
            if (this.currentElement >= this.totalElements) {
                this.collectExecutables(uid == 0L, true);
            }
        } else {
            this.rset.skipTo(rowId);
            this.collectExecutables(uid == 0L, true);
        }
        for (int i = 0; i < this.totalElements; ++i) {
            if (this.executableElements[i].getID() != iid.getComponentID()) continue;
            this.currentElement = i;
            return;
        }
        this.currentElement = this.totalElements;
    }

    protected void collectExecutables() {
        this.collectExecutables(true, false);
    }

    protected void collectExecutables(boolean includeHeader, boolean startFromCurrentRow) {
        this.currentElement = 0;
        this.totalElements = 0;
        if (this.executableElements == null) {
            this.executableElements = new ReportItemDesign[3];
            ListingDesign listing = (ListingDesign)this.listingExecutor.getDesign();
            GroupDesign group = (GroupDesign)this.getDesign();
            int groupId = group.getGroupLevel() + 1;
            BandDesign header = group.getHeader();
            BandDesign footer = group.getFooter();
            ReportItemDesign detail = null;
            boolean hiddenDetail = group.getHideDetail();
            if (!hiddenDetail) {
                int groupCount = listing.getGroupCount();
                detail = groupId >= groupCount ? listing.getDetail() : listing.getGroup(groupId);
            }
            IResultSet rset = this.listingExecutor.getResultSet();
            this.executorUtil = new ListingElementExecutorUtil(groupId, header, footer, detail, rset, includeHeader);
        }
        if (startFromCurrentRow) {
            this.executorUtil.startFromCurrentRow();
        }
        this.totalElements = this.executorUtil.collectExecutableElements(this.executableElements);
    }
}

