/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public class ListBandExecutor
extends ContainerExecutor {
    private int nextItem = 0;

    protected ListBandExecutor(ExecutorManager manager) {
        super(manager, 11);
    }

    protected IContent doCreateContent() {
        return this.report.createListBandContent();
    }

    protected void doExecute() throws Exception {
    }

    public void close() {
        this.nextItem = 0;
        super.close();
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        if (this.nextItem < bandDesign.getContentCount()) {
            ReportItemDesign design = bandDesign.getContent(this.nextItem);
            ++this.nextItem;
            return this.manager.createExecutor(this, design, offset);
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        int contentCount = bandDesign.getContentCount();
        long contentDesignId = id.getComponentID();
        for (int i = 0; i < contentCount; ++i) {
            ReportItemDesign childDesign = bandDesign.getContent(i);
            if (contentDesignId != childDesign.getID()) continue;
            this.nextItem = i;
            return;
        }
        this.nextItem = contentCount;
    }
}

