/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class ReportItemExecutor
implements IReportItemExecutor {
    protected ExecutorManager manager;
    protected int executorType;
    protected CachedReportContentReaderV3 reader;
    protected IReportContent report;
    protected ExecutionContext context;
    protected ReportItemExecutor parent;
    protected ReportItemDesign design;
    private InstanceID instanceId;
    protected IContent content;
    protected long offset;
    protected Fragment fragment;
    protected IResultSet rset;
    protected boolean rsetEmpty;
    protected boolean executed;
    protected long uniqueId;

    protected ReportItemExecutor(ExecutorManager manager, int type) {
        this.manager = manager;
        this.executorType = type;
        this.context = manager.getExecutionContext();
        this.reader = manager.getReportReader();
        this.report = this.context.getReportContent();
        this.parent = null;
        this.design = null;
        this.offset = -1L;
        this.fragment = null;
        this.rset = null;
        this.rsetEmpty = true;
        this.executed = false;
        this.content = null;
        this.instanceId = null;
        this.uniqueId = 0L;
    }

    int getExecutorType() {
        return this.executorType;
    }

    void setParent(ReportItemExecutor parent) {
        this.parent = parent;
        if (parent != null) {
            this.reader = parent.reader;
        }
    }

    ReportItemExecutor getParent() {
        return this.parent;
    }

    void setDesign(ReportItemDesign design) {
        this.design = design;
        this.context.setItemDesign(design);
    }

    ReportItemDesign getDesign() {
        return this.design;
    }

    IContent getContent() {
        return this.content;
    }

    void setOffset(long offset) {
        this.offset = offset;
    }

    void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    Fragment getFragment() {
        return this.fragment;
    }

    protected IContent doCreateContent() {
        long id = this.design == null ? -1L : this.design.getID();
        throw new IllegalStateException("can't re-generate content for design " + id);
    }

    protected void doExecute() throws Exception {
    }

    private IContent getParentContent() {
        while (this.parent != null) {
            IContent content = this.parent.getContent();
            if (content != null) {
                return content;
            }
            this.parent = this.parent.getParent();
        }
        return null;
    }

    public IContent execute() {
        if (!this.executed) {
            this.executed = true;
            try {
                InstanceID instanceId = this.getInstanceID();
                if (this.offset != -1L) {
                    this.content = this.reader.loadContent(this.offset);
                    InstanceID id = this.content.getInstanceID();
                    if (!this.isSameInstance(instanceId, id)) {
                        this.content = this.doCreateContent();
                        this.content.setInstanceID(instanceId);
                    }
                } else {
                    this.content = this.doCreateContent();
                }
                this.content.setGenerateBy(this.design);
                this.content.setInstanceID(instanceId);
                IContent pContent = this.getParentContent();
                if (pContent != null) {
                    this.content.setParent(pContent);
                }
                this.doExecute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.content;
    }

    public boolean hasNextChild() {
        return false;
    }

    public IReportItemExecutor getNextChild() {
        return null;
    }

    IResultSet getResultSet() {
        return this.rset;
    }

    public void close() {
        if (this.offset != -1L) {
            this.reader.unloadContent(this.offset);
            this.offset = -1L;
        }
        this.parent = null;
        this.reader = null;
        this.design = null;
        this.fragment = null;
        this.rset = null;
        this.rsetEmpty = true;
        this.executed = false;
        this.content = null;
        this.instanceId = null;
        this.uniqueId = 0L;
        if (this.executorType != -1) {
            this.manager.releaseExecutor(this);
        }
    }

    protected void closeQuery() {
        if (this.rset != null) {
            this.rset.close();
            this.rset = null;
        }
    }

    protected void executeQuery() {
        IBaseQueryDefinition query = this.design.getQuery();
        if (query != null) {
            try {
                IResultSet pRset = this.getParentResultSet();
                this.rset = this.context.executeQuery(pRset, query);
                this.rsetEmpty = true;
                if (this.rset != null) {
                    this.rsetEmpty = !this.rset.next();
                    return;
                }
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
        }
    }

    IResultSet getParentResultSet() {
        ReportItemExecutor pExecutor = this.getParent();
        while (pExecutor != null) {
            IResultSet rset = pExecutor.getResultSet();
            if (rset != null) {
                return rset;
            }
            pExecutor = pExecutor.parent;
        }
        return null;
    }

    long getUniqueID() {
        if (this.parent != null) {
            return this.parent.uniqueId++;
        }
        return this.manager.generateUniqueID();
    }

    protected InstanceID getInstanceID() {
        if (this.instanceId == null) {
            IResultSet rset;
            long uid = this.getUniqueID();
            InstanceID pid = this.parent == null ? null : this.parent.getInstanceID();
            long id = this.design == null ? -1L : this.design.getID();
            DataID dataId = null;
            if (this.parent != null && (rset = this.parent.getResultSet()) != null) {
                DataSetID dataSetID = rset.getID();
                long position = rset.getCurrentPosition();
                dataId = new DataID(dataSetID, position);
            }
            this.instanceId = new InstanceID(pid, uid, id, dataId);
        }
        return this.instanceId;
    }

    protected boolean isSameInstance(InstanceID a, InstanceID b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.getUniqueID() == b.getUniqueID();
    }
}

