/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.util.Comparator;
import org.eclipse.birt.report.engine.internal.executor.doc.FragmentComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;

public class Fragment {
    Object index;
    Segment segment;
    Fragment next;
    Fragment child;
    Comparator comparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Fragment(Comparator comparator) {
        this(comparator, null);
    }

    public Fragment(Comparator comparator, Object offset) {
        this.comparator = comparator instanceof FragmentComparator ? comparator : new FragmentComparator(comparator);
        this.index = offset;
        this.segment = new Segment(this.comparator);
    }

    public Fragment getFragment(Object offset) {
        Fragment frag = this.child;
        while (frag != null) {
            if (this.comparator.compare(frag.index, offset) == 0) {
                return frag;
            }
            frag = frag.next;
        }
        return null;
    }

    public Fragment getNextFragment(Object offset) {
        if (offset == Segment.LEFT_MOST_EDGE) {
            return this.child;
        }
        if (offset == Segment.RIGHT_MOST_EDGE) {
            return null;
        }
        Fragment frag = this.child;
        while (frag != null) {
            if (this.comparator.compare(frag.index, offset) > 0) {
                return frag;
            }
            frag = frag.next;
        }
        return null;
    }

    public Fragment getFirstFragment() {
        return this.child;
    }

    public void addFragment(Object[] leftEdges, Object[] rightEdges) {
        Fragment leftEdge = this;
        for (int i = 0; i < leftEdges.length; ++i) {
            leftEdge.segment.startSegment(leftEdges[i]);
            leftEdge = this.addFragment(leftEdge, leftEdges[i]);
        }
        leftEdge.segment.startSegment(Segment.LEFT_MOST_EDGE);
        Fragment rightEdge = this;
        for (int i = 0; i < rightEdges.length; ++i) {
            rightEdge.segment.endSegment(rightEdges[i]);
            rightEdge = this.addFragment(rightEdge, rightEdges[i]);
        }
        rightEdge.segment.endSegment(Segment.LEFT_MOST_EDGE);
        this.segment.normalize();
    }

    private Fragment addFragment(Fragment parent, Object offset) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        Fragment prev = null;
        Fragment frag = parent.child;
        while (frag != null) {
            int result = this.comparator.compare(frag.index, offset);
            if (result == 0) {
                return frag;
            }
            if (result == 1) break;
            prev = frag;
            frag = frag.next;
        }
        frag = new Fragment(this.comparator, offset);
        if (prev != null) {
            if (prev.next != null) {
                frag.next = prev.next.next;
            }
            prev.next = frag;
        } else if (parent != null) {
            frag.next = parent.child;
            parent.child = frag;
        }
        return frag;
    }

    public boolean inFragment(Object offset) {
        return this.segment.inSegment(offset);
    }

    public Object getOffset() {
        return this.index;
    }

    public Object[][] getSections() {
        if (this.segment != null) {
            this.segment.normalize();
            return this.segment.sections;
        }
        return null;
    }

    static {
        $assertionsDisabled = !Fragment.class.desiredAssertionStatus();
    }
}

