/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.PageRangeIterator;
import org.eclipse.birt.report.engine.internal.executor.doc.AbstractReportReader;
import org.eclipse.birt.report.engine.internal.executor.doc.BodyReader;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.LongComparator;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.PageSection;

public class ReportPageReader
extends AbstractReportReader {
    private boolean paged;
    private ArrayList outputPages = new ArrayList();
    private PageRangeIterator pageIter;
    private BodyReader bodyExecutor;

    public ReportPageReader(ExecutionContext context, List pages, boolean paged) throws IOException {
        super(context);
        this.outputPages.addAll(pages);
        this.paged = paged;
        this.pageIter = new PageRangeIterator(this.outputPages);
        if (!paged) {
            Fragment fragment = this.loadPageFragment(this.outputPages);
            this.bodyExecutor = new BodyReader(this, fragment);
        }
    }

    public void close() {
        if (this.bodyExecutor != null) {
            this.bodyExecutor.close();
            this.bodyExecutor = null;
        }
        super.close();
    }

    protected Long[] createEdges(long offset) throws IOException {
        LinkedList<Long> parents = new LinkedList<Long>();
        for (IContent content = this.reader.loadContent(offset); content != null; content = (IContent)content.getParent()) {
            DocumentExtension ext = (DocumentExtension)content.getExtension(0);
            if (ext == null) continue;
            parents.addFirst(new Long(ext.getIndex()));
        }
        Long[] edges = new Long[parents.size()];
        Iterator iter = parents.iterator();
        int length = 0;
        while (iter.hasNext()) {
            Long value = (Long)iter.next();
            edges[length++] = value;
        }
        return edges;
    }

    protected Fragment loadPageFragment(List pages) throws IOException {
        Fragment fragment = new Fragment(new LongComparator());
        PageRangeIterator iter = new PageRangeIterator(pages);
        while (iter.hasNext()) {
            long pageNumber = iter.next();
            IPageHint pageHint = this.hintReader.getPageHint(pageNumber);
            if (pageHint == null) continue;
            int sectCount = pageHint.getSectionCount();
            for (int i = 0; i < sectCount; ++i) {
                PageSection section = pageHint.getSection(i);
                long left = section.startOffset;
                long right = section.endOffset;
                Object[] leftEdges = this.createEdges(left);
                Object[] rightEdges = this.createEdges(right);
                fragment.addFragment(leftEdges, rightEdges);
            }
        }
        return fragment;
    }

    Fragment loadPageFragment(long pageNumber) throws IOException {
        Fragment fragment = new Fragment(new LongComparator());
        IPageHint pageHint = this.hintReader.getPageHint(pageNumber);
        if (pageHint != null) {
            int sectionCount = pageHint.getSectionCount();
            for (int i = 0; i < sectionCount; ++i) {
                try {
                    PageSection section = pageHint.getSection(i);
                    long left = section.startOffset;
                    long right = section.endOffset;
                    Object[] leftEdges = this.createEdges(left);
                    Object[] rightEdges = this.createEdges(right);
                    fragment.addFragment(leftEdges, rightEdges);
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "Can't load the page hints", ex);
                }
            }
        }
        return fragment;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            try {
                if (this.paged) {
                    long pageNumber = this.pageIter.next();
                    Fragment fragment = this.loadPageFragment(pageNumber);
                    return new BodyReader(this, fragment);
                }
                return this.bodyExecutor.getNextChild();
            }
            catch (IOException ex) {
                this.context.addException(new EngineException("can't load the pages", ex));
            }
        }
        return null;
    }

    public boolean hasNextChild() {
        if (this.paged) {
            return this.pageIter.hasNext();
        }
        return this.bodyExecutor.hasNextChild();
    }
}

