/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.emitter;

import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.emitter.ExecutorManager;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;

public class ReportEmitterExecutor
implements IReportExecutor {
    IReportContent report;
    IReportExecutor executor;
    IContentEmitter emitter;
    ExecutorManager manager = new ExecutorManager();

    public ReportEmitterExecutor(IReportExecutor executor, IContentEmitter emitter) {
        this.executor = executor;
        this.emitter = emitter;
    }

    public void close() {
        if (this.report != null) {
            this.emitter.end(this.report);
        }
        this.executor.close();
    }

    public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
        return this.executor.createPageExecutor(pageNumber, pageDesign);
    }

    public IReportContent execute() {
        this.report = this.executor.execute();
        if (this.report != null) {
            this.emitter.start(this.report);
        }
        return this.report;
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.executor.getNextChild();
        if (childExecutor != null) {
            return this.manager.createExecutor(childExecutor, this.emitter);
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.executor.hasNextChild();
    }
}

