/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.emitter;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;

public class ReportItemEmitterExecutor
implements IReportItemExecutor {
    IContent content;
    IReportItemExecutor executor;
    IContentEmitter emitter;

    ReportItemEmitterExecutor() {
    }

    ReportItemEmitterExecutor(IReportItemExecutor executor, IContentEmitter emitter) {
        this.content = null;
        this.executor = executor;
        this.emitter = emitter;
    }

    public void close() {
        if (this.content != null) {
            ContentEmitterUtil.endContent(this.content, this.emitter);
        }
        this.executor.close();
    }

    public IContent execute() {
        this.content = this.executor.execute();
        if (this.content != null) {
            ContentEmitterUtil.startContent(this.content, this.emitter);
        }
        return this.content;
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor childExecutor = this.executor.getNextChild();
        if (childExecutor != null) {
            return this.createExecutor(childExecutor, this.emitter);
        }
        return null;
    }

    public boolean hasNextChild() {
        return this.executor.hasNextChild();
    }

    protected IReportItemExecutor createExecutor(IReportItemExecutor executor, IContentEmitter emitte) {
        return new ReportItemEmitterExecutor(executor, this.emitter);
    }
}

