/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.content;

import java.util.Collection;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.content.BlockStackingExecutor;
import org.eclipse.birt.report.engine.layout.content.ItemExecutorWrapper;

public class ListContainerExecutor
extends BlockStackingExecutor
implements IReportItemExecutor {
    protected boolean repeat = false;
    static /* synthetic */ Class class$org$eclipse$birt$report$engine$layout$content$ListContainerExecutor;

    public ListContainerExecutor(IContent content, IReportItemExecutor executor) {
        super(content, null);
        this.executor = new ExecutorList(executor, content);
        if (content instanceof IGroupContent) {
            this.repeat = ((IGroupContent)content).isHeaderRepeat();
        } else if (content instanceof IListContent) {
            this.repeat = ((IListContent)content).isHeaderRepeat();
        }
    }

    private void add(Collection collection, IContent content) {
        if (!collection.contains(content)) {
            collection.add(content);
        }
    }

    protected class ExecutorList
    implements IReportItemExecutor {
        protected IReportItemExecutor currentRunIn = null;
        protected IReportItemExecutor executor = null;
        protected IContent content = null;
        protected IReportItemExecutor childExecutor = null;
        protected IContent childContent = null;
        protected boolean hasNext = false;
        protected boolean needUpdate = true;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ExecutorList(IReportItemExecutor executor, IContent content) {
            this.content = content;
            this.executor = executor;
        }

        public void close() {
            if (this.currentRunIn != null) {
                this.currentRunIn.close();
            }
            this.executor.close();
        }

        public IContent execute() {
            return this.content;
        }

        public IReportItemExecutor getNextChild() {
            if (this.childContent != null) {
                ItemExecutorWrapper ret = new ItemExecutorWrapper(this.childExecutor, this.childContent);
                this.childContent = null;
                this.childExecutor = null;
                this.needUpdate = true;
                return ret;
            }
            if (this.currentRunIn != null) {
                IContent runInContent;
                this.needUpdate = true;
                IReportItemExecutor runInChild = this.currentRunIn.getNextChild();
                if (runInChild != null && (runInContent = runInChild.execute()) != null && (runInContent.getChildren() == null || runInContent.getChildren().size() == 0)) {
                    this.execute(runInChild, runInContent);
                    runInChild.close();
                    runInChild = new DOMReportItemExecutor(runInContent);
                }
                return runInChild;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public boolean hasNextChild() {
            if (!this.needUpdate) {
                return this.hasNext;
            }
            if (this.currentRunIn != null) {
                if (this.currentRunIn.hasNextChild()) {
                    this.hasNext = true;
                    this.needUpdate = false;
                    return this.hasNext;
                }
                this.currentRunIn.close();
            }
            this.currentRunIn = null;
            while (this.executor.hasNextChild()) {
                IReportItemExecutor next = this.executor.getNextChild();
                IContent nextContent = next.execute();
                if (nextContent instanceof IListBandContent) {
                    IListBandContent band = (IListBandContent)nextContent;
                    if (ListContainerExecutor.this.repeat && (band.getBandType() == 1 || band.getBandType() == 3)) {
                        this.executeHeader(next, nextContent);
                        next.close();
                        next = new DOMReportItemExecutor(nextContent);
                        next.execute();
                        ListContainerExecutor.this.add(nextContent.getParent().getChildren(), nextContent);
                    }
                    if (!next.hasNextChild()) continue;
                    this.currentRunIn = next;
                    break;
                }
                this.childExecutor = next;
                this.childContent = nextContent;
                break;
            }
            this.hasNext = this.currentRunIn != null || this.childContent != null;
            this.needUpdate = false;
            return this.hasNext;
        }

        protected void execute(IReportItemExecutor executor, IContent content) {
            while (executor.hasNextChild()) {
                IReportItemExecutor childExecutor = executor.getNextChild();
                if (childExecutor == null) continue;
                IContent childContent = childExecutor.execute();
                ListContainerExecutor.this.add(content.getChildren(), childContent);
                this.execute(childExecutor, childContent);
                childExecutor.close();
            }
        }

        protected void executeHeader(IReportItemExecutor executor, IContent content) {
            while (executor.hasNextChild()) {
                IReportItemExecutor childExecutor = executor.getNextChild();
                if (childExecutor == null) continue;
                IContent childContent = childExecutor.execute();
                this.removePageBreak(childContent);
                ListContainerExecutor.this.add(content.getChildren(), childContent);
                this.execute(childExecutor, childContent);
                childExecutor.close();
            }
        }

        protected void removePageBreak(IContent content) {
            IStyle style = content.getStyle();
            if (style != null) {
                style.setProperty(51, IStyle.AUTO_VALUE);
                style.setProperty(46, IStyle.AUTO_VALUE);
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$layout$content$ListContainerExecutor == null ? (class$org$eclipse$birt$report$engine$layout$content$ListContainerExecutor = ListContainerExecutor.class$("org.eclipse.birt.report.engine.layout.content.ListContainerExecutor")) : class$org$eclipse$birt$report$engine$layout$content$ListContainerExecutor).desiredAssertionStatus();
        }
    }
}

