/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;

public class HTMLGroupLM
extends HTMLBlockStackingLM {
    boolean isFirstLayout = true;

    public HTMLGroupLM(HTMLLayoutManagerFactory factory) {
        super(factory);
    }

    public int getType() {
        return 8;
    }

    public void initialize(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        super.initialize(parent, content, executor, emitter);
        this.isFirstLayout = true;
    }

    protected void repeatHeader() {
        if (!this.isFirstLayout) {
            IGroupContent group = (IGroupContent)this.content;
            IBandContent header = group.getHeader();
            if (group.isHeaderRepeat() && header != null) {
                boolean pageBreak = this.context.allowPageBreak();
                boolean pageEmpty = this.context.isPageEmpty();
                this.context.setAllowPageBreak(pageBreak);
                this.context.setPageEmpty(true);
                this.engine.layout(header, this.emitter);
                this.context.setAllowPageBreak(pageBreak);
                this.context.setPageEmpty(pageEmpty);
                this.context.endContentWithPageBreak(null);
            }
        }
        this.isFirstLayout = false;
    }

    protected boolean layoutChildren() {
        this.repeatHeader();
        boolean hasNext = super.layoutChildren();
        return hasNext;
    }
}

