/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutorUtil;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;

public class HTMLPageLM
extends HTMLBlockStackingLM {
    protected IReportContent report;
    protected long pageNumber = 0L;
    protected long startOffset;
    protected long endOffset;
    protected IPageContent pageContent;
    protected IReportExecutor reportExecutor = null;
    boolean isLastPage = false;
    boolean hasStartPage = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLPageLM(HTMLReportLayoutEngine engine, IReportContent report, IReportExecutor executor, IContentEmitter emitter) {
        super(engine.getFactory());
        this.report = report;
        this.reportExecutor = executor;
        this.emitter = emitter;
        this.executor = new IReportItemExecutor(){

            public void close() {
            }

            public IContent execute() {
                return HTMLPageLM.this.pageContent;
            }

            public IReportItemExecutor getNextChild() {
                return HTMLPageLM.this.reportExecutor.getNextChild();
            }

            public boolean hasNextChild() {
                return HTMLPageLM.this.reportExecutor.hasNextChild();
            }
        };
    }

    public int getType() {
        return 2;
    }

    public boolean layout() {
        if (this.context.getCancelFlag()) {
            this.close();
            this.isLastPage = true;
            return false;
        }
        boolean hasNextPage = this.layoutChildren();
        if (this.isChildrenFinished()) {
            this.isLastPage = true;
        }
        if (this.isLastPage && !this.hasStartPage && this.pageNumber == 0L) {
            this.start();
        }
        this.end();
        return hasNextPage;
    }

    protected boolean layoutChildren() {
        boolean hasNext = false;
        this.hasStartPage = false;
        if (this.childLayout != null) {
            this.start();
            this.hasStartPage = true;
            hasNext = this.childLayout.layout();
            if (this.childLayout.isFinished()) {
                this.childLayout.close();
                this.childExecutor.close();
                this.childLayout = null;
                this.childExecutor = null;
            }
            if (hasNext) {
                return true;
            }
        }
        while (this.executor.hasNextChild() && !this.context.getCancelFlag()) {
            this.childExecutor = this.executor.getNextChild();
            IContent childContent = this.childExecutor.execute();
            if (childContent != null) {
                if (!this.hasStartPage) {
                    this.hasStartPage = true;
                    String masterPage = childContent.getStyle().getMasterPage();
                    if (masterPage != null) {
                        this.context.setMasterPage(masterPage);
                    }
                    this.start();
                }
                this.childLayout = this.engine.createLayoutManager(this, childContent, this.childExecutor, this.emitter);
                hasNext = this.childLayout.layout();
                if (hasNext) {
                    if (this.childLayout.isFinished()) {
                        this.childLayout.close();
                        this.childExecutor.close();
                        this.childLayout = null;
                        this.childExecutor = null;
                    }
                    return true;
                }
                this.childLayout.close();
                this.childLayout = null;
            }
            this.childExecutor.close();
            this.childExecutor = null;
        }
        return false;
    }

    public boolean isFinished() {
        return this.isLastPage;
    }

    protected void pageBreakEvent() {
        ILayoutPageHandler pageHandler = this.engine.getPageHandler();
        if (pageHandler != null) {
            pageHandler.onPage(this.pageNumber, this.context);
        }
    }

    protected void start() {
        if (this.pageContent == null) {
            MasterPageDesign pageDesign = this.getMasterPage(this.report);
            ++this.pageNumber;
            this.context.setPageNumber(this.pageNumber);
            this.pageContent = ReportExecutorUtil.executeMasterPage(this.reportExecutor, this.pageNumber, pageDesign);
            if (this.emitter != null) {
                this.emitter.startPage(this.pageContent);
            }
        }
    }

    protected void end() {
        if (this.isLastPage) {
            if (this.pageNumber == 1L) {
                this.context.setPageEmpty(false);
            }
            if (this.context.isPageEmpty()) {
                --this.pageNumber;
                this.context.setPageNumber(this.pageNumber);
            }
        }
        if (!this.context.isPageEmpty()) {
            if (!$assertionsDisabled && this.pageContent == null) {
                throw new AssertionError();
            }
            if (this.emitter != null) {
                this.emitter.endPage(this.pageContent);
            }
            this.pageBreakEvent();
            this.pageContent = null;
            this.context.setPageEmpty(true);
            this.context.clearPageHint();
        }
    }

    static {
        $assertionsDisabled = !HTMLPageLM.class.desiredAssertionStatus();
    }
}

