/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFPageLM;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;

public class PDFReportLayoutEngine
implements IReportLayoutEngine {
    protected IReportExecutor executor;
    protected PDFLayoutEngineContext context;
    protected PDFLayoutManagerFactory factory;
    protected ILayoutPageHandler handle;
    protected HashMap options = new HashMap();
    protected Locale locale;

    public PDFReportLayoutEngine() {
        this.context = new PDFLayoutEngineContext(this);
        this.factory = new PDFLayoutManagerFactory(this.context);
        this.context.setFactory(this.factory);
    }

    protected PDFLayoutManagerFactory createLayoutManagerFactory(PDFLayoutEngineContext context) {
        return new PDFLayoutManagerFactory(this.context);
    }

    protected void layoutReport(IReportContent report, IReportExecutor executor, IContentEmitter output) {
        if (output == null) {
            return;
        }
        FontHandler.prepareFonts();
        PDFPageLM pageLM = new PDFPageLM(this, this.context, report, output, executor);
        while (pageLM.layout()) {
        }
    }

    protected void setupLayoutOptions() {
        Object pageBreakOnly;
        Object fitToPage = this.options.get("fitToPage");
        if (fitToPage != null && fitToPage instanceof Boolean && ((Boolean)fitToPage).booleanValue()) {
            this.context.setFitToPage(true);
        }
        if ((pageBreakOnly = this.options.get("pagebreakPaginationOnly")) != null && pageBreakOnly instanceof Boolean && ((Boolean)pageBreakOnly).booleanValue()) {
            this.context.setPagebreakPaginationOnly(true);
        }
    }

    public void layout(IReportExecutor executor, IReportContent report, IContentEmitter output, boolean pagination) {
        this.context.setAllowPageBreak(pagination);
        this.executor = executor;
        this.setupLayoutOptions();
        if (this.locale != null) {
            this.context.setLocale(this.locale);
        } else {
            this.context.setLocale(Locale.getDefault());
        }
        this.context.setReport(report);
        if (output != null) {
            this.context.setFormat(output.getOutputFormat());
        }
        this.layoutReport(report, executor, output);
    }

    public void layout(IReportItemExecutor executor, IContentEmitter emitter) {
        IContent content = executor.execute();
        PDFAbstractLM layoutManager = this.factory.createLayoutManager(null, content, executor);
        layoutManager.layout();
        layoutManager.close();
    }

    public void layout(IContent content, IContentEmitter output) {
        DOMReportItemExecutor executor = new DOMReportItemExecutor(content);
        this.layout(executor, output);
        executor.close();
    }

    public void setPageHandler(ILayoutPageHandler handle) {
        this.handle = handle;
    }

    public ILayoutPageHandler getPageHandler() {
        return this.handle;
    }

    public void cancel() {
        if (this.context != null) {
            this.context.setCancel(true);
        }
    }

    public void setOption(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getOption(String name) {
        return this.options.get(name);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

