/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class FontConfigReader {
    private static final String CONFIG_FILE_PATH = "/fontsConfig.xml";
    private static final String TAG_BLOCK = "block";
    private static final String TAG_MAPPING = "mapping";
    private static final String TAG_PATH = "path";
    private static final String TAG_ENCODING = "encoding";
    private static final String PROP_BLOCK_INDEX = "index";
    private static final String PROP_NAME = "name";
    private static final String PROP_FONT_FAMILY = "font-family";
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_PATH = "path";
    private FontMappingManager fontMappingManager = new FontMappingManager();
    private ArrayList fontPaths = new ArrayList();
    protected static Logger logger = Logger.getLogger(FontConfigReader.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseConfigFile() {
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
            if (bundle == null) {
                return false;
            }
            URL fileURL = bundle.getEntry(CONFIG_FILE_PATH);
            if (null == fileURL) {
                return false;
            }
            InputStream cfgFile = fileURL.openStream();
            try {
                InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(cfgFile), Charset.forName("UTF-8"));
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(r));
                this.handleFontMappings(doc);
                this.handleAllFonts(doc);
                this.handleFontPaths(doc);
                this.handleFontEncodings(doc);
            }
            finally {
                cfgFile.close();
            }
            return true;
        }
        catch (Exception se) {
            logger.log(Level.WARNING, se.getMessage(), se);
            return false;
        }
    }

    public String getEmbededFontPath() {
        Path path;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.birt.report.engine.fonts");
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)(path = new Path("/fonts")), null);
        if (null == fileURL) {
            return null;
        }
        String fontPath = null;
        try {
            fontPath = FileLocator.toFileURL((URL)fileURL).getPath();
            return fontPath.substring(1);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, ioe.getMessage(), ioe);
            return null;
        }
    }

    public List getTrueTypeFontPaths() {
        return this.fontPaths;
    }

    public FontMappingManager getFontMappingManager() {
        return this.fontMappingManager;
    }

    private void handleFontEncodings(Document doc) {
        HashMap<String, String> fontEncoding = new HashMap<String, String>();
        NodeList encodings = doc.getDocumentElement().getElementsByTagName("encoding");
        for (int i = 0; i < encodings.getLength(); ++i) {
            Node node = encodings.item(i);
            String fontFamily = this.getProperty(node, PROP_FONT_FAMILY);
            String encoding = this.getProperty(node, "encoding");
            if (!this.isValidValue(encoding) || !this.isValidValue(fontFamily)) continue;
            fontEncoding.put(fontFamily, encoding);
        }
        this.fontMappingManager.addFontEncoding(fontEncoding);
    }

    private void handleFontPaths(Document doc) {
        NodeList paths = doc.getDocumentElement().getElementsByTagName("path");
        for (int i = 0; i < paths.getLength(); ++i) {
            Node node = paths.item(i);
            String path = this.getProperty(node, "path");
            if (!this.isValidValue(path)) continue;
            this.fontPaths.add(path);
        }
    }

    private void handleFontMappings(Document doc) {
        HashMap<String, String> fontMapping = new HashMap<String, String>();
        NodeList mappings = doc.getDocumentElement().getElementsByTagName(TAG_MAPPING);
        for (int i = 0; i < mappings.getLength(); ++i) {
            Node node = mappings.item(i);
            String name = this.getProperty(node, PROP_NAME);
            String fontFamily = this.getProperty(node, PROP_FONT_FAMILY);
            if (!this.isValidValue(name) || !this.isValidValue(fontFamily)) continue;
            fontMapping.put(name, fontFamily);
        }
        this.fontMappingManager.addFontMapping(fontMapping);
    }

    private void handleAllFonts(Document doc) {
        NodeList blocks = doc.getDocumentElement().getElementsByTagName(TAG_BLOCK);
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node blockNode = blocks.item(i);
            String blockIndex = this.getProperty(blockNode, PROP_BLOCK_INDEX);
            if (!this.isValidValue(blockIndex)) continue;
            int index = Integer.parseInt(blockIndex);
            NodeList mappings = blockNode.getChildNodes();
            for (int j = 0; j < mappings.getLength(); ++j) {
                String fontFamily;
                Node node = mappings.item(j);
                if (node.getNodeType() != 1 || !this.isValidValue(fontFamily = this.getProperty(node, PROP_FONT_FAMILY))) continue;
                this.fontMappingManager.setFontMappingByBlockIndex(index, fontFamily);
            }
        }
    }

    private boolean isValidValue(String propertyName) {
        return null != propertyName && propertyName.length() != 0;
    }

    private String getProperty(Node node, String propertyName) {
        Node property;
        if (null == node) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (null != atts && null != (property = atts.getNamedItem(propertyName))) {
            return property.getNodeValue();
        }
        return null;
    }
}

