/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetMetaDataDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSetEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DataSetScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptedDataSetMetaData;
import org.eclipse.birt.report.engine.script.internal.UpdatableDataSetRow;
import org.eclipse.birt.report.engine.script.internal.instance.DataSetInstance;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;

public class ScriptDataSetScriptExecutor
extends DataSetScriptExecutor
implements IScriptDataSetEventHandler {
    private static final String OPEN = "OPEN";
    private static final String CLOSE = "CLOSE";
    private static final String FETCH = "FETCH";
    private static final String DESCRIBE = "DESCRIBE";
    private IScriptedDataSetEventHandler scriptedEventHandler;

    public ScriptDataSetScriptExecutor(ScriptDataSetHandle dataSetHandle, ExecutionContext context) {
        super((DataSetHandle)dataSetHandle, context);
    }

    protected void initEventHandler(String className) {
        super.initEventHandler(className);
        if (this.eventHandler != null) {
            try {
                this.scriptedEventHandler = (IScriptedDataSetEventHandler)this.eventHandler;
            }
            catch (ClassCastException e) {
                ScriptDataSetScriptExecutor.addClassCastException(this.context, e, className, IScriptedDataSetEventHandler.class);
            }
        }
    }

    public void handleOpen(IDataSetInstanceHandle dataSet) throws BirtException {
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), OPEN, ((ScriptDataSetHandle)this.dataSetHandle).getOpen());
            if (status.didRun()) {
                return;
            }
            if (this.scriptedEventHandler != null) {
                this.scriptedEventHandler.open(new DataSetInstance(dataSet));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleClose(IDataSetInstanceHandle dataSet) {
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), CLOSE, ((ScriptDataSetHandle)this.dataSetHandle).getClose());
            if (status.didRun()) {
                return;
            }
            if (this.scriptedEventHandler != null) {
                this.scriptedEventHandler.close(new DataSetInstance(dataSet));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
    }

    public boolean handleFetch(IDataSetInstanceHandle dataSet, IDataRow row) {
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), FETCH, ((ScriptDataSetHandle)this.dataSetHandle).getFetch());
            if (status.didRun()) {
                Object result = status.result();
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new DataException("data.engine.BadFetchScriptReturnType", (Object)"Fetch");
            }
            if (this.scriptedEventHandler != null) {
                return this.scriptedEventHandler.fetch(new DataSetInstance(dataSet), new UpdatableDataSetRow(row));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
        return false;
    }

    public boolean handleDescribe(IDataSetInstanceHandle dataSet, IScriptDataSetMetaDataDefinition metaData) throws BirtException {
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSet.getScriptScope(), dataSet.getName(), DESCRIBE, ((ScriptDataSetHandle)this.dataSetHandle).getDescribe());
            if (status.didRun()) {
                Object result = status.result();
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new DataException("data.engine.BadFetchScriptReturnType", (Object)"Describe");
            }
            if (this.scriptedEventHandler != null) {
                return this.scriptedEventHandler.describe(new DataSetInstance(dataSet), new ScriptedDataSetMetaData(metaData));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
        return false;
    }
}

