/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.element;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDataBinding;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class DataBindingImpl
implements IDataBinding {
    private ComputedColumnHandle column;
    private ReportItemHandle handle;

    public DataBindingImpl(ComputedColumnHandle column, ReportItemHandle handle) {
        this.column = column;
        this.handle = handle;
    }

    public String getAggregateOn() {
        return this.column.getAggregateOn();
    }

    public String getDataType() {
        return this.column.getDataType();
    }

    public String getExpression() {
        return this.column.getExpression();
    }

    public String getName() {
        return this.column.getName();
    }

    public void setAggregateOn(String on) throws ScriptException {
        this.checkHandle();
        this.column.setAggregateOn(on);
    }

    public void setDataType(String dataType) throws ScriptException {
        this.checkHandle();
        try {
            this.column.setDataType(dataType);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setExpression(String expression) throws ScriptException {
        this.checkHandle();
        try {
            this.column.setExpression(expression);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setName(String name) throws ScriptException {
        this.checkHandle();
        try {
            this.column.setName(name);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    private void checkHandle() throws ScriptException {
        if (this.column != null) {
            return;
        }
        throw new ScriptException("ComputedColumnHandle is null");
    }
}

